/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.composite.custom.helper;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.editpolicies.IMaskManagedLabelEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.helper.StereotypedElementLabelHelper;
import org.eclipse.papyrus.uml.tools.utils.ICustomAppearance;
import org.eclipse.papyrus.uml.tools.utils.ParameterUtil;
import org.eclipse.uml2.uml.Parameter;

public class ParameterLabelHelper
extends StereotypedElementLabelHelper {
    private static ParameterLabelHelper labelHelper;
    protected final Map<String, String> masks = new HashMap<String, String>();

    public static ParameterLabelHelper getInstance() {
        if (labelHelper == null) {
            labelHelper = new ParameterLabelHelper();
        }
        return labelHelper;
    }

    public Collection<String> getMaskLabels() {
        return this.masks.values();
    }

    public Map<String, String> getMasks() {
        return this.masks;
    }

    protected ParameterLabelHelper() {
        this.masks.clear();
        this.masks.put("direction", "Direction");
        this.masks.put("name", "Name");
        this.masks.put("type", "Type");
    }

    protected String elementLabel(GraphicalEditPart editPart) {
        Parameter elem;
        Collection displayValue = ICustomAppearance.DEFAULT_UML_PARAMETER;
        IMaskManagedLabelEditPolicy policy = (IMaskManagedLabelEditPolicy)editPart.getEditPolicy((Object)"MaskManagedLabelPolicy");
        if (policy != null) {
            displayValue = policy.getCurrentDisplayValue();
        }
        if ((elem = this.getUMLElement(editPart)) != null) {
            return ParameterUtil.getCustomLabel((Parameter)elem, (Collection)displayValue);
        }
        return "";
    }

    public Parameter getUMLElement(GraphicalEditPart editPart) {
        return (Parameter)((View)editPart.getModel()).getElement();
    }
}

