/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.ui;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ExceptionDialog
extends Dialog {
    private static final Log LOG = LogFactory.getLog(ExceptionDialog.class);
    private String title;
    private String message;
    private Exception exception;
    private Button detailsButton;
    private Text exceptionText;
    private boolean exceptionAreaCreated = false;

    protected ExceptionDialog(Shell parentShell, String title, String message, Exception exception) {
        super(parentShell);
        this.title = title;
        this.message = message != null ? message : exception.getLocalizedMessage();
        this.exception = exception;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)composite);
        this.createMessageArea(composite);
        return composite;
    }

    protected Control createMessageArea(Composite composite) {
        Image image = this.getParentShell().getDisplay().getSystemImage(1);
        Label imageLabel = new Label(composite, 0);
        image.setBackground(imageLabel.getBackground());
        imageLabel.setImage(image);
        GridDataFactory.fillDefaults().align(0x1000000, 1).applyTo((Control)imageLabel);
        if (this.message != null) {
            Label messageLabel = new Label(composite, 64);
            messageLabel.setText(this.message);
            GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).hint(this.convertHorizontalDLUsToPixels(300), -1).applyTo((Control)messageLabel);
        }
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        if (this.exception != null) {
            this.detailsButton = this.createButton(parent, 13, IDialogConstants.SHOW_DETAILS_LABEL, false);
        }
    }

    protected void buttonPressed(int id) {
        if (id == 13) {
            this.toggleDetailsArea();
        } else {
            super.buttonPressed(id);
        }
    }

    private void toggleDetailsArea() {
        boolean opened = false;
        Point windowSize = this.getShell().getSize();
        if (this.exceptionAreaCreated) {
            this.exceptionText.dispose();
            this.exceptionAreaCreated = false;
            this.detailsButton.setText(IDialogConstants.SHOW_DETAILS_LABEL);
            opened = false;
        } else {
            this.exceptionText = this.createExceptionText((Composite)this.getContents());
            this.detailsButton.setText(IDialogConstants.HIDE_DETAILS_LABEL);
            this.getContents().getShell().layout();
            opened = true;
        }
        Point newSize = this.getShell().computeSize(-1, -1);
        int diffY = newSize.y - windowSize.y;
        if (opened && diffY > 0 || !opened && diffY < 0) {
            this.getShell().setSize(new Point(windowSize.x, windowSize.y + diffY));
        }
    }

    private Text createExceptionText(Composite parent) {
        Text exceptionText = new Text(parent, 2818);
        GridDataFactory.fillDefaults().grab(true, true).span(2, 1).applyTo((Control)exceptionText);
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        try {
            this.exception.printStackTrace(pw);
            exceptionText.setText(sw.toString());
        }
        finally {
            try {
                sw.close();
                pw.close();
            }
            catch (IOException e) {
                LOG.error((Object)"Closing stream failed", (Throwable)e);
            }
        }
        this.exceptionAreaCreated = true;
        return exceptionText;
    }

    public static int open(Shell parentShell, String title, Exception exception) {
        return ExceptionDialog.open(parentShell, title, exception.getLocalizedMessage(), exception);
    }

    public static int open(Shell parentShell, String title, String message, Exception exception) {
        ExceptionDialog dialog = new ExceptionDialog(parentShell, title, message, exception);
        return dialog.open();
    }

    protected boolean isResizable() {
        return true;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.title);
        newShell.setImage(this.getParentShell().getDisplay().getSystemImage(1));
    }
}

