/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.types.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.papyrus.infra.types.AdviceBindingConfiguration;
import org.eclipse.papyrus.infra.types.Annotation;
import org.eclipse.papyrus.infra.types.ContainerConfiguration;
import org.eclipse.papyrus.infra.types.EditHelperAdviceConfiguration;
import org.eclipse.papyrus.infra.types.ElementTypeSetConfiguration;
import org.eclipse.papyrus.infra.types.ElementTypesConfigurationsFactory;
import org.eclipse.papyrus.infra.types.ElementTypesConfigurationsPackage;
import org.eclipse.papyrus.infra.types.ExternallyRegisteredAdvice;
import org.eclipse.papyrus.infra.types.ExternallyRegisteredType;
import org.eclipse.papyrus.infra.types.IconEntry;
import org.eclipse.papyrus.infra.types.InheritanceKind;
import org.eclipse.papyrus.infra.types.MatcherConfiguration;
import org.eclipse.papyrus.infra.types.MetamodelTypeConfiguration;
import org.eclipse.papyrus.infra.types.SpecializationTypeConfiguration;
import org.eclipse.papyrus.infra.types.impl.AdviceBindingConfigurationImpl;
import org.eclipse.papyrus.infra.types.impl.AnnotationImpl;
import org.eclipse.papyrus.infra.types.impl.ContainerConfigurationImpl;
import org.eclipse.papyrus.infra.types.impl.EditHelperAdviceConfigurationImpl;
import org.eclipse.papyrus.infra.types.impl.ElementTypeSetConfigurationImpl;
import org.eclipse.papyrus.infra.types.impl.ExternallyRegisteredAdviceImpl;
import org.eclipse.papyrus.infra.types.impl.ExternallyRegisteredTypeImpl;
import org.eclipse.papyrus.infra.types.impl.IconEntryImpl;
import org.eclipse.papyrus.infra.types.impl.MatcherConfigurationImpl;
import org.eclipse.papyrus.infra.types.impl.MetamodelTypeConfigurationImpl;
import org.eclipse.papyrus.infra.types.impl.SpecializationTypeConfigurationImpl;

public class ElementTypesConfigurationsFactoryImpl
extends EFactoryImpl
implements ElementTypesConfigurationsFactory {
    public static ElementTypesConfigurationsFactory init() {
        try {
            ElementTypesConfigurationsFactory theElementTypesConfigurationsFactory = (ElementTypesConfigurationsFactory)EPackage.Registry.INSTANCE.getEFactory("http://www.eclipse.org/papyrus/infra/elementtypesconfigurations/1.2");
            if (theElementTypesConfigurationsFactory != null) {
                return theElementTypesConfigurationsFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new ElementTypesConfigurationsFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 0: {
                return this.createElementTypeSetConfiguration();
            }
            case 3: {
                return this.createIconEntry();
            }
            case 6: {
                return this.createContainerConfiguration();
            }
            case 8: {
                return this.createSpecializationTypeConfiguration();
            }
            case 12: {
                return this.createAnnotation();
            }
            case 13: {
                return this.createMetamodelTypeConfiguration();
            }
            case 14: {
                return this.createEditHelperAdviceConfiguration();
            }
            case 15: {
                return this.createAdviceBindingConfiguration();
            }
            case 16: {
                return this.createMatcherConfiguration();
            }
            case 17: {
                return this.createExternallyRegisteredType();
            }
            case 18: {
                return this.createExternallyRegisteredAdvice();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 19: {
                return this.createInheritanceKindFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 19: {
                return this.convertInheritanceKindToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    @Override
    public ElementTypeSetConfiguration createElementTypeSetConfiguration() {
        ElementTypeSetConfigurationImpl elementTypeSetConfiguration = new ElementTypeSetConfigurationImpl();
        return elementTypeSetConfiguration;
    }

    @Override
    public IconEntry createIconEntry() {
        IconEntryImpl iconEntry = new IconEntryImpl();
        return iconEntry;
    }

    @Override
    public ContainerConfiguration createContainerConfiguration() {
        ContainerConfigurationImpl containerConfiguration = new ContainerConfigurationImpl();
        return containerConfiguration;
    }

    @Override
    public SpecializationTypeConfiguration createSpecializationTypeConfiguration() {
        SpecializationTypeConfigurationImpl specializationTypeConfiguration = new SpecializationTypeConfigurationImpl();
        return specializationTypeConfiguration;
    }

    @Override
    public Annotation createAnnotation() {
        AnnotationImpl annotation = new AnnotationImpl();
        return annotation;
    }

    @Override
    public MetamodelTypeConfiguration createMetamodelTypeConfiguration() {
        MetamodelTypeConfigurationImpl metamodelTypeConfiguration = new MetamodelTypeConfigurationImpl();
        return metamodelTypeConfiguration;
    }

    @Override
    public EditHelperAdviceConfiguration createEditHelperAdviceConfiguration() {
        EditHelperAdviceConfigurationImpl editHelperAdviceConfiguration = new EditHelperAdviceConfigurationImpl();
        return editHelperAdviceConfiguration;
    }

    @Override
    public AdviceBindingConfiguration createAdviceBindingConfiguration() {
        AdviceBindingConfigurationImpl adviceBindingConfiguration = new AdviceBindingConfigurationImpl();
        return adviceBindingConfiguration;
    }

    @Override
    public MatcherConfiguration createMatcherConfiguration() {
        MatcherConfigurationImpl matcherConfiguration = new MatcherConfigurationImpl();
        return matcherConfiguration;
    }

    @Override
    public ExternallyRegisteredType createExternallyRegisteredType() {
        ExternallyRegisteredTypeImpl externallyRegisteredType = new ExternallyRegisteredTypeImpl();
        return externallyRegisteredType;
    }

    @Override
    public ExternallyRegisteredAdvice createExternallyRegisteredAdvice() {
        ExternallyRegisteredAdviceImpl externallyRegisteredAdvice = new ExternallyRegisteredAdviceImpl();
        return externallyRegisteredAdvice;
    }

    public InheritanceKind createInheritanceKindFromString(EDataType eDataType, String initialValue) {
        InheritanceKind result = InheritanceKind.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertInheritanceKindToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    @Override
    public ElementTypesConfigurationsPackage getElementTypesConfigurationsPackage() {
        return (ElementTypesConfigurationsPackage)this.getEPackage();
    }

    @Deprecated
    public static ElementTypesConfigurationsPackage getPackage() {
        return ElementTypesConfigurationsPackage.eINSTANCE;
    }
}

