/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.tools.commands;

import java.util.Collections;
import java.util.Set;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.AbstractEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.uml2.uml.Dependency;

public class DestroyDependencyWithoutSupplierCommand
extends AbstractTransactionalCommand {
    private Set<Dependency> dependencies;
    private IElementEditService provider;

    public DestroyDependencyWithoutSupplierCommand(TransactionalEditingDomain domain, Set<Dependency> dependencies, IElementEditService provider) {
        super(domain, "Destroy the empty elements", null);
        this.dependencies = dependencies;
        this.provider = provider;
    }

    public DestroyDependencyWithoutSupplierCommand(TransactionalEditingDomain domain, Dependency dependency, IElementEditService provider) {
        super(domain, "Destroy the empty elements", null);
        this.dependencies = Collections.singleton(dependency);
        this.provider = provider;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        CompositeCommand command = new CompositeCommand("Destroy relationship without suppliers");
        for (Dependency current : this.dependencies) {
            DestroyElementRequest request;
            ICommand cmd;
            if (!current.getSuppliers().isEmpty() || !(cmd = this.getCommand((AbstractEditCommandRequest)(request = new DestroyElementRequest(this.getEditingDomain(), (EObject)current, false)))).canExecute()) continue;
            command.add((IUndoableOperation)cmd);
        }
        if (!command.isEmpty() && command.canExecute()) {
            command.execute(monitor, info);
        }
        return CommandResult.newOKCommandResult();
    }

    private ICommand getCommand(AbstractEditCommandRequest req) {
        ICommand setCommand;
        if (this.provider != null && (setCommand = this.provider.getEditCommand((IEditCommandRequest)req)) != null) {
            return setCommand.reduce();
        }
        return UnexecutableCommand.INSTANCE;
    }
}

