/**
 * Copyright (c) 2007, 2020 Borland Software Corporation, CEA LIST, Artal and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *    Dmitry Stadnik (Borland) - initial API and implementation
 *    Michael Golubev (Montages) - #386838 - migrate to Xtend2
 *    Aurelien Didier (ARTAL) - aurelien.didier51@gmail.com - Bug 569174
 *    Etienne Allogo (ARTAL) - etienne.allogo@artal.fr - Bug 569174 : L1.2 clean up
 */
package xpt.propsheet;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Arrays;
import java.util.Objects;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.gmf.codegen.gmfgen.CustomTabFilter;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenCustomPropertyTab;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenPropertySheet;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenPropertyTab;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenPropertyTabFilter;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenStandardPropertyTab;
import org.eclipse.papyrus.gmf.codegen.gmfgen.TypeTabFilter;
import org.eclipse.papyrus.gmf.codegen.xtend.annotations.Localization;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import xpt.Common;
import xpt.Common_qvto;

@Singleton
@SuppressWarnings("all")
public class extensions {
  @Inject
  @Extension
  private Common _common;

  @Inject
  @Extension
  private Common_qvto _common_qvto;

  @Inject
  private LabelProvider labelProvider;

  public CharSequence extensions(final GenPropertySheet it) {
    StringConcatenation _builder = new StringConcatenation();
    String _tripleSpace = this._common.tripleSpace(1);
    _builder.append(_tripleSpace);
    _builder.append("<extension point=\"org.eclipse.ui.views.properties.tabbed.propertyContributor\" id=\"prop-contrib\">");
    _builder.newLineIfNotEmpty();
    String _tripleSpace_1 = this._common.tripleSpace(2);
    _builder.append(_tripleSpace_1);
    CharSequence _xmlGeneratedTag = this._common.xmlGeneratedTag();
    _builder.append(_xmlGeneratedTag);
    _builder.newLineIfNotEmpty();
    String _tripleSpace_2 = this._common.tripleSpace(2);
    _builder.append(_tripleSpace_2);
    _builder.append("<propertyContributor");
    _builder.newLineIfNotEmpty();
    String _tripleSpace_3 = this._common.tripleSpace(4);
    _builder.append(_tripleSpace_3);
    _builder.append("contributorId=\"");
    String _iD = it.getEditorGen().getPlugin().getID();
    _builder.append(_iD);
    _builder.append("\"");
    _builder.newLineIfNotEmpty();
    String _tripleSpace_4 = this._common.tripleSpace(4);
    _builder.append(_tripleSpace_4);
    {
      boolean _isNeedsCaption = it.isNeedsCaption();
      if (_isNeedsCaption) {
        _builder.append("labelProvider=\"");
        CharSequence _qualifiedClassName = this.labelProvider.qualifiedClassName(it);
        _builder.append(_qualifiedClassName);
        _builder.append("\"");
      }
    }
    _builder.append(">");
    _builder.newLineIfNotEmpty();
    String _tripleSpace_5 = this._common.tripleSpace(3);
    _builder.append(_tripleSpace_5);
    _builder.append("<propertyCategory category=\"domain\"/>");
    _builder.newLineIfNotEmpty();
    String _tripleSpace_6 = this._common.tripleSpace(3);
    _builder.append(_tripleSpace_6);
    _builder.append("<propertyCategory category=\"visual\"/>");
    _builder.newLineIfNotEmpty();
    String _tripleSpace_7 = this._common.tripleSpace(3);
    _builder.append(_tripleSpace_7);
    _builder.append("<propertyCategory category=\"extra\"/>");
    _builder.newLineIfNotEmpty();
    String _tripleSpace_8 = this._common.tripleSpace(2);
    _builder.append(_tripleSpace_8);
    _builder.append("</propertyContributor>");
    _builder.newLineIfNotEmpty();
    String _tripleSpace_9 = this._common.tripleSpace(1);
    _builder.append(_tripleSpace_9);
    _builder.append("</extension>");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    String _tripleSpace_10 = this._common.tripleSpace(1);
    _builder.append(_tripleSpace_10);
    _builder.append("<extension point=\"org.eclipse.ui.views.properties.tabbed.propertyTabs\" id=\"proptabs\">");
    _builder.newLineIfNotEmpty();
    String _tripleSpace_11 = this._common.tripleSpace(2);
    _builder.append(_tripleSpace_11);
    CharSequence _xmlGeneratedTag_1 = this._common.xmlGeneratedTag();
    _builder.append(_xmlGeneratedTag_1);
    _builder.append("   ");
    _builder.newLineIfNotEmpty();
    String _tripleSpace_12 = this._common.tripleSpace(2);
    _builder.append(_tripleSpace_12);
    _builder.append("<propertyTabs contributorId=\"");
    String _iD_1 = it.getEditorGen().getPlugin().getID();
    _builder.append(_iD_1);
    _builder.append("\">");
    _builder.newLineIfNotEmpty();
    {
      EList<GenPropertyTab> _tabs = it.getTabs();
      for(final GenPropertyTab t : _tabs) {
        CharSequence _tab = this.tab(t);
        _builder.append(_tab);
        _builder.newLineIfNotEmpty();
      }
    }
    String _tripleSpace_13 = this._common.tripleSpace(2);
    _builder.append(_tripleSpace_13);
    _builder.append("</propertyTabs>");
    _builder.newLineIfNotEmpty();
    String _tripleSpace_14 = this._common.tripleSpace(1);
    _builder.append(_tripleSpace_14);
    _builder.append("</extension>");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    String _tripleSpace_15 = this._common.tripleSpace(1);
    _builder.append(_tripleSpace_15);
    _builder.append("<extension point=\"org.eclipse.ui.views.properties.tabbed.propertySections\" id=\"propsections\">");
    _builder.newLineIfNotEmpty();
    String _tripleSpace_16 = this._common.tripleSpace(2);
    _builder.append(_tripleSpace_16);
    CharSequence _xmlGeneratedTag_2 = this._common.xmlGeneratedTag();
    _builder.append(_xmlGeneratedTag_2);
    _builder.append("   ");
    _builder.newLineIfNotEmpty();
    String _tripleSpace_17 = this._common.tripleSpace(2);
    _builder.append(_tripleSpace_17);
    _builder.append("<propertySections contributorId=\"");
    String _iD_2 = it.getEditorGen().getPlugin().getID();
    _builder.append(_iD_2);
    _builder.append("\">");
    _builder.newLineIfNotEmpty();
    {
      EList<GenPropertyTab> _tabs_1 = it.getTabs();
      for(final GenPropertyTab t_1 : _tabs_1) {
        CharSequence _section = this.section(t_1);
        _builder.append(_section);
        _builder.newLineIfNotEmpty();
      }
    }
    String _tripleSpace_18 = this._common.tripleSpace(2);
    _builder.append(_tripleSpace_18);
    _builder.append("</propertySections>");
    _builder.newLineIfNotEmpty();
    String _tripleSpace_19 = this._common.tripleSpace(1);
    _builder.append(_tripleSpace_19);
    _builder.append("</extension>");
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  protected CharSequence _tab(final GenPropertyTab it) {
    StringConcatenation _builder = new StringConcatenation();
    this._common_qvto.ERROR(("Unknown property tab: " + it));
    return _builder;
  }

  protected CharSequence _tab(final GenStandardPropertyTab it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      String _iD = it.getID();
      boolean _equals = Objects.equals(_iD, "appearance");
      if (_equals) {
        String _tripleSpace = this._common.tripleSpace(3);
        _builder.append(_tripleSpace);
        _builder.append("<propertyTab");
        _builder.newLineIfNotEmpty();
        String _tripleSpace_1 = this._common.tripleSpace(4);
        _builder.append(_tripleSpace_1);
        _builder.append(" category=\"visual\"");
        _builder.newLineIfNotEmpty();
        String _tripleSpace_2 = this._common.tripleSpace(4);
        _builder.append(_tripleSpace_2);
        _builder.append(" id=\"property.tab.AppearancePropertySection\"");
        _builder.newLineIfNotEmpty();
        String _tripleSpace_3 = this._common.tripleSpace(4);
        _builder.append(_tripleSpace_3);
        _builder.append(" label=\"%tab.appearance\"/>");
        _builder.newLineIfNotEmpty();
      } else {
        String _iD_1 = it.getID();
        boolean _equals_1 = Objects.equals(_iD_1, "diagram");
        if (_equals_1) {
          String _tripleSpace_4 = this._common.tripleSpace(3);
          _builder.append(_tripleSpace_4);
          _builder.append(" <propertyTab");
          _builder.newLineIfNotEmpty();
          String _tripleSpace_5 = this._common.tripleSpace(4);
          _builder.append(_tripleSpace_5);
          _builder.append(" category=\"visual\"");
          _builder.newLineIfNotEmpty();
          String _tripleSpace_6 = this._common.tripleSpace(4);
          _builder.append(_tripleSpace_6);
          _builder.append(" id=\"property.tab.DiagramPropertySection\"");
          _builder.newLineIfNotEmpty();
          String _tripleSpace_7 = this._common.tripleSpace(4);
          _builder.append(_tripleSpace_7);
          _builder.append(" label=\"%tab.diagram\"/>");
          _builder.newLineIfNotEmpty();
        } else {
          String _iD_2 = it.getID();
          boolean _equals_2 = Objects.equals(_iD_2, "advanced");
          if (_equals_2) {
            _builder.append("<propertyTab");
            _builder.newLine();
            String _tripleSpace_8 = this._common.tripleSpace(4);
            _builder.append(_tripleSpace_8);
            _builder.append(" category=\"extra\"");
            _builder.newLineIfNotEmpty();
            String _tripleSpace_9 = this._common.tripleSpace(4);
            _builder.append(_tripleSpace_9);
            _builder.append(" id=\"property.tab.AdvancedPropertySection\"");
            _builder.newLineIfNotEmpty();
            String _tripleSpace_10 = this._common.tripleSpace(4);
            _builder.append(_tripleSpace_10);
            _builder.append(" label=\"%tab.advanced\"/>           ");
            _builder.newLineIfNotEmpty();
          }
        }
      }
    }
    return _builder;
  }

  protected CharSequence _tab(final GenCustomPropertyTab it) {
    StringConcatenation _builder = new StringConcatenation();
    String _tripleSpace = this._common.tripleSpace(3);
    _builder.append(_tripleSpace);
    _builder.append(" <propertyTab");
    _builder.newLineIfNotEmpty();
    {
      String _iD = it.getID();
      boolean _equals = Objects.equals(_iD, "domain");
      if (_equals) {
        String _tripleSpace_1 = this._common.tripleSpace(4);
        _builder.append(_tripleSpace_1);
        _builder.append(" category=\"domain\"");
        _builder.newLineIfNotEmpty();
      } else {
        String _tripleSpace_2 = this._common.tripleSpace(4);
        _builder.append(_tripleSpace_2);
        _builder.append(" category=\"extra\"");
        _builder.newLineIfNotEmpty();
      }
    }
    String _tripleSpace_3 = this._common.tripleSpace(4);
    _builder.append(_tripleSpace_3);
    _builder.append(" id=\"property.tab.");
    String _iD_1 = it.getID();
    _builder.append(_iD_1);
    _builder.append("\"");
    _builder.newLineIfNotEmpty();
    String _tripleSpace_4 = this._common.tripleSpace(4);
    _builder.append(_tripleSpace_4);
    _builder.append(" label=\"%tab.");
    String _iD_2 = it.getID();
    _builder.append(_iD_2);
    _builder.append("\"/>");
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  protected CharSequence _section(final GenPropertyTab it) {
    StringConcatenation _builder = new StringConcatenation();
    this._common_qvto.ERROR(("Unknown property tab: " + it));
    return _builder;
  }

  protected CharSequence _section(final GenStandardPropertyTab it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      String _iD = it.getID();
      boolean _equals = Objects.equals(_iD, "appearance");
      if (_equals) {
        String _tripleSpace = this._common.tripleSpace(3);
        _builder.append(_tripleSpace);
        _builder.append("<propertySection id=\"property.section.ConnectorAppearancePropertySection\" ");
        _builder.newLineIfNotEmpty();
        String _tripleSpace_1 = this._common.tripleSpace(4);
        _builder.append(_tripleSpace_1);
        _builder.append("filter=\"org.eclipse.gmf.runtime.diagram.ui.properties.filters.ConnectionEditPartPropertySectionFilter\" ");
        _builder.newLineIfNotEmpty();
        String _tripleSpace_2 = this._common.tripleSpace(4);
        _builder.append(_tripleSpace_2);
        _builder.append("class=\"org.eclipse.gmf.runtime.diagram.ui.properties.sections.appearance.ConnectionAppearancePropertySection\" ");
        _builder.newLineIfNotEmpty();
        String _tripleSpace_3 = this._common.tripleSpace(4);
        _builder.append(_tripleSpace_3);
        _builder.append("tab=\"property.tab.AppearancePropertySection\">");
        _builder.newLineIfNotEmpty();
        String _tripleSpace_4 = this._common.tripleSpace(3);
        _builder.append(_tripleSpace_4);
        _builder.append("</propertySection>");
        _builder.newLineIfNotEmpty();
        String _tripleSpace_5 = this._common.tripleSpace(3);
        _builder.append(_tripleSpace_5);
        _builder.append("<propertySection id=\"property.section.ShapeColorAndFontPropertySection\" ");
        _builder.newLineIfNotEmpty();
        String _tripleSpace_6 = this._common.tripleSpace(4);
        _builder.append(_tripleSpace_6);
        _builder.append("filter=\"org.eclipse.gmf.runtime.diagram.ui.properties.filters.ShapeEditPartPropertySectionFilter\" ");
        _builder.newLineIfNotEmpty();
        String _tripleSpace_7 = this._common.tripleSpace(4);
        _builder.append(_tripleSpace_7);
        _builder.append("class=\"org.eclipse.gmf.runtime.diagram.ui.properties.sections.appearance.ShapeColorsAndFontsPropertySection\" ");
        _builder.newLineIfNotEmpty();
        String _tripleSpace_8 = this._common.tripleSpace(4);
        _builder.append(_tripleSpace_8);
        _builder.append("tab=\"property.tab.AppearancePropertySection\">");
        _builder.newLineIfNotEmpty();
        String _tripleSpace_9 = this._common.tripleSpace(3);
        _builder.append(_tripleSpace_9);
        _builder.append("</propertySection> ");
        _builder.newLineIfNotEmpty();
        String _tripleSpace_10 = this._common.tripleSpace(3);
        _builder.append(_tripleSpace_10);
        _builder.append("<propertySection id=\"property.section.DiagramColorsAndFontsPropertySection\" ");
        _builder.newLineIfNotEmpty();
        String _tripleSpace_11 = this._common.tripleSpace(4);
        _builder.append(_tripleSpace_11);
        _builder.append("filter=\"org.eclipse.gmf.runtime.diagram.ui.properties.filters.DiagramEditPartPropertySectionFilter\" ");
        _builder.newLineIfNotEmpty();
        String _tripleSpace_12 = this._common.tripleSpace(4);
        _builder.append(_tripleSpace_12);
        _builder.append("class=\"org.eclipse.gmf.runtime.diagram.ui.properties.sections.appearance.DiagramColorsAndFontsPropertySection\" ");
        _builder.newLineIfNotEmpty();
        String _tripleSpace_13 = this._common.tripleSpace(4);
        _builder.append(_tripleSpace_13);
        _builder.append("tab=\"property.tab.AppearancePropertySection\">");
        _builder.newLineIfNotEmpty();
        String _tripleSpace_14 = this._common.tripleSpace(3);
        _builder.append(_tripleSpace_14);
        _builder.append("</propertySection>     ");
        _builder.newLineIfNotEmpty();
      } else {
        String _iD_1 = it.getID();
        boolean _equals_1 = Objects.equals(_iD_1, "diagram");
        if (_equals_1) {
          String _tripleSpace_15 = this._common.tripleSpace(3);
          _builder.append(_tripleSpace_15);
          _builder.append("<propertySection id=\"property.section.RulerGridPropertySection\" ");
          _builder.newLineIfNotEmpty();
          String _tripleSpace_16 = this._common.tripleSpace(4);
          _builder.append(_tripleSpace_16);
          _builder.append("filter=\"org.eclipse.gmf.runtime.diagram.ui.properties.filters.DiagramEditPartPropertySectionFilter\" ");
          _builder.newLineIfNotEmpty();
          String _tripleSpace_17 = this._common.tripleSpace(4);
          _builder.append(_tripleSpace_17);
          _builder.append("class=\"org.eclipse.gmf.runtime.diagram.ui.properties.sections.grid.RulerGridPropertySection\" ");
          _builder.newLineIfNotEmpty();
          String _tripleSpace_18 = this._common.tripleSpace(4);
          _builder.append(_tripleSpace_18);
          _builder.append("tab=\"property.tab.DiagramPropertySection\">");
          _builder.newLineIfNotEmpty();
          String _tripleSpace_19 = this._common.tripleSpace(3);
          _builder.append(_tripleSpace_19);
          _builder.append("</propertySection>     ");
          _builder.newLineIfNotEmpty();
        } else {
          String _iD_2 = it.getID();
          boolean _equals_2 = Objects.equals(_iD_2, "advanced");
          if (_equals_2) {
            String _tripleSpace_20 = this._common.tripleSpace(3);
            _builder.append(_tripleSpace_20);
            _builder.append("<propertySection id=\"property.section.AdvancedPropertySection\"");
            _builder.newLineIfNotEmpty();
            String _tripleSpace_21 = this._common.tripleSpace(4);
            _builder.append(_tripleSpace_21);
            _builder.append("class=\"org.eclipse.gmf.runtime.diagram.ui.properties.sections.AdvancedPropertySection\"");
            _builder.newLineIfNotEmpty();
            String _tripleSpace_22 = this._common.tripleSpace(4);
            _builder.append(_tripleSpace_22);
            _builder.append("filter=\"org.eclipse.gmf.runtime.diagram.ui.properties.filters.EditPartPropertySectionFilter\"");
            _builder.newLineIfNotEmpty();
            String _tripleSpace_23 = this._common.tripleSpace(4);
            _builder.append(_tripleSpace_23);
            _builder.append("tab=\"property.tab.AdvancedPropertySection\">");
            _builder.newLineIfNotEmpty();
            String _tripleSpace_24 = this._common.tripleSpace(3);
            _builder.append(_tripleSpace_24);
            _builder.append("</propertySection>            ");
            _builder.newLineIfNotEmpty();
          }
        }
      }
    }
    return _builder;
  }

  protected CharSequence _section(final GenCustomPropertyTab it) {
    StringConcatenation _builder = new StringConcatenation();
    String _tripleSpace = this._common.tripleSpace(3);
    _builder.append(_tripleSpace);
    _builder.append("<propertySection");
    _builder.newLineIfNotEmpty();
    String _tripleSpace_1 = this._common.tripleSpace(4);
    _builder.append(_tripleSpace_1);
    _builder.append("id=\"property.section.");
    String _iD = it.getID();
    _builder.append(_iD);
    _builder.append("\" ");
    _builder.newLineIfNotEmpty();
    String _tripleSpace_2 = this._common.tripleSpace(4);
    _builder.append(_tripleSpace_2);
    _builder.append("tab=\"property.tab.");
    String _iD_1 = it.getID();
    _builder.append(_iD_1);
    _builder.append("\"");
    _builder.newLineIfNotEmpty();
    String _tripleSpace_3 = this._common.tripleSpace(4);
    _builder.append(_tripleSpace_3);
    CharSequence _filter = this.filter(it.getFilter());
    _builder.append(_filter);
    _builder.newLineIfNotEmpty();
    String _tripleSpace_4 = this._common.tripleSpace(4);
    _builder.append(_tripleSpace_4);
    _builder.append("class=\"");
    String _qualifiedClassName = it.getQualifiedClassName();
    _builder.append(_qualifiedClassName);
    _builder.append("\">");
    _builder.newLineIfNotEmpty();
    CharSequence _input = this.input(it.getFilter());
    _builder.append(_input);
    _builder.newLineIfNotEmpty();
    String _tripleSpace_5 = this._common.tripleSpace(3);
    _builder.append(_tripleSpace_5);
    _builder.append("</propertySection>");
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  protected CharSequence _filter(final GenPropertyTabFilter it) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }

  protected CharSequence _filter(final CustomTabFilter it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("filter=\"");
    String _qualifiedClassName = it.getQualifiedClassName();
    _builder.append(_qualifiedClassName);
    _builder.append("\"");
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  protected CharSequence _input(final GenPropertyTabFilter it) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }

  protected CharSequence _input(final TypeTabFilter it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      EList<String> _allTypes = it.getAllTypes();
      for(final String type : _allTypes) {
        String _tripleSpace = this._common.tripleSpace(4);
        _builder.append(_tripleSpace);
        _builder.append("<input type=\"");
        _builder.append(type);
        _builder.append("\"/>");
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }

  @Localization
  public CharSequence i18n(final GenPropertySheet it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.newLine();
    _builder.append("# Property Sheet");
    _builder.newLine();
    {
      EList<GenPropertyTab> _tabs = it.getTabs();
      for(final GenPropertyTab tab : _tabs) {
        _builder.append("tab.");
        String _iD = tab.getID();
        _builder.append(_iD);
        _builder.append("=");
        String _label = tab.getLabel();
        _builder.append(_label);
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.newLine();
    return _builder;
  }

  public CharSequence tab(final GenPropertyTab it) {
    if (it instanceof GenCustomPropertyTab) {
      return _tab((GenCustomPropertyTab)it);
    } else if (it instanceof GenStandardPropertyTab) {
      return _tab((GenStandardPropertyTab)it);
    } else if (it != null) {
      return _tab(it);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it).toString());
    }
  }

  public CharSequence section(final GenPropertyTab it) {
    if (it instanceof GenCustomPropertyTab) {
      return _section((GenCustomPropertyTab)it);
    } else if (it instanceof GenStandardPropertyTab) {
      return _section((GenStandardPropertyTab)it);
    } else if (it != null) {
      return _section(it);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it).toString());
    }
  }

  public CharSequence filter(final GenPropertyTabFilter it) {
    if (it instanceof CustomTabFilter) {
      return _filter((CustomTabFilter)it);
    } else if (it != null) {
      return _filter(it);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it).toString());
    }
  }

  public CharSequence input(final GenPropertyTabFilter it) {
    if (it instanceof TypeTabFilter) {
      return _input((TypeTabFilter)it);
    } else if (it != null) {
      return _input(it);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it).toString());
    }
  }
}
