/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.mwe2.utils.components;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.mwe.core.WorkflowContext;
import org.eclipse.emf.mwe.core.issues.Issues;
import org.eclipse.emf.mwe.core.lib.AbstractWorkflowComponent;
import org.eclipse.emf.mwe.core.monitor.ProgressMonitor;
import org.eclipse.m2m.qvt.oml.BasicModelExtent;
import org.eclipse.m2m.qvt.oml.ExecutionContext;
import org.eclipse.m2m.qvt.oml.ExecutionContextImpl;
import org.eclipse.m2m.qvt.oml.ExecutionDiagnostic;
import org.eclipse.m2m.qvt.oml.ModelExtent;
import org.eclipse.m2m.qvt.oml.TransformationExecutor;
import org.eclipse.papyrus.mwe2.utils.messages.Messages;

public class QvtoTransformationWorkflow
extends AbstractWorkflowComponent {
    private String transformationURI;
    private String outputSlot;
    private ArrayList<String> inputSlots = new ArrayList();
    private Log log = LogFactory.getLog(((Object)((Object)this)).getClass());

    public String getTransformationURI() {
        return this.transformationURI;
    }

    public void setTransformationURI(String transformationURI) {
        this.transformationURI = transformationURI;
    }

    public String getOutputSlot() {
        return this.outputSlot;
    }

    public void setOutputSlot(String outputSlot) {
        this.outputSlot = outputSlot;
    }

    public boolean addInputSlots(String c) {
        return this.inputSlots.add(c);
    }

    public ExecutionDiagnostic generate(List<? extends EObject> inObjects, URI transformationURI, WorkflowContext ctx, Issues issues) throws IOException {
        this.log.info((Object)("Executing QVTO transformation " + this.getTransformationURI()));
        TransformationExecutor executor = new TransformationExecutor(transformationURI);
        Diagnostic loadTransformationDiagnostic = executor.loadTransformation();
        if (!loadTransformationDiagnostic.getMessage().equals("OK")) {
            this.log.error((Object)(Messages.QvtoTransformationWorkflowComponent_1 + String.valueOf(loadTransformationDiagnostic)));
            return null;
        }
        ExecutionContextImpl context = new ExecutionContextImpl();
        ArrayList<BasicModelExtent> input = new ArrayList<BasicModelExtent>();
        for (EObject eObject : inObjects) {
            BasicModelExtent basicModelExtent = new BasicModelExtent();
            basicModelExtent.add(eObject);
            input.add(basicModelExtent);
        }
        issues.addInfo(new File("..").getAbsolutePath());
        BasicModelExtent basicModelExtent = new BasicModelExtent();
        input.add(basicModelExtent);
        ModelExtent[] modelParameters = input.toArray(new ModelExtent[0]);
        context = new ExecutionContextImpl();
        context.setConfigProperty("keepModeling", (Object)true);
        ExecutionDiagnostic result = executor.execute((ExecutionContext)context, modelParameters);
        if (result.getSeverity() == 0) {
            List outObjects = basicModelExtent.getContents();
            ctx.set(this.getOutputSlot(), (Object)outObjects);
            this.log.info((Object)(Messages.QvtoTransformationWorkflowComponent_4 + this.getTransformationURI()));
        } else {
            issues.addError(result.toString());
        }
        return result;
    }

    protected void invokeInternal(WorkflowContext ctx, ProgressMonitor monitor, Issues issues) {
        ArrayList<EObject> inObjects = new ArrayList<EObject>();
        for (String inputSlot : this.inputSlots) {
            Object inputObject = ctx.get(inputSlot);
            if (inputObject instanceof EObject) {
                inObjects.add((EObject)inputObject);
                continue;
            }
            if (!(inputObject instanceof List)) continue;
            List list = (List)inputObject;
            inObjects.add((EObject)list.get(0));
        }
        try {
            this.generate(inObjects, URI.createURI((String)this.transformationURI), ctx, issues);
        }
        catch (IOException e) {
            this.log.error((Object)e.getLocalizedMessage());
        }
    }

    public void checkConfiguration(Issues issues) {
        if (this.inputSlots.isEmpty()) {
            issues.addError(Messages.QvtoTransformationWorkflowComponent_5);
        }
    }
}

