/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.validation.properties.internal.util;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.util.ComposedSwitch;
import org.eclipse.emf.ecore.util.EcoreSwitch;
import org.eclipse.emf.ecore.util.Switch;
import org.eclipse.papyrus.infra.properties.contexts.Property;
import org.eclipse.papyrus.infra.properties.environment.Type;
import org.eclipse.uml2.types.TypesPackage;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.MultiplicityElement;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.PrimitiveType;
import org.eclipse.uml2.uml.TypedElement;
import org.eclipse.uml2.uml.util.UMLSwitch;

public class PropertyTypeHelper {
    private static final PropertyTypeHelper INSTANCE = new PropertyTypeHelper();
    private final Switch<EObject> sourceTypeSwitch = new SourceTypeSwitch();
    private final Switch<Type> propertyTypeSwitch = new PropertyTypeSwitch();
    private final Switch<Integer> sourceMultiplicitySwitch = new SourceMultiplicitySwitch();

    private PropertyTypeHelper() {
    }

    public static final PropertyTypeHelper getInstance(Property property) {
        return INSTANCE;
    }

    public Type getPropertyType(EObject sourceProperty) {
        Type result = Type.STRING;
        EObject sourceType = (EObject)this.sourceTypeSwitch.doSwitch(sourceProperty);
        if (sourceType != null) {
            result = (Type)this.propertyTypeSwitch.doSwitch(sourceType);
        }
        return result;
    }

    public int getMultiplicity(EObject sourceProperty) {
        int result = 1;
        Integer multiplicity = (Integer)this.sourceMultiplicitySwitch.doSwitch(sourceProperty);
        if (multiplicity != null) {
            result = multiplicity;
        }
        return result;
    }

    private static final class PropertyTypeSwitch
    extends ComposedSwitch<Type> {
        PropertyTypeSwitch() {
            this.addSwitch(this.createEcoreSwitch());
            this.addSwitch(this.createUMLSwitch());
        }

        private Switch<Type> createEcoreSwitch() {
            return new EcoreSwitch<Type>(){
                private final Map<java.lang.Class<?>, Type> primitiveTypes = ImmutableMap.builder().put((Object)EcorePackage.Literals.ESTRING.getInstanceClass(), (Object)Type.STRING).put((Object)EcorePackage.Literals.EINT.getInstanceClass(), (Object)Type.INTEGER).put((Object)EcorePackage.Literals.EINTEGER_OBJECT.getInstanceClass(), (Object)Type.INTEGER).put((Object)EcorePackage.Literals.EBIG_INTEGER.getInstanceClass(), (Object)Type.INTEGER).put((Object)EcorePackage.Literals.EBOOLEAN.getInstanceClass(), (Object)Type.BOOLEAN).put((Object)EcorePackage.Literals.EFLOAT.getInstanceClass(), (Object)Type.DOUBLE).put((Object)EcorePackage.Literals.EFLOAT_OBJECT.getInstanceClass(), (Object)Type.DOUBLE).put((Object)EcorePackage.Literals.EDOUBLE.getInstanceClass(), (Object)Type.DOUBLE).put((Object)EcorePackage.Literals.EDOUBLE_OBJECT.getInstanceClass(), (Object)Type.DOUBLE).put((Object)EcorePackage.Literals.EBIG_DECIMAL.getInstanceClass(), (Object)Type.DOUBLE).put((Object)EcorePackage.Literals.ECHAR.getInstanceClass(), (Object)Type.INTEGER).put((Object)EcorePackage.Literals.ECHARACTER_OBJECT.getInstanceClass(), (Object)Type.INTEGER).put((Object)EcorePackage.Literals.EBYTE.getInstanceClass(), (Object)Type.INTEGER).put((Object)EcorePackage.Literals.EBYTE_OBJECT.getInstanceClass(), (Object)Type.INTEGER).build();

                public Type caseEClass(EClass object) {
                    return Type.REFERENCE;
                }

                public Type caseEEnum(EEnum object) {
                    return Type.ENUMERATION;
                }

                public Type caseEDataType(EDataType object) {
                    return this.primitiveTypes.get(object.getInstanceClass());
                }

                public Type defaultCase(EObject object) {
                    return Type.STRING;
                }
            };
        }

        private Switch<Type> createUMLSwitch() {
            return new UMLSwitch<Type>(){
                private final Map<String, Type> primitiveTypes = Map.of(TypesPackage.Literals.STRING.getName(), Type.STRING, TypesPackage.Literals.INTEGER.getName(), Type.INTEGER, TypesPackage.Literals.BOOLEAN.getName(), Type.BOOLEAN, TypesPackage.Literals.REAL.getName(), Type.DOUBLE, TypesPackage.Literals.UNLIMITED_NATURAL.getName(), Type.INTEGER, "Double", Type.DOUBLE);

                public Type caseClass(Class object) {
                    return Type.REFERENCE;
                }

                public Type caseEnumeration(Enumeration object) {
                    return Type.ENUMERATION;
                }

                public Type casePrimitiveType(PrimitiveType object) {
                    return this.primitiveTypes.get(object.getName());
                }

                public Type caseDataType(DataType object) {
                    return Type.REFERENCE;
                }

                public Type defaultCase(EObject object) {
                    return Type.STRING;
                }
            };
        }
    }

    private static final class SourceMultiplicitySwitch
    extends ComposedSwitch<Integer> {
        SourceMultiplicitySwitch() {
            this.addSwitch(this.createEcoreSwitch());
            this.addSwitch(this.createUMLSwitch());
        }

        private Switch<Integer> createEcoreSwitch() {
            return new EcoreSwitch<Integer>(){

                public Integer caseETypedElement(ETypedElement object) {
                    return object.getUpperBound();
                }
            };
        }

        private Switch<Integer> createUMLSwitch() {
            return new UMLSwitch<Integer>(){

                public Integer caseMultiplicityElement(MultiplicityElement object) {
                    return object.getUpper();
                }

                public Integer caseOperation(Operation object) {
                    return object.getUpper();
                }
            };
        }
    }

    private static final class SourceTypeSwitch
    extends ComposedSwitch<EObject> {
        SourceTypeSwitch() {
            this.addSwitch(this.createEcoreSwitch());
            this.addSwitch(this.createUMLSwitch());
        }

        private Switch<EObject> createEcoreSwitch() {
            return new EcoreSwitch<EObject>(){

                public EObject caseETypedElement(ETypedElement object) {
                    return object.getEType();
                }
            };
        }

        private Switch<EObject> createUMLSwitch() {
            return new UMLSwitch<EObject>(){

                public EObject caseTypedElement(TypedElement object) {
                    return object.getType();
                }

                public EObject caseOperation(Operation object) {
                    return object.getType();
                }
            };
        }
    }
}

