/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.grid.layer;

import java.util.Collection;
import org.eclipse.nebula.widgets.nattable.columnRename.DisplayColumnRenameDialogCommandHandler;
import org.eclipse.nebula.widgets.nattable.columnRename.RenameColumnHeaderCommandHandler;
import org.eclipse.nebula.widgets.nattable.columnRename.RenameColumnHelper;
import org.eclipse.nebula.widgets.nattable.columnRename.event.RenameColumnHeaderEvent;
import org.eclipse.nebula.widgets.nattable.grid.layer.ColumnHeaderSelectionListener;
import org.eclipse.nebula.widgets.nattable.grid.layer.DimensionallyDependentLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;
import org.eclipse.nebula.widgets.nattable.layer.LayerUtil;
import org.eclipse.nebula.widgets.nattable.layer.config.DefaultColumnHeaderLayerConfiguration;
import org.eclipse.nebula.widgets.nattable.layer.event.ILayerEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.IStructuralChangeEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.StructuralChangeEventHelper;
import org.eclipse.nebula.widgets.nattable.layer.event.StructuralDiff;
import org.eclipse.nebula.widgets.nattable.painter.layer.ILayerPainter;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;

public class ColumnHeaderLayer
extends DimensionallyDependentLayer {
    private final SelectionLayer[] selectionLayer;
    protected RenameColumnHelper renameColumnHelper;

    public ColumnHeaderLayer(IUniqueIndexLayer baseLayer, ILayer horizontalLayerDependency, SelectionLayer selectionLayer) {
        this(baseLayer, horizontalLayerDependency, selectionLayer, true);
    }

    public ColumnHeaderLayer(IUniqueIndexLayer baseLayer, ILayer horizontalLayerDependency, SelectionLayer ... selectionLayer) {
        this(baseLayer, horizontalLayerDependency, selectionLayer, true);
    }

    public ColumnHeaderLayer(IUniqueIndexLayer baseLayer, ILayer horizontalLayerDependency, SelectionLayer selectionLayer, boolean useDefaultConfiguration) {
        this(baseLayer, horizontalLayerDependency, selectionLayer, useDefaultConfiguration, null);
    }

    public ColumnHeaderLayer(IUniqueIndexLayer baseLayer, ILayer horizontalLayerDependency, SelectionLayer[] selectionLayer, boolean useDefaultConfiguration) {
        this(baseLayer, horizontalLayerDependency, selectionLayer, useDefaultConfiguration, null);
    }

    public ColumnHeaderLayer(IUniqueIndexLayer baseLayer, ILayer horizontalLayerDependency, SelectionLayer selectionLayer, boolean useDefaultConfiguration, ILayerPainter layerPainter) {
        SelectionLayer[] selectionLayerArray;
        if (selectionLayer != null) {
            SelectionLayer[] selectionLayerArray2 = new SelectionLayer[1];
            selectionLayerArray = selectionLayerArray2;
            selectionLayerArray2[0] = selectionLayer;
        } else {
            selectionLayerArray = new SelectionLayer[]{};
        }
        this(baseLayer, horizontalLayerDependency, selectionLayerArray, useDefaultConfiguration, layerPainter);
    }

    public ColumnHeaderLayer(IUniqueIndexLayer baseLayer, ILayer horizontalLayerDependency, SelectionLayer[] selectionLayer, boolean useDefaultConfiguration, ILayerPainter layerPainter) {
        super(baseLayer, horizontalLayerDependency, baseLayer);
        this.selectionLayer = selectionLayer == null ? new SelectionLayer[0] : selectionLayer;
        this.layerPainter = layerPainter;
        this.renameColumnHelper = new RenameColumnHelper(this);
        this.registerPersistable(this.renameColumnHelper);
        SelectionLayer[] selectionLayerArray = this.selectionLayer;
        int n = this.selectionLayer.length;
        int n2 = 0;
        while (n2 < n) {
            SelectionLayer sl = selectionLayerArray[n2];
            sl.addLayerListener(new ColumnHeaderSelectionListener(this));
            ++n2;
        }
        this.registerCommandHandlers();
        if (useDefaultConfiguration) {
            this.addConfiguration(new DefaultColumnHeaderLayerConfiguration());
        }
    }

    @Override
    public String getDisplayModeByPosition(int columnPosition, int rowPosition) {
        String displayMode = super.getDisplayModeByPosition(columnPosition, rowPosition);
        if (this.selectionLayer.length > 0) {
            int selectionLayerColumnPosition = LayerUtil.convertColumnPosition(this, columnPosition, this.selectionLayer[0]);
            SelectionLayer[] selectionLayerArray = this.selectionLayer;
            int n = this.selectionLayer.length;
            int n2 = 0;
            while (n2 < n) {
                SelectionLayer sl = selectionLayerArray[n2];
                if (sl.isColumnPositionSelected(selectionLayerColumnPosition)) {
                    if ("HOVER".equals(displayMode)) {
                        return "SELECT_HOVER";
                    }
                    return "SELECT";
                }
                ++n2;
            }
        }
        return displayMode;
    }

    @Override
    public LabelStack getConfigLabelsByPosition(int columnPosition, int rowPosition) {
        LabelStack labelStack = super.getConfigLabelsByPosition(columnPosition, rowPosition);
        if (this.selectionLayer.length > 0) {
            int selectionLayerColumnPosition = LayerUtil.convertColumnPosition(this, columnPosition, this.selectionLayer[0]);
            boolean fullySelected = true;
            SelectionLayer[] selectionLayerArray = this.selectionLayer;
            int n = this.selectionLayer.length;
            int n2 = 0;
            while (n2 < n) {
                SelectionLayer sl = selectionLayerArray[n2];
                if (!sl.isColumnPositionFullySelected(selectionLayerColumnPosition)) {
                    fullySelected = false;
                    break;
                }
                ++n2;
            }
            if (fullySelected) {
                labelStack.addLabel("COLUMN_HEADER_FULL");
            }
        }
        return labelStack;
    }

    @Deprecated
    public SelectionLayer getSelectionLayer() {
        return this.selectionLayer[0];
    }

    @Override
    public Object getDataValueByPosition(int columnPosition, int rowPosition) {
        int columnIndex = this.getColumnIndexByPosition(columnPosition);
        if (this.isColumnRenamed(columnIndex)) {
            return this.getRenamedColumnLabelByIndex(columnIndex);
        }
        return super.getDataValueByPosition(columnPosition, rowPosition);
    }

    @Override
    protected void registerCommandHandlers() {
        this.registerCommandHandler(new RenameColumnHeaderCommandHandler(this));
        this.registerCommandHandler(new DisplayColumnRenameDialogCommandHandler(this));
    }

    @Override
    public void handleLayerEvent(ILayerEvent event) {
        Collection<StructuralDiff> columnDiffs;
        IStructuralChangeEvent structuralChangeEvent;
        if (event instanceof IStructuralChangeEvent && (structuralChangeEvent = (IStructuralChangeEvent)event).isHorizontalStructureChanged() && (columnDiffs = structuralChangeEvent.getColumnDiffs()) != null && !columnDiffs.isEmpty() && !StructuralChangeEventHelper.isReorder(columnDiffs)) {
            this.renameColumnHelper.handleStructuralChanges(columnDiffs);
        }
        super.handleLayerEvent(event);
    }

    public String getOriginalColumnLabel(int columnPosition) {
        Object dataValue = super.getDataValueByPosition(columnPosition, 0);
        return dataValue != null ? dataValue.toString() : "";
    }

    public String getRenamedColumnLabel(int columnPosition) {
        int index = this.getColumnIndexByPosition(columnPosition);
        return this.getRenamedColumnLabelByIndex(index);
    }

    public String getRenamedColumnLabelByIndex(int columnIndex) {
        return this.renameColumnHelper.getRenamedColumnLabel(columnIndex);
    }

    public boolean isColumnRenamed(int columnIndex) {
        return this.renameColumnHelper.isColumnRenamed(columnIndex);
    }

    public boolean renameColumnPosition(int columnPosition, String customColumnName) {
        boolean renamed = this.renameColumnHelper.renameColumnPosition(columnPosition, customColumnName);
        if (renamed) {
            this.fireLayerEvent(new RenameColumnHeaderEvent(this, columnPosition));
        }
        return renamed;
    }

    public boolean renameColumnIndex(int columnIndex, String customColumnName) {
        boolean renamed = this.renameColumnHelper.renameColumnIndex(columnIndex, customColumnName);
        if (renamed) {
            ILayer baseLayer = this.getHorizontalLayerDependency();
            while (baseLayer.getUnderlyingLayerByPosition(0, 0) != null) {
                baseLayer = baseLayer.getUnderlyingLayerByPosition(0, 0);
            }
            baseLayer.fireLayerEvent(new RenameColumnHeaderEvent(baseLayer, columnIndex));
        }
        return renamed;
    }
}

