/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.strategy.paste;

import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.infra.core.clipboard.PapyrusClipboard;
import org.eclipse.papyrus.infra.gmfdiag.common.strategy.paste.AbstractPasteStrategy;
import org.eclipse.papyrus.infra.gmfdiag.common.strategy.paste.DefaultPasteStrategy;
import org.eclipse.papyrus.infra.gmfdiag.common.strategy.paste.IPasteStrategy;
import org.eclipse.papyrus.infra.internationalization.InternationalizationEntry;
import org.eclipse.papyrus.infra.internationalization.utils.commands.InternationalizationPasteCommand;
import org.eclipse.papyrus.infra.internationalization.utils.utils.LabelInternationalizationUtils;

public class InternationalizationPasteStrategy
extends AbstractPasteStrategy
implements IPasteStrategy {
    private static IPasteStrategy instance = new InternationalizationPasteStrategy();

    public static IPasteStrategy getInstance() {
        return instance;
    }

    public String getLabel() {
        return "Internationalization Strategy";
    }

    public String getDescription() {
        return "Copy Internationalization elements";
    }

    public String getID() {
        return "org.eclipse.papyrus.infra.gmfdiag.common" + ".InternationalizationStrategy";
    }

    public IPasteStrategy dependsOn() {
        return DefaultPasteStrategy.getInstance();
    }

    public Command getSemanticCommand(EditingDomain domain, EObject targetOwner, PapyrusClipboard<Object> papyrusClipboard) {
        CompoundCommand compoundCommand = new CompoundCommand("Internationalization paste objects");
        Map sourceToCopy = papyrusClipboard.getSourceToInternalClipboard();
        for (Map.Entry sourceToCopyEntry : sourceToCopy.entrySet()) {
            EObject source = (EObject)sourceToCopyEntry.getKey();
            EObject target = papyrusClipboard.getTragetCopyFromInternalClipboardCopy(sourceToCopyEntry.getValue());
            Set localesForSource = LabelInternationalizationUtils.getAvailableLocales((Resource)source.eResource());
            for (Locale currentLocale : localesForSource) {
                InternationalizationEntry internationalizationEntry = LabelInternationalizationUtils.getInternationalizationEntry((EObject)source, (Object)source, (Locale)currentLocale);
                if (internationalizationEntry == null) continue;
                compoundCommand.append((Command)new InternationalizationPasteCommand((TransactionalEditingDomain)domain, target, internationalizationEntry.getValue(), currentLocale));
            }
        }
        return !compoundCommand.getCommandList().isEmpty() ? compoundCommand : null;
    }
}

