/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.service.types.internal.ui.commands;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.type.core.commands.ConfigureElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForResource;
import org.eclipse.papyrus.infra.services.edit.utils.ElementTypeUtils;
import org.eclipse.papyrus.uml.service.types.internal.ui.Activator;
import org.eclipse.papyrus.uml.service.types.internal.ui.advice.InstanceSpecificationLinkEditHelperAdvice;
import org.eclipse.papyrus.uml.service.types.internal.ui.dialogs.AssociationSelectionDialog;
import org.eclipse.papyrus.uml.tools.utils.NamedElementUtil;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.InstanceValue;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Slot;
import org.eclipse.uml2.uml.StructuralFeature;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLFactory;

public class InstanceSpecificationLinkCreateCommand
extends ConfigureElementCommand {
    protected InstanceSpecification source = null;
    protected InstanceSpecification target = null;
    protected HashSet<Association> commonAssociations;
    protected boolean useUI = true;
    @Deprecated
    public static final String INSTANCE_END = "InstanceEnd";

    public InstanceSpecificationLinkCreateCommand(ConfigureRequest request) {
        super(request);
        if (request.getParameter("CreateRelationshipRequest.source") instanceof InstanceSpecification) {
            this.source = (InstanceSpecification)request.getParameter("CreateRelationshipRequest.source");
        }
        if (request.getParameter("CreateRelationshipRequest.target") instanceof InstanceSpecification) {
            this.target = (InstanceSpecification)request.getParameter("CreateRelationshipRequest.target");
        }
        this.useUI = ElementTypeUtils.useGUI((IEditCommandRequest)request);
    }

    protected void addEnd(InstanceSpecification instanceLink, InstanceSpecification end) {
        EAnnotation endtypes = instanceLink.getEAnnotation(INSTANCE_END);
        if (endtypes == null) {
            endtypes = instanceLink.createEAnnotation(INSTANCE_END);
        }
        endtypes.getReferences().add((Object)end);
    }

    protected void removeEnd(InstanceSpecification instanceLink, InstanceSpecification end) {
        EAnnotation endtypes = instanceLink.getEAnnotation(INSTANCE_END);
        if (endtypes == null) {
            endtypes = instanceLink.createEAnnotation(INSTANCE_END);
        }
        endtypes.getReferences().remove((Object)end);
    }

    public boolean canExecute() {
        return InstanceSpecificationLinkEditHelperAdvice.canCreate((EObject)this.source, (EObject)this.target);
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        ServicesRegistry registry;
        if (!this.useUI) {
            return CommandResult.newCancelledCommandResult();
        }
        try {
            registry = ServiceUtilsForResource.getInstance().getServiceRegistry(this.source.eResource());
        }
        catch (ServiceException e) {
            Activator.log.error((Throwable)e);
            return CommandResult.newCancelledCommandResult();
        }
        Association selectedAssociation = null;
        if (InstanceSpecificationLinkEditHelperAdvice.shouldSuppressDialog(this.getRequest())) {
            selectedAssociation = InstanceSpecificationLinkEditHelperAdvice.getSuppressedDialogResult(this.getRequest());
        } else {
            AssociationSelectionDialog associationSelectionDialog = new AssociationSelectionDialog(new Shell(), 8, InstanceSpecificationLinkEditHelperAdvice.getModelAssociations(this.source, this.target), registry);
            associationSelectionDialog.open();
            selectedAssociation = associationSelectionDialog.getSelectedAssociation();
            if (selectedAssociation == null && associationSelectionDialog.isCanceled()) {
                return CommandResult.newCancelledCommandResult();
            }
        }
        InstanceSpecification instanceSpecification = (InstanceSpecification)this.getElementToEdit();
        Set<Classifier> sourceSpecificationClassifiersSet = InstanceSpecificationLinkEditHelperAdvice.getSpecificationClassifier(this.source);
        Set<Classifier> targetSpecificationClassifiersSet = InstanceSpecificationLinkEditHelperAdvice.getSpecificationClassifier(this.target);
        boolean revertEnds = false;
        if (selectedAssociation != null) {
            instanceSpecification.getClassifiers().add((Object)selectedAssociation);
            Type sourceType = ((Property)selectedAssociation.getMemberEnds().get(0)).getType();
            boolean bl = revertEnds = !sourceSpecificationClassifiersSet.contains(sourceType);
        }
        if (revertEnds) {
            this.addEnd(instanceSpecification, this.target);
            this.addEnd(instanceSpecification, this.source);
        } else {
            this.addEnd(instanceSpecification, this.source);
            this.addEnd(instanceSpecification, this.target);
        }
        this.setupSlots(selectedAssociation, instanceSpecification, sourceSpecificationClassifiersSet, targetSpecificationClassifiersSet);
        return CommandResult.newOKCommandResult((Object)instanceSpecification);
    }

    private void setupSlots(Association selectedAssociation, InstanceSpecification instanceSpecification, Set<Classifier> sourceSpecificationClassifiersSet, Set<Classifier> targetSpecificationClassifiersSet) {
        if (selectedAssociation == null) {
            return;
        }
        for (Property property : selectedAssociation.getMemberEnds()) {
            Slot slot = UMLFactory.eINSTANCE.createSlot();
            slot.setDefiningFeature((StructuralFeature)property);
            if (sourceSpecificationClassifiersSet.contains(property.getOwner())) {
                this.source.getSlots().add((Object)slot);
                this.associateValue(this.target, slot, property.getType());
                continue;
            }
            if (targetSpecificationClassifiersSet.contains(property.getOwner())) {
                this.target.getSlots().add((Object)slot);
                this.associateValue(this.source, slot, property.getType());
                continue;
            }
            instanceSpecification.getSlots().add((Object)slot);
            if (sourceSpecificationClassifiersSet.contains(property.getType())) {
                this.associateValue(this.source, slot, property.getType());
                continue;
            }
            this.associateValue(this.target, slot, property.getType());
        }
    }

    protected InstanceValue associateValue(InstanceSpecification instanceSpecification, Slot owner, Type type) {
        InstanceValue instanceValue = UMLFactory.eINSTANCE.createInstanceValue();
        instanceValue.setName(NamedElementUtil.getDefaultNameWithIncrementFromBase((String)instanceValue.eClass().getName(), (Collection)owner.eContents()));
        instanceValue.setType(type);
        instanceValue.setInstance(instanceSpecification);
        owner.getValues().add((Object)instanceValue);
        return instanceValue;
    }

    protected void setElementToEdit(EObject element) {
        throw new UnsupportedOperationException();
    }

    protected Constraint getSource() {
        return (Constraint)this.source;
    }

    protected Namespace getTarget() {
        return (Namespace)this.target;
    }
}

