/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.widgets.editors;

import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.papyrus.infra.widgets.editors.AbstractValueEditor;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;

public class BooleanToggle
extends AbstractValueEditor {
    private Button toggleButton;
    private ControlDecoration controlDecoration;

    private BooleanToggle(Composite parent, int style, String label, Image image, String text) {
        super(parent, 0, label);
        this.toggleButton = factory.createButton((Composite)this, null, style | 2);
        this.setWidgetObservable((IObservableValue)WidgetProperties.widgetSelection().observe((Widget)this.toggleButton));
        this.setCommitOnFocusLost((Control)this.toggleButton);
        GridData gridData = new GridData();
        this.toggleButton.setLayoutData((Object)gridData);
        this.toggleButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                BooleanToggle.this.commit();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.setText(text);
        this.setImage(image);
        gridData.horizontalIndent = FieldDecorationRegistry.getDefault().getMaximumDecorationWidth();
        this.controlDecoration = new ControlDecoration((Control)this.toggleButton, 16512);
    }

    public BooleanToggle(Composite parent, int style, String label, String text) {
        this(parent, style, label, null, text);
    }

    public BooleanToggle(Composite parent, int style, String label, Image image) {
        this(parent, style, label, image, null);
    }

    public BooleanToggle(Composite parent) {
        this(parent, 0, null, null, null);
    }

    public BooleanToggle(Composite parent, int style) {
        this(parent, style, null, null, null);
    }

    public void setText(String text) {
        if (text != null) {
            this.toggleButton.setText(text);
        }
    }

    public void setImage(Image image) {
        if (image != null) {
            this.toggleButton.setImage(image);
        }
    }

    @Override
    public Boolean getValue() {
        return this.toggleButton.getSelection();
    }

    @Override
    public Object getEditableType() {
        return Boolean.class;
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        this.toggleButton.setEnabled(!readOnly);
    }

    @Override
    public boolean isReadOnly() {
        return !this.toggleButton.isEnabled();
    }

    public void setToolTipText(String text) {
        this.toggleButton.setToolTipText(text);
        this.setLabelToolTipText(text);
    }

    public void setValue(boolean isActive) {
        this.toggleButton.setSelection(isActive);
    }

    @Override
    public void updateStatus(IStatus status) {
        switch (status.getSeverity()) {
            case 0: {
                this.controlDecoration.hide();
                break;
            }
            case 2: {
                FieldDecoration warning = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_WARNING");
                this.controlDecoration.setImage(warning.getImage());
                this.controlDecoration.showHoverText(status.getMessage());
                this.controlDecoration.setDescriptionText(status.getMessage());
                this.controlDecoration.show();
                break;
            }
            case 4: {
                FieldDecoration error = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR");
                this.controlDecoration.setImage(error.getImage());
                this.controlDecoration.showHoverText(status.getMessage());
                this.controlDecoration.setDescriptionText(status.getMessage());
                this.controlDecoration.show();
                break;
            }
            default: {
                this.controlDecoration.hide();
            }
        }
    }

    @Override
    public void changeColorField() {
    }
}

