/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.junit.utils.tests;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.infra.core.resource.AbstractBaseModel;
import org.eclipse.papyrus.infra.core.resource.IModel;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.sashwindows.di.service.IPageManager;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.ui.editor.IMultiDiagramEditor;
import org.eclipse.papyrus.junit.framework.classification.tests.AbstractPapyrusTest;
import org.eclipse.papyrus.junit.utils.Activator;
import org.eclipse.papyrus.junit.utils.EditorUtils;
import org.eclipse.papyrus.junit.utils.PapyrusProjectUtils;
import org.eclipse.papyrus.junit.utils.ProjectUtils;
import org.eclipse.papyrus.views.modelexplorer.ModelExplorerPage;
import org.eclipse.papyrus.views.modelexplorer.ModelExplorerPageBookView;
import org.eclipse.papyrus.views.modelexplorer.ModelExplorerView;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.IPage;
import org.junit.After;
import org.junit.Assert;
import org.osgi.framework.Bundle;

public abstract class AbstractEditorTest
extends AbstractPapyrusTest {
    public static final String MODELEXPLORER_VIEW_ID = "org.eclipse.papyrus.views.modelexplorer.modelexplorer";
    protected IMultiDiagramEditor editor;
    protected IProject project;
    protected ModelExplorerView modelExplorerView;
    protected IFile diModelFile;

    protected Bundle getBundle() {
        return Activator.getDefault().getBundle();
    }

    protected IProject createProject(String projectName) throws Exception {
        this.project = ProjectUtils.createProject(projectName);
        return this.project;
    }

    protected void initModel(String projectName, String modelName, Bundle bundle) throws Exception {
        this.createProject(projectName);
        this.initModel(modelName, bundle);
    }

    protected void initModel(String modelName, Bundle bundle) throws Exception {
        this.diModelFile = PapyrusProjectUtils.copyPapyrusModel(this.project, bundle, this.getSourcePath(), modelName);
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    AbstractEditorTest.this.editor = EditorUtils.openPapyrusEditor(AbstractEditorTest.this.diModelFile);
                }
                catch (Exception ex) {
                    Activator.log.error((Throwable)ex);
                    Assert.fail((String)ex.getMessage());
                }
            }
        });
        Assert.assertNotNull((Object)this.editor);
    }

    protected void copyModel(String modelName, Bundle bundle) throws Exception {
        PapyrusProjectUtils.copyPapyrusModel(this.project, bundle, this.getSourcePath(), modelName);
    }

    @After
    public void dispose() throws Exception {
        if (this.editor != null) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    AbstractEditorTest.this.editor.getSite().getPage().closeEditor((IEditorPart)AbstractEditorTest.this.editor, false);
                }
            });
            this.editor = null;
        }
        if (this.project != null) {
            this.project.delete(true, (IProgressMonitor)new NullProgressMonitor());
            this.project = null;
        }
    }

    public ModelExplorerView getModelExplorerView() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                IViewPart modelexplorer;
                IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                try {
                    modelexplorer = activeWorkbenchWindow.getActivePage().showView(AbstractEditorTest.MODELEXPLORER_VIEW_ID);
                }
                catch (PartInitException ex) {
                    ex.printStackTrace(System.out);
                    return;
                }
                ModelExplorerPageBookView view = (ModelExplorerPageBookView)modelexplorer;
                IPage currentPage = view.getCurrentPage();
                ModelExplorerPage page = (ModelExplorerPage)currentPage;
                IViewPart viewer = page.getViewer();
                AbstractEditorTest.this.modelExplorerView = (ModelExplorerView)viewer;
            }
        });
        return this.modelExplorerView;
    }

    protected org.eclipse.uml2.uml.Package getRootUMLModel() {
        try {
            IModel umlIModel = this.getModelSet().getModel("org.eclipse.papyrus.infra.core.resource.uml.UmlModel");
            AbstractBaseModel umlModel = null;
            if (umlIModel instanceof AbstractBaseModel) {
                umlModel = (AbstractBaseModel)umlIModel;
            }
            Assert.assertFalse((String)"umlRessource contains nothing", (boolean)umlModel.getResource().getContents().isEmpty());
            Object root = umlModel.getResource().getContents().get(0);
            Assert.assertFalse((String)"the root of UML model is not a package", (boolean)(root instanceof Package));
            return (org.eclipse.uml2.uml.Package)root;
        }
        catch (ServiceException e) {
            Assert.fail((String)e.getMessage());
            return null;
        }
    }

    protected IPageManager getPageManager() throws ServiceException {
        return (IPageManager)this.getServicesRegistry().getService(IPageManager.class);
    }

    protected ServicesRegistry getServicesRegistry() throws ServiceException {
        return this.editor.getServicesRegistry();
    }

    protected TransactionalEditingDomain getTransactionalEditingDomain() throws ServiceException {
        return (TransactionalEditingDomain)this.getServicesRegistry().getService(TransactionalEditingDomain.class);
    }

    protected ModelSet getModelSet() throws ServiceException {
        return (ModelSet)this.getServicesRegistry().getService(ModelSet.class);
    }

    protected abstract String getSourcePath();

    protected void flushDisplayEvents() {
        while (true) {
            try {
                while (Display.getCurrent().readAndDispatch()) {
                }
            }
            catch (Exception e) {
                Bundle testBundle = this.getBundle();
                Platform.getLog((Bundle)testBundle).log((IStatus)new Status(4, testBundle.getSymbolicName(), "Uncaught exception in display runnable.", (Throwable)e));
                continue;
            }
            break;
        }
    }
}

