/*
 * Decompiled with CFR 0.152.
 */
package xpt.editor;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenApplication;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenCommonBase;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenDiagram;
import org.eclipse.papyrus.gmf.codegen.xtend.annotations.Localization;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import plugin.Activator;
import xpt.CodeStyle;
import xpt.Common;
import xpt.Externalizer;
import xpt.ExternalizerUtils_qvto;
import xpt.editor.DiagramContentInitializer;
import xpt.editor.DiagramEditorUtil;
import xpt.editor.ModelElementSelectionPage;
import xpt.editor.VisualIDRegistry;

@Singleton
public class NewDiagramFileWizard {
    @Inject
    @Extension
    private Common _common;
    @Inject
    @Extension
    private CodeStyle _codeStyle;
    @Inject
    @Extension
    private ExternalizerUtils_qvto _externalizerUtils_qvto;
    @Inject
    private Externalizer xptExternalizer;
    @Inject
    private Activator xptActivator;
    @Inject
    private DiagramEditorUtil xptDiagramEditorUtil;
    @Inject
    private VisualIDRegistry xptVisualIDRegistry;
    @Inject
    private DiagramContentInitializer xptDiagramContentInitializer;
    @Inject
    private ModelElementSelectionPage xptModelElementSelectionPage;

    public CharSequence className(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        String _newDiagramFileWizardClassName = it.getNewDiagramFileWizardClassName();
        _builder.append(_newDiagramFileWizardClassName);
        return _builder;
    }

    public CharSequence packageName(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        String _packageName = it.getEditorGen().getEditor().getPackageName();
        _builder.append(_packageName);
        return _builder;
    }

    public CharSequence qualifiedClassName(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _packageName = this.packageName(it);
        _builder.append((Object)_packageName);
        _builder.append(".");
        CharSequence _className = this.className(it);
        _builder.append((Object)_className);
        return _builder;
    }

    public CharSequence fullPath(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _qualifiedClassName = this.qualifiedClassName(it);
        _builder.append((Object)_qualifiedClassName);
        return _builder;
    }

    public CharSequence NewDiagramFileWizard(GenDiagram it) {
        boolean _isSynchronized;
        boolean _not;
        boolean _tripleEquals;
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _copyright = this._common.copyright(it.getEditorGen());
        _builder.append((Object)_copyright);
        _builder.newLineIfNotEmpty();
        _builder.append("package ");
        CharSequence _packageName = this.packageName(it);
        _builder.append((Object)_packageName);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _generatedClassComment = this._common.generatedClassComment();
        _builder.append((Object)_generatedClassComment);
        _builder.newLineIfNotEmpty();
        _builder.append("public class ");
        CharSequence _className = this.className(it);
        _builder.append((Object)_className);
        _builder.append(" extends org.eclipse.jface.wizard.Wizard {");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("private ");
        CharSequence _creationPage = this.creationPage(it);
        _builder.append((Object)_creationPage, "\t");
        _builder.append(" myFileCreationPage;");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        CharSequence _generatedMemberComment_1 = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment_1, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("private ");
        CharSequence _qualifiedClassName = this.xptModelElementSelectionPage.qualifiedClassName(it);
        _builder.append((Object)_qualifiedClassName, "\t");
        _builder.append(" diagramRootElementSelectionPage;");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        CharSequence _generatedMemberComment_2 = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment_2, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("private org.eclipse.emf.transaction.TransactionalEditingDomain myEditingDomain;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        CharSequence _generatedMemberComment_3 = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment_3, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("public ");
        CharSequence _className_1 = this.className(it);
        _builder.append((Object)_className_1, "\t");
        _builder.append("(org.eclipse.emf.common.util.URI domainModelURI, org.eclipse.emf.ecore.EObject diagramRoot, org.eclipse.emf.transaction.TransactionalEditingDomain editingDomain) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        CharSequence __assert = this._common._assert("domainModelURI != null : \"Domain model uri must be specified\"");
        _builder.append((Object)__assert, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        CharSequence __assert_1 = this._common._assert("diagramRoot != null : \"Diagram root element must be specified\"");
        _builder.append((Object)__assert_1, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        CharSequence __assert_2 = this._common._assert("editingDomain != null : \"Editing domain must be specified\"");
        _builder.append((Object)__assert_2, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("myFileCreationPage = new ");
        CharSequence _creationPage_1 = this.creationPage(it);
        _builder.append((Object)_creationPage_1, "\t\t");
        _builder.append("(");
        CharSequence _accessorCall = this.xptExternalizer.accessorCall(it.getEditorGen(), this._externalizerUtils_qvto.nameKey(this.i18nKeyForNewDiagramFileWizardCreationPage(it)));
        _builder.append((Object)_accessorCall, "\t\t");
        _builder.append(", org.eclipse.jface.viewers.StructuredSelection.EMPTY);");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("myFileCreationPage.setTitle(");
        CharSequence _accessorCall_1 = this.xptExternalizer.accessorCall(it.getEditorGen(), this._externalizerUtils_qvto.titleKey(this.i18nKeyForNewDiagramFileWizardCreationPage(it)));
        _builder.append((Object)_accessorCall_1, "\t\t");
        _builder.append(");");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("myFileCreationPage.setDescription(org.eclipse.osgi.util.NLS.bind(");
        CharSequence _accessorCall_2 = this.xptExternalizer.accessorCall(it.getEditorGen(), this._externalizerUtils_qvto.descriptionKey(this.i18nKeyForNewDiagramFileWizardCreationPage(it)));
        _builder.append((Object)_accessorCall_2, "\t\t");
        _builder.append(", ");
        CharSequence _modelID = VisualIDRegistry.modelID(it);
        _builder.append((Object)_modelID, "\t\t");
        _builder.append("));");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("org.eclipse.core.runtime.IPath filePath;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("String fileName = org.eclipse.emf.common.util.URI.decode(domainModelURI.trimFileExtension().lastSegment());");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if (domainModelURI.isPlatformResource()) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("filePath = new org.eclipse.core.runtime.Path(domainModelURI.trimSegments(1).toPlatformString(true));");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("} else if (domainModelURI.isFile()) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("filePath = new org.eclipse.core.runtime.Path(domainModelURI.trimSegments(1).toFileString());");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("} else {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("// TODO : use some default path");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("throw new IllegalArgumentException(\"Unsupported URI: \" + domainModelURI); ");
        CharSequence _nonNLS = this._common.nonNLS(1);
        _builder.append((Object)_nonNLS, "\t\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("myFileCreationPage.setContainerFullPath(filePath);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("myFileCreationPage.setFileName(");
        CharSequence _qualifiedClassName_1 = this.xptDiagramEditorUtil.qualifiedClassName(it);
        _builder.append((Object)_qualifiedClassName_1, "\t\t");
        _builder.append(".getUniqueFileName(filePath, fileName, \"");
        String _diagramFileExtension = it.getEditorGen().getDiagramFileExtension();
        _builder.append(_diagramFileExtension, "\t\t");
        _builder.append("\")); ");
        CharSequence _nonNLS_1 = this._common.nonNLS(1);
        _builder.append((Object)_nonNLS_1, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("diagramRootElementSelectionPage = new DiagramRootElementSelectionPage(");
        CharSequence _accessorCall_3 = this.xptExternalizer.accessorCall(it.getEditorGen(), this._externalizerUtils_qvto.nameKey(this.i18nKeyForNewDiagramFileWizardRootSelectionPage(it)));
        _builder.append((Object)_accessorCall_3, "\t\t");
        _builder.append(");");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("diagramRootElementSelectionPage.setTitle(");
        CharSequence _accessorCall_4 = this.xptExternalizer.accessorCall(it.getEditorGen(), this._externalizerUtils_qvto.titleKey(this.i18nKeyForNewDiagramFileWizardRootSelectionPage(it)));
        _builder.append((Object)_accessorCall_4, "\t\t");
        _builder.append(");");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("diagramRootElementSelectionPage.setDescription(");
        CharSequence _accessorCall_5 = this.xptExternalizer.accessorCall(it.getEditorGen(), this._externalizerUtils_qvto.descriptionKey(this.i18nKeyForNewDiagramFileWizardRootSelectionPage(it)));
        _builder.append((Object)_accessorCall_5, "\t\t");
        _builder.append(");");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("diagramRootElementSelectionPage.setModelElement(diagramRoot);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("myEditingDomain = editingDomain;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        CharSequence _generatedMemberComment_4 = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment_4, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _overrideC = this._codeStyle.overrideC(it);
        _builder.append((Object)_overrideC, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("public void addPages() {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("addPage(myFileCreationPage);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("addPage(diagramRootElementSelectionPage);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        CharSequence _generatedMemberComment_5 = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment_5, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _overrideC_1 = this._codeStyle.overrideC(it);
        _builder.append((Object)_overrideC_1, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("public boolean performFinish() {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("java.util.LinkedList<org.eclipse.core.resources.IFile> affectedFiles = new java.util.LinkedList<");
        String _diamondOp = this._codeStyle.diamondOp((GenCommonBase)it, "org.eclipse.core.resources.IFile");
        _builder.append(_diamondOp, "\t\t");
        _builder.append(">(); ");
        _builder.newLineIfNotEmpty();
        GenApplication _application = it.getEditorGen().getApplication();
        boolean bl = _tripleEquals = _application == null;
        if (_tripleEquals) {
            _builder.append("\t\t");
            _builder.append("org.eclipse.core.resources.IFile diagramFile = myFileCreationPage.createNewFile();");
            _builder.newLine();
            _builder.append("\t\t");
            CharSequence _callSetCharset = this.xptDiagramEditorUtil.callSetCharset(it, "diagramFile");
            _builder.append((Object)_callSetCharset, "\t\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("affectedFiles.add(diagramFile);");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("org.eclipse.emf.common.util.URI diagramModelURI = org.eclipse.emf.common.util.URI.createPlatformResourceURI(diagramFile.getFullPath().toString(), true);");
            _builder.newLine();
        } else {
            _builder.append("\t\t");
            _builder.append("org.eclipse.core.runtime.IPath diagramModelPath = myFileCreationPage.getContainerFullPath().append(myFileCreationPage.getFileName());");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("org.eclipse.emf.common.util.URI diagramModelURI = org.eclipse.emf.common.util.URI.createFileURI(diagramModelPath.toString());");
            _builder.newLine();
        }
        _builder.append("\t\t");
        _builder.append("org.eclipse.emf.ecore.resource.ResourceSet resourceSet = myEditingDomain.getResourceSet();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("final org.eclipse.emf.ecore.resource.Resource diagramResource = resourceSet.createResource(diagramModelURI);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand command =");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("new org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand(myEditingDomain, ");
        CharSequence _accessorCall_6 = this.xptExternalizer.accessorCall(it.getEditorGen(), this.i18nKeyForNewDiagramFileWizardInitDiagramCommand(it));
        _builder.append((Object)_accessorCall_6, "\t\t");
        _builder.append(", affectedFiles) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t");
        CharSequence _overrideC_2 = this._codeStyle.overrideC(it);
        _builder.append((Object)_overrideC_2, "\t\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t");
        _builder.append("protected org.eclipse.gmf.runtime.common.core.command.CommandResult doExecuteWithResult(org.eclipse.core.runtime.IProgressMonitor monitor, org.eclipse.core.runtime.IAdaptable info) throws org.eclipse.core.commands.ExecutionException {");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("String diagramVID = ");
        CharSequence _diagramVisualIDMethodCall = this.xptVisualIDRegistry.getDiagramVisualIDMethodCall(it);
        _builder.append((Object)_diagramVisualIDMethodCall, "\t\t\t\t");
        _builder.append("(diagramRootElementSelectionPage.getModelElement());");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t\t");
        _builder.append("if (diagramVID.equals(");
        CharSequence _visualID = VisualIDRegistry.visualID((GenCommonBase)it);
        _builder.append((Object)_visualID, "\t\t\t\t");
        _builder.append(")) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t\t\t");
        _builder.append("return org.eclipse.gmf.runtime.common.core.command.CommandResult.newErrorCommandResult(");
        CharSequence _accessorCall_7 = this.xptExternalizer.accessorCall(it.getEditorGen(), this.i18nKeyForNewDiagramFileWizardIncorrectRootError(it));
        _builder.append((Object)_accessorCall_7, "\t\t\t\t\t");
        _builder.append(");");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("org.eclipse.gmf.runtime.notation.Diagram diagram = org.eclipse.gmf.runtime.diagram.core.services.ViewService.createDiagram(diagramRootElementSelectionPage.getModelElement(), ");
        CharSequence _modelID_1 = VisualIDRegistry.modelID(it);
        _builder.append((Object)_modelID_1, "\t\t\t\t");
        _builder.append(", ");
        CharSequence _preferenceHintAccess = this.xptActivator.preferenceHintAccess(it.getEditorGen());
        _builder.append((Object)_preferenceHintAccess, "\t\t\t\t");
        _builder.append(");");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t\t");
        _builder.append("diagramResource.getContents().add(diagram);");
        _builder.newLine();
        boolean _isSameFileForDiagramAndModel = it.getEditorGen().isSameFileForDiagramAndModel();
        if (_isSameFileForDiagramAndModel) {
            _builder.append("\t\t\t\t");
            _builder.append("diagramResource.getContents().add(diagram.getElement());");
            _builder.newLine();
        }
        boolean bl2 = _not = !(_isSynchronized = it.isSynchronized());
        if (_not) {
            _builder.append("\t\t\t\t");
            _builder.append("new ");
            CharSequence _qualifiedClassName_2 = this.xptDiagramContentInitializer.qualifiedClassName(it);
            _builder.append((Object)_qualifiedClassName_2, "\t\t\t\t");
            _builder.append("().initDiagramContent(diagram);\t\t\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t\t\t\t");
        _builder.append("return org.eclipse.gmf.runtime.common.core.command.CommandResult.newOKCommandResult();");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("};");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("try {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("org.eclipse.core.commands.operations.OperationHistoryFactory.getOperationHistory().execute(command, new org.eclipse.core.runtime.NullProgressMonitor(), null);");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("diagramResource.save(");
        CharSequence _callGetSaveOptions = this.xptDiagramEditorUtil.callGetSaveOptions(it);
        _builder.append((Object)_callGetSaveOptions, "\t\t\t");
        _builder.append(");");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t");
        CharSequence _qualifiedClassName_3 = this.xptDiagramEditorUtil.qualifiedClassName(it);
        _builder.append((Object)_qualifiedClassName_3, "\t\t\t");
        _builder.append(".openDiagram(diagramResource);");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("} catch (org.eclipse.core.commands.ExecutionException e) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        CharSequence _qualifiedClassName_4 = this.xptActivator.qualifiedClassName(it.getEditorGen().getPlugin());
        _builder.append((Object)_qualifiedClassName_4, "\t\t\t");
        _builder.append(".getInstance().logError(\"Unable to create model and diagram\", e); ");
        CharSequence _nonNLS_2 = this._common.nonNLS(1);
        _builder.append((Object)_nonNLS_2, "\t\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("} catch (java.io.IOException ex) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        CharSequence _qualifiedClassName_5 = this.xptActivator.qualifiedClassName(it.getEditorGen().getPlugin());
        _builder.append((Object)_qualifiedClassName_5, "\t\t\t");
        _builder.append(".getInstance().logError(\"Save operation failed for: \" + diagramModelURI, ex); ");
        CharSequence _nonNLS_3 = this._common.nonNLS(1);
        _builder.append((Object)_nonNLS_3, "\t\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("} catch (org.eclipse.ui.PartInitException ex) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        CharSequence _qualifiedClassName_6 = this.xptActivator.qualifiedClassName(it.getEditorGen().getPlugin());
        _builder.append((Object)_qualifiedClassName_6, "\t\t\t");
        _builder.append(".getInstance().logError(\"Unable to open editor\", ex); ");
        CharSequence _nonNLS_4 = this._common.nonNLS(1);
        _builder.append((Object)_nonNLS_4, "\t\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("}\t\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return true;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        CharSequence _generatedClassComment_1 = this._common.generatedClassComment();
        _builder.append((Object)_generatedClassComment_1, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("private static class DiagramRootElementSelectionPage extends ");
        CharSequence _qualifiedClassName_7 = this.xptModelElementSelectionPage.qualifiedClassName(it);
        _builder.append((Object)_qualifiedClassName_7, "\t");
        _builder.append(" {");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t\t");
        CharSequence _generatedMemberComment_6 = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment_6, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("protected DiagramRootElementSelectionPage(String pageName) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("super(pageName);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t\t");
        CharSequence _generatedMemberComment_7 = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment_7, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        CharSequence _overrideC_3 = this._codeStyle.overrideC(it);
        _builder.append((Object)_overrideC_3, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("protected String getSelectionTitle() {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("return ");
        CharSequence _accessorCall_8 = this.xptExternalizer.accessorCall(it.getEditorGen(), this.i18nKeyForNewDiagramFileWizardRootSelectionPageSelectionTitle(it));
        _builder.append((Object)_accessorCall_8, "\t\t\t");
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t\t");
        CharSequence _generatedMemberComment_8 = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment_8, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        CharSequence _overrideC_4 = this._codeStyle.overrideC(it);
        _builder.append((Object)_overrideC_4, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("protected boolean validatePage() {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("if (getModelElement() == null) {");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("setErrorMessage(");
        CharSequence _accessorCall_9 = this.xptExternalizer.accessorCall(it.getEditorGen(), this.i18nKeyForNewDiagramFileWizardRootSelectionPageNoSelectionMessage(it));
        _builder.append((Object)_accessorCall_9, "\t\t\t\t");
        _builder.append(");");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t\t");
        _builder.append("return false;");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("boolean result = org.eclipse.gmf.runtime.diagram.core.services.ViewService.getInstance().provides(new org.eclipse.gmf.runtime.diagram.core.services.view.CreateDiagramViewOperation(new org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter(getModelElement()), ");
        CharSequence _modelID_2 = VisualIDRegistry.modelID(it);
        _builder.append((Object)_modelID_2, "\t\t\t");
        _builder.append(", ");
        CharSequence _preferenceHintAccess_1 = this.xptActivator.preferenceHintAccess(it.getEditorGen());
        _builder.append((Object)_preferenceHintAccess_1, "\t\t\t");
        _builder.append("));");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t");
        _builder.append("setErrorMessage(result ? null : ");
        CharSequence _accessorCall_10 = this.xptExternalizer.accessorCall(it.getEditorGen(), this.i18nKeyForNewDiagramFileWizardRootSelectionPageInvalidSelectionMessage(it));
        _builder.append((Object)_accessorCall_10, "\t\t\t");
        _builder.append(");");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t");
        _builder.append("return result;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence creationPage(GenDiagram it) {
        boolean _tripleEquals;
        StringConcatenation _builder = new StringConcatenation();
        GenApplication _application = it.getEditorGen().getApplication();
        boolean bl = _tripleEquals = _application == null;
        if (_tripleEquals) {
            _builder.append("org.eclipse.ui.dialogs.WizardNewFileCreationPage");
        } else {
            _builder.newLineIfNotEmpty();
            String _packageName = it.getEditorGen().getApplication().getPackageName();
            _builder.append(_packageName);
            _builder.append(".WizardNewFileCreationPage");
        }
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    @Localization
    public CharSequence i18nAccessors(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _accessorField = this.xptExternalizer.accessorField(this._externalizerUtils_qvto.nameKey(this.i18nKeyForNewDiagramFileWizardCreationPage(it)));
        _builder.append((Object)_accessorField);
        _builder.newLineIfNotEmpty();
        CharSequence _accessorField_1 = this.xptExternalizer.accessorField(this._externalizerUtils_qvto.titleKey(this.i18nKeyForNewDiagramFileWizardCreationPage(it)));
        _builder.append((Object)_accessorField_1);
        _builder.newLineIfNotEmpty();
        CharSequence _accessorField_2 = this.xptExternalizer.accessorField(this._externalizerUtils_qvto.descriptionKey(this.i18nKeyForNewDiagramFileWizardCreationPage(it)));
        _builder.append((Object)_accessorField_2);
        _builder.newLineIfNotEmpty();
        CharSequence _accessorField_3 = this.xptExternalizer.accessorField(this._externalizerUtils_qvto.nameKey(this.i18nKeyForNewDiagramFileWizardRootSelectionPage(it)));
        _builder.append((Object)_accessorField_3);
        _builder.newLineIfNotEmpty();
        CharSequence _accessorField_4 = this.xptExternalizer.accessorField(this._externalizerUtils_qvto.titleKey(this.i18nKeyForNewDiagramFileWizardRootSelectionPage(it)));
        _builder.append((Object)_accessorField_4);
        _builder.newLineIfNotEmpty();
        CharSequence _accessorField_5 = this.xptExternalizer.accessorField(this._externalizerUtils_qvto.descriptionKey(this.i18nKeyForNewDiagramFileWizardRootSelectionPage(it)));
        _builder.append((Object)_accessorField_5);
        _builder.newLineIfNotEmpty();
        CharSequence _accessorField_6 = this.xptExternalizer.accessorField(this.i18nKeyForNewDiagramFileWizardRootSelectionPageSelectionTitle(it));
        _builder.append((Object)_accessorField_6);
        _builder.newLineIfNotEmpty();
        CharSequence _accessorField_7 = this.xptExternalizer.accessorField(this.i18nKeyForNewDiagramFileWizardRootSelectionPageNoSelectionMessage(it));
        _builder.append((Object)_accessorField_7);
        _builder.newLineIfNotEmpty();
        CharSequence _accessorField_8 = this.xptExternalizer.accessorField(this.i18nKeyForNewDiagramFileWizardRootSelectionPageInvalidSelectionMessage(it));
        _builder.append((Object)_accessorField_8);
        _builder.newLineIfNotEmpty();
        CharSequence _accessorField_9 = this.xptExternalizer.accessorField(this.i18nKeyForNewDiagramFileWizardInitDiagramCommand(it));
        _builder.append((Object)_accessorField_9);
        _builder.newLineIfNotEmpty();
        CharSequence _accessorField_10 = this.xptExternalizer.accessorField(this.i18nKeyForNewDiagramFileWizardIncorrectRootError(it));
        _builder.append((Object)_accessorField_10);
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    @Localization
    public CharSequence i18nValues(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _messageEntry = this.xptExternalizer.messageEntry(this._externalizerUtils_qvto.nameKey(this.i18nKeyForNewDiagramFileWizardCreationPage(it)), "Initialize new diagram file");
        _builder.append((Object)_messageEntry);
        _builder.newLineIfNotEmpty();
        CharSequence _messageEntry_1 = this.xptExternalizer.messageEntry(this._externalizerUtils_qvto.titleKey(this.i18nKeyForNewDiagramFileWizardCreationPage(it)), "Diagram file");
        _builder.append((Object)_messageEntry_1);
        _builder.newLineIfNotEmpty();
        CharSequence _messageEntry_2 = this.xptExternalizer.messageEntry(this._externalizerUtils_qvto.descriptionKey(this.i18nKeyForNewDiagramFileWizardCreationPage(it)), "Create new diagram based on {0} model content");
        _builder.append((Object)_messageEntry_2);
        _builder.newLineIfNotEmpty();
        CharSequence _messageEntry_3 = this.xptExternalizer.messageEntry(this._externalizerUtils_qvto.nameKey(this.i18nKeyForNewDiagramFileWizardRootSelectionPage(it)), "Select diagram root element");
        _builder.append((Object)_messageEntry_3);
        _builder.newLineIfNotEmpty();
        CharSequence _messageEntry_4 = this.xptExternalizer.messageEntry(this._externalizerUtils_qvto.titleKey(this.i18nKeyForNewDiagramFileWizardRootSelectionPage(it)), "Diagram root element");
        _builder.append((Object)_messageEntry_4);
        _builder.newLineIfNotEmpty();
        CharSequence _messageEntry_5 = this.xptExternalizer.messageEntry(this._externalizerUtils_qvto.descriptionKey(this.i18nKeyForNewDiagramFileWizardRootSelectionPage(it)), "Select semantic model element to be depicted on diagram");
        _builder.append((Object)_messageEntry_5);
        _builder.newLineIfNotEmpty();
        CharSequence _messageEntry_6 = this.xptExternalizer.messageEntry(this.i18nKeyForNewDiagramFileWizardRootSelectionPageSelectionTitle(it), "Select diagram root element:");
        _builder.append((Object)_messageEntry_6);
        _builder.newLineIfNotEmpty();
        CharSequence _messageEntry_7 = this.xptExternalizer.messageEntry(this.i18nKeyForNewDiagramFileWizardRootSelectionPageNoSelectionMessage(it), "Diagram root element is not selected");
        _builder.append((Object)_messageEntry_7);
        _builder.newLineIfNotEmpty();
        CharSequence _messageEntry_8 = this.xptExternalizer.messageEntry(this.i18nKeyForNewDiagramFileWizardRootSelectionPageInvalidSelectionMessage(it), "Invalid diagram root element is selected");
        _builder.append((Object)_messageEntry_8);
        _builder.newLineIfNotEmpty();
        CharSequence _messageEntry_9 = this.xptExternalizer.messageEntry(this.i18nKeyForNewDiagramFileWizardInitDiagramCommand(it), "Initializing diagram contents");
        _builder.append((Object)_messageEntry_9);
        _builder.newLineIfNotEmpty();
        CharSequence _messageEntry_10 = this.xptExternalizer.messageEntry(this.i18nKeyForNewDiagramFileWizardIncorrectRootError(it), "Incorrect model object stored as a root resource object");
        _builder.append((Object)_messageEntry_10);
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    @Localization
    public String i18nKeyForNewDiagramFileWizard(GenDiagram diagram) {
        CharSequence _className = this.className(diagram);
        return String.valueOf(_className);
    }

    @Localization
    public String i18nKeyForNewDiagramFileWizardCreationPage(GenDiagram diagram) {
        String _i18nKeyForNewDiagramFileWizard = this.i18nKeyForNewDiagramFileWizard(diagram);
        return _i18nKeyForNewDiagramFileWizard + ".CreationPage";
    }

    @Localization
    public String i18nKeyForNewDiagramFileWizardRootSelectionPage(GenDiagram diagram) {
        String _i18nKeyForNewDiagramFileWizard = this.i18nKeyForNewDiagramFileWizard(diagram);
        return _i18nKeyForNewDiagramFileWizard + ".RootSelectionPage";
    }

    @Localization
    public String i18nKeyForNewDiagramFileWizardRootSelectionPageSelectionTitle(GenDiagram diagram) {
        String _i18nKeyForNewDiagramFileWizardRootSelectionPage = this.i18nKeyForNewDiagramFileWizardRootSelectionPage(diagram);
        return _i18nKeyForNewDiagramFileWizardRootSelectionPage + "SelectionTitle";
    }

    @Localization
    public String i18nKeyForNewDiagramFileWizardRootSelectionPageNoSelectionMessage(GenDiagram diagram) {
        String _i18nKeyForNewDiagramFileWizardRootSelectionPage = this.i18nKeyForNewDiagramFileWizardRootSelectionPage(diagram);
        return _i18nKeyForNewDiagramFileWizardRootSelectionPage + "NoSelectionMessage";
    }

    @Localization
    public String i18nKeyForNewDiagramFileWizardRootSelectionPageInvalidSelectionMessage(GenDiagram diagram) {
        String _i18nKeyForNewDiagramFileWizardRootSelectionPage = this.i18nKeyForNewDiagramFileWizardRootSelectionPage(diagram);
        return _i18nKeyForNewDiagramFileWizardRootSelectionPage + "InvalidSelectionMessage";
    }

    @Localization
    public String i18nKeyForNewDiagramFileWizardInitDiagramCommand(GenDiagram diagram) {
        String _i18nKeyForNewDiagramFileWizard = this.i18nKeyForNewDiagramFileWizard(diagram);
        return _i18nKeyForNewDiagramFileWizard + ".InitDiagramCommand";
    }

    @Localization
    public String i18nKeyForNewDiagramFileWizardIncorrectRootError(GenDiagram diagram) {
        String _i18nKeyForNewDiagramFileWizard = this.i18nKeyForNewDiagramFileWizard(diagram);
        return _i18nKeyForNewDiagramFileWizard + ".IncorrectRootError";
    }
}

