/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.textedit.ui.internal.viewpoint;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.papyrus.infra.architecture.ArchitectureDomainManager;
import org.eclipse.papyrus.infra.architecture.representation.PapyrusRepresentationKind;
import org.eclipse.papyrus.infra.textedit.representation.RepresentationPackage;
import org.eclipse.papyrus.infra.textedit.representation.TextDocumentRepresentation;
import org.eclipse.papyrus.infra.textedit.representation.command.ICreateTextDocumentEditorCommand;
import org.eclipse.papyrus.infra.textedit.textdocument.TextDocument;
import org.eclipse.papyrus.infra.textedit.ui.Activator;
import org.eclipse.papyrus.infra.textedit.ui.internal.viewpoint.TextDocumentViewPrototype;
import org.eclipse.papyrus.infra.tools.util.ClassLoaderHelper;
import org.eclipse.papyrus.infra.viewpoints.policy.IViewTypeHelper;
import org.eclipse.papyrus.infra.viewpoints.policy.PolicyChecker;
import org.eclipse.papyrus.infra.viewpoints.policy.ViewPrototype;

public class CreateTextDocumentViewTypeCommandHelper
implements IViewTypeHelper {
    private Map<PapyrusRepresentationKind, TextDocumentViewPrototype> cache;

    public boolean isSupported(EClass type) {
        return EcoreUtil.equals((EObject)type, (EObject)RepresentationPackage.eINSTANCE.getTextDocumentRepresentation());
    }

    public boolean isSupported(EObject view) {
        return view instanceof TextDocument;
    }

    public ViewPrototype getPrototypeFor(PapyrusRepresentationKind kind) {
        if (!(kind instanceof TextDocumentRepresentation)) {
            return null;
        }
        TextDocumentRepresentation textDocumentRepresentation = (TextDocumentRepresentation)kind;
        if (this.cache == null) {
            this.cache = new HashMap<PapyrusRepresentationKind, TextDocumentViewPrototype>();
        }
        if (this.cache.containsKey(textDocumentRepresentation)) {
            return this.cache.get(textDocumentRepresentation);
        }
        String creationCommandClassName = textDocumentRepresentation.getCreationCommandClass();
        if (creationCommandClassName == null || creationCommandClassName.isEmpty()) {
            return null;
        }
        Class creationCommandClass = ClassLoaderHelper.loadClass((String)creationCommandClassName);
        if (creationCommandClass != null) {
            try {
                Constructor constructor = creationCommandClass.getDeclaredConstructor(new Class[0]);
                Object newInstance = constructor.newInstance(new Object[0]);
                if (newInstance instanceof ICreateTextDocumentEditorCommand) {
                    ICreateTextDocumentEditorCommand command = (ICreateTextDocumentEditorCommand)newInstance;
                    TextDocumentViewPrototype proto = new TextDocumentViewPrototype(textDocumentRepresentation, command);
                    this.cache.put((PapyrusRepresentationKind)textDocumentRepresentation, proto);
                    return proto;
                }
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | SecurityException e) {
                Activator.log.error((Throwable)e);
            }
            catch (IllegalArgumentException e) {
                Activator.log.error((Throwable)e);
            }
            catch (InvocationTargetException e) {
                Activator.log.error((Throwable)e);
            }
        }
        return null;
    }

    public ViewPrototype getPrototypeOf(EObject view) {
        if (!this.isSupported(view)) {
            return null;
        }
        PolicyChecker checker = PolicyChecker.getFor((EObject)view);
        ArchitectureDomainManager manager = ArchitectureDomainManager.getInstance();
        TextDocumentRepresentation repKind = (TextDocumentRepresentation)manager.getRepresentationKindById(((TextDocument)view).getKindId());
        if (repKind != null && checker.isInViewpoint((PapyrusRepresentationKind)repKind)) {
            return this.getPrototypeFor((PapyrusRepresentationKind)repKind);
        }
        return ViewPrototype.UNAVAILABLE_VIEW;
    }
}

