/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.viewpoints.policy;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.papyrus.infra.gmfdiag.representation.PathElement;

public class ModelAddData {
    private boolean permit;
    private List<EReference> path;
    private EObject undoOrigin;
    private EReference undoReference;
    private EObject undoValuePrevious;
    private EObject undoValueNext;

    public boolean isPermitted() {
        return this.permit;
    }

    public boolean isPathDefined() {
        return this.path != null;
    }

    public ModelAddData(boolean permit) {
        this.permit = permit;
    }

    public ModelAddData(boolean permit, EList<PathElement> insertionPath) {
        this.permit = permit;
        if (insertionPath != null && !insertionPath.isEmpty()) {
            this.path = new ArrayList<EReference>(insertionPath.size());
            int i = 0;
            while (i != insertionPath.size()) {
                this.path.add(((PathElement)insertionPath.get(i)).getFeature());
                ++i;
            }
        }
    }

    public boolean execute(EObject origin, EObject target) {
        EObject current = origin;
        int index = 0;
        while (index < this.path.size() - 1) {
            if ((current = this.buildPathStep(current, this.path.get(index))) == null) {
                return false;
            }
            ++index;
        }
        EReference feature = this.path.get(this.path.size() - 1);
        if (feature.isMany()) {
            EList list = (EList)current.eGet((EStructuralFeature)feature);
            list.add((Object)target);
            this.setUndo(current, feature, null, target);
        } else {
            this.setUndo(current, feature, (EObject)current.eGet((EStructuralFeature)feature), target);
            current.eSet((EStructuralFeature)feature, (Object)target);
        }
        return true;
    }

    public void undoExecute() {
        if (this.undoReference.isMany()) {
            ((EList)this.undoOrigin.eGet((EStructuralFeature)this.undoReference)).remove((Object)this.undoValueNext);
        } else {
            this.undoOrigin.eSet((EStructuralFeature)this.undoReference, (Object)this.undoValuePrevious);
        }
    }

    public void redoExecute() {
        if (this.undoReference.isMany()) {
            ((EList)this.undoOrigin.eGet((EStructuralFeature)this.undoReference)).add((Object)this.undoValueNext);
        } else {
            this.undoOrigin.eSet((EStructuralFeature)this.undoReference, (Object)this.undoValueNext);
        }
    }

    private EObject buildPathStep(EObject current, EReference feature) {
        Object value = current.eGet((EStructuralFeature)feature);
        if (value == null) {
            EClass type = feature.getEReferenceType();
            if (type.isAbstract()) {
                return null;
            }
            EObject inst = EcoreUtil.create((EClass)type);
            current.eSet((EStructuralFeature)feature, (Object)inst);
            this.setUndo(current, feature, null, inst);
            return inst;
        }
        if (value instanceof EList) {
            EList list = (EList)value;
            if (!list.isEmpty()) {
                return (EObject)list.get(0);
            }
            EClass type = feature.getEReferenceType();
            if (type.isAbstract()) {
                return null;
            }
            EObject inst = EcoreUtil.create((EClass)type);
            list.add((Object)inst);
            this.setUndo(current, feature, null, inst);
            return inst;
        }
        return (EObject)value;
    }

    private void setUndo(EObject origin, EReference feature, EObject previous, EObject next) {
        if (this.undoReference == null) {
            return;
        }
        this.undoOrigin = origin;
        this.undoReference = feature;
        this.undoValuePrevious = previous;
        this.undoValueNext = next;
    }
}

