/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.emf.facet.util.emf.core.internal.serialization;

import org.eclipse.core.runtime.Plugin;
import org.eclipse.papyrus.emf.facet.util.core.Logger;
import org.eclipse.papyrus.emf.facet.util.emf.core.internal.Activator;
import org.eclipse.papyrus.emf.facet.util.emf.core.serialization.ISerializationRegistry;
import org.eclipse.papyrus.emf.facet.util.emf.core.serialization.ISerializationService;
import org.eclipse.papyrus.emf.facet.util.emf.core.serialization.ISerializer;

public class SerializationService
implements ISerializationService {
    @Override
    public String serialize(Object instanceValue) {
        if (instanceValue == null) {
            return "null";
        }
        ISerializer<?> serializer = ISerializationRegistry.INSTANCE.getSerializerFor(instanceValue.getClass());
        if (serializer != null) {
            return serializer.getType().getName() + ":" + serializer.serialize(instanceValue);
        }
        Logger.logError((String)("serialization of type " + instanceValue.getClass().getName() + " is not implemented."), (Plugin)Activator.getDefault());
        return "null";
    }

    @Override
    public Object deserialize(String serializedValue) {
        block5: {
            if (!"null".equals(serializedValue)) break block5;
            return null;
        }
        try {
            int colonPos = serializedValue.indexOf(58);
            if (colonPos == -1) {
                throw new IllegalArgumentException("invalid serialization format");
            }
            String type = serializedValue.substring(0, colonPos);
            String strValue = serializedValue.substring(colonPos + 1);
            ISerializer<?> serializer = ISerializationRegistry.INSTANCE.getSerializerFor(type);
            if (serializer != null) {
                Object value = serializer.deserialize(strValue);
                return value;
            }
            Logger.logError((String)("deserialization of type " + type + " is not implemented."), (Plugin)Activator.getDefault());
        }
        catch (Exception e) {
            Logger.logError((Throwable)e, (String)("Error deserializing: " + serializedValue), (Plugin)Activator.getDefault());
        }
        return null;
    }
}

