/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.filters;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum OperatorKind implements Enumerator
{
    AND(0, "and", "and"),
    OR(1, "or", "or"),
    XOR(2, "xor", "xor"),
    NOT(3, "not", "not");

    public static final int AND_VALUE = 0;
    public static final int OR_VALUE = 1;
    public static final int XOR_VALUE = 2;
    public static final int NOT_VALUE = 3;
    private static final OperatorKind[] VALUES_ARRAY;
    public static final List<OperatorKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new OperatorKind[]{AND, OR, XOR, NOT};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static OperatorKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            OperatorKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static OperatorKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            OperatorKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static OperatorKind get(int value) {
        switch (value) {
            case 0: {
                return AND;
            }
            case 1: {
                return OR;
            }
            case 2: {
                return XOR;
            }
            case 3: {
                return NOT;
            }
        }
        return null;
    }

    private OperatorKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

