/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.requirements.sysml14.papyrusre.modellibrary.papyrusrestandardutils.requirementclassificationconcerns;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ConstraintKind implements Enumerator
{
    CULTURAL(0, "Cultural", "Cultural"),
    DESIGN(1, "Design", "Design"),
    ENVIRONMENT(2, "Environment", "Environment"),
    IMPLEMENTATION(3, "Implementation", "Implementation"),
    INTERFACE(4, "Interface", "Interface"),
    PHYSICAL(5, "Physical", "Physical"),
    STANDARD(6, "Standard", "Standard"),
    OTHER(7, "Other", "Other"),
    UNDEFINED(8, "Undefined", "Undefined");

    public static final int CULTURAL_VALUE = 0;
    public static final int DESIGN_VALUE = 1;
    public static final int ENVIRONMENT_VALUE = 2;
    public static final int IMPLEMENTATION_VALUE = 3;
    public static final int INTERFACE_VALUE = 4;
    public static final int PHYSICAL_VALUE = 5;
    public static final int STANDARD_VALUE = 6;
    public static final int OTHER_VALUE = 7;
    public static final int UNDEFINED_VALUE = 8;
    private static final ConstraintKind[] VALUES_ARRAY;
    public static final List<ConstraintKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ConstraintKind[]{CULTURAL, DESIGN, ENVIRONMENT, IMPLEMENTATION, INTERFACE, PHYSICAL, STANDARD, OTHER, UNDEFINED};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ConstraintKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ConstraintKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ConstraintKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ConstraintKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ConstraintKind get(int value) {
        switch (value) {
            case 0: {
                return CULTURAL;
            }
            case 1: {
                return DESIGN;
            }
            case 2: {
                return ENVIRONMENT;
            }
            case 3: {
                return IMPLEMENTATION;
            }
            case 4: {
                return INTERFACE;
            }
            case 5: {
                return PHYSICAL;
            }
            case 6: {
                return STANDARD;
            }
            case 7: {
                return OTHER;
            }
            case 8: {
                return UNDEFINED;
            }
        }
        return null;
    }

    private ConstraintKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

