/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.transformation.core.transformations;

import java.util.HashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.papyrus.designer.deployment.profile.Deployment.DeploymentPlan;
import org.eclipse.papyrus.designer.deployment.tools.DepUtils;
import org.eclipse.papyrus.designer.languages.common.base.TestInfo;
import org.eclipse.papyrus.designer.transformation.base.UIContext;
import org.eclipse.papyrus.designer.transformation.base.utils.CommandSupport;
import org.eclipse.papyrus.designer.transformation.base.utils.ModelManagement;
import org.eclipse.papyrus.designer.transformation.base.utils.TrafoUtils;
import org.eclipse.papyrus.designer.transformation.base.utils.TransformationException;
import org.eclipse.papyrus.designer.transformation.core.Activator;
import org.eclipse.papyrus.designer.transformation.core.EnumService;
import org.eclipse.papyrus.designer.transformation.core.Messages;
import org.eclipse.papyrus.designer.transformation.core.templates.TemplateInstantiation;
import org.eclipse.papyrus.designer.transformation.core.transformations.ExecuteTransformationChain;
import org.eclipse.papyrus.designer.transformation.core.transformations.LazyCopier;
import org.eclipse.papyrus.designer.transformation.core.transformations.TransformationContext;
import org.eclipse.papyrus.designer.transformation.core.transformations.TransformationUtil;
import org.eclipse.papyrus.designer.transformation.core.transformations.filters.FilterLoadReferencedModels;
import org.eclipse.papyrus.designer.transformation.profile.Transformation.M2MTrafoChain;
import org.eclipse.papyrus.uml.tools.utils.PackageUtil;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.util.UMLUtil;

public class InstantiateDepPlan {
    public static final String TEMP_MODEL_FOLDER = "tmpModel";
    public static final String TEMP_MODEL_POSTFIX = "Tmp.uml";
    protected IProgressMonitor monitor = null;
    protected int generationOptions;
    protected Package srcModelComponentDeploymentPlan = null;
    protected IProject project;
    protected IProject genProject;

    public void instantiate(Package pkg, IProgressMonitor monitor, IProject project, int genOptions) {
        this.srcModelComponentDeploymentPlan = pkg;
        this.project = project;
        if (project == null) {
            String projectName = pkg.eResource().getURI().toString();
            this.project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        }
        this.instantiate(monitor, genOptions);
    }

    private void instantiate(IProgressMonitor monitor, int genOptions) {
        try {
            try {
                this.initialize(monitor, genOptions);
                this.executeTransformation();
            }
            catch (TransformationException e) {
                ModelManagement.getResourceSet().getResources().clear();
                this.printAndDisplayErrorMessage((Exception)((Object)e), Messages.InstantiateDepPlan_TransformationException, false);
                TransformationContext.current = null;
            }
            catch (Exception e) {
                ModelManagement.getResourceSet().getResources().clear();
                this.printAndDisplayErrorMessage(e, Messages.InstantiateDepPlan_ErrorsDuringTransformation, true);
                TransformationContext.current = null;
            }
        }
        finally {
            TransformationContext.current = null;
        }
    }

    private void initialize(IProgressMonitor monitor, int genOptions) throws TransformationException {
        this.monitor = monitor;
        this.generationOptions = genOptions;
    }

    protected void executeTransformation() throws Exception {
        TransformationContext tc;
        ModelManagement intermediateModelManagement = null;
        UIContext.monitor = this.monitor;
        UIContext.configureProject = (this.generationOptions & 1) != 0;
        Model existingModel = this.srcModelComponentDeploymentPlan.getModel();
        TransformationContext.current = tc = new TransformationContext();
        TransformationContext.initialSourceRoot = existingModel;
        TransformationContext.initialDeploymentPlan = this.srcModelComponentDeploymentPlan;
        TransformationContext.current.mm = intermediateModelManagement = ModelManagement.createNewModel((String)existingModel.getName());
        Package intermediateModel = intermediateModelManagement.getModel();
        EnumService.createEnumPackage(intermediateModel);
        LazyCopier intermediateModelCopier = new LazyCopier((Package)existingModel, intermediateModel, LazyCopier.CopyExtResources.ALL, true);
        intermediateModelCopier.preCopyListeners.add((Object)FilterLoadReferencedModels.getInstance());
        HashMap<InstanceSpecification, InstanceSpecification> instanceMap = new HashMap<InstanceSpecification, InstanceSpecification>();
        if (DepUtils.isDeploymentPlan((Package)this.srcModelComponentDeploymentPlan)) {
            for (InstanceSpecification instance : DepUtils.getInstances((Package)this.srcModelComponentDeploymentPlan)) {
                InstanceSpecification newInstance = intermediateModelCopier.getCopy(instance);
                this.checkProgressStatus();
                TransformationUtil.propagateAllocation(newInstance);
                instanceMap.put(instance, newInstance);
            }
        } else {
            intermediateModelCopier.shallowCopy((EObject)this.srcModelComponentDeploymentPlan);
            for (PackageableElement pe : this.srcModelComponentDeploymentPlan.getPackagedElements()) {
                intermediateModelCopier.getCopy(pe);
                this.checkProgressStatus();
            }
        }
        tc.copier = intermediateModelCopier;
        tc.deploymentPlan = intermediateModelCopier.getCopy(this.srcModelComponentDeploymentPlan);
        tc.modelRoot = PackageUtil.getRootPackage((Package)tc.deploymentPlan);
        M2MTrafoChain chain = TrafoUtils.getTransformationChain((Package)tc.deploymentPlan);
        TemplateInstantiation.init();
        ExecuteTransformationChain.apply(chain, TrafoUtils.getAdditionalTransformations((Package)this.srcModelComponentDeploymentPlan));
        intermediateModelManagement.setURI(this.project, TEMP_MODEL_FOLDER, TEMP_MODEL_POSTFIX);
        for (ModelManagement mm : tc.copier.getAdditionalRootPkgs()) {
            mm.setURI(this.project, TEMP_MODEL_FOLDER, TEMP_MODEL_POSTFIX);
        }
        intermediateModelManagement.save();
        for (ModelManagement mm : tc.copier.getAdditionalRootPkgs()) {
            mm.save();
        }
        this.checkProgressStatus();
        intermediateModelManagement.dispose();
        for (ModelManagement mm : tc.copier.getAdditionalRootPkgs()) {
            mm.dispose();
        }
    }

    public void updateProjectMapping(final String canonicalProjectName, final String userProjectName) {
        CommandSupport.exec((EObject)this.srcModelComponentDeploymentPlan, (String)"Update project mapping", (Runnable)new Runnable(){

            @Override
            public void run() {
                DeploymentPlan depPlan = (DeploymentPlan)UMLUtil.getStereotypeApplication((Element)InstantiateDepPlan.this.srcModelComponentDeploymentPlan, DeploymentPlan.class);
                String mapName = String.valueOf(canonicalProjectName) + "=" + userProjectName;
                for (String mapping : depPlan.getProjectMappings()) {
                    if (!mapping.startsWith(canonicalProjectName)) continue;
                    mapping = mapName;
                    return;
                }
                depPlan.getProjectMappings().add((Object)mapName);
            }
        });
    }

    private void checkProgressStatus() throws InterruptedException {
        if (this.monitor.isCanceled()) {
            throw new InterruptedException();
        }
        this.monitor.worked(1);
    }

    private void printAndDisplayErrorMessage(Exception e, String title, boolean consultConsole) {
        String message = e.toString();
        if (consultConsole) {
            message = String.valueOf(message) + "\n\n" + Messages.InstantiateDepPlan_ConsultConsole;
        }
        this.printAndDisplayErrorMessage(e, title, message, consultConsole);
    }

    private void printAndDisplayErrorMessage(Exception e, String title, String message, boolean consultConsole) {
        e.printStackTrace();
        if (!TestInfo.runsHeadless()) {
            this.displayError(title, message);
        }
        Activator.log.error((Throwable)e);
    }

    private void displayError(final String title, final String message) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                Shell shell = Display.getCurrent().getActiveShell();
                MessageDialog.openInformation((Shell)shell, (String)title, (String)message);
            }
        });
    }
}

