/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.transformation.languages.cpp.library;

import java.util.List;
import java.util.Stack;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.papyrus.designer.deployment.tools.DepUtils;
import org.eclipse.papyrus.designer.languages.common.base.ElementUtils;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Include;
import org.eclipse.papyrus.designer.transformation.base.utils.LibraryUtils;
import org.eclipse.papyrus.designer.transformation.base.utils.ModelManagement;
import org.eclipse.papyrus.designer.transformation.base.utils.TransformationException;
import org.eclipse.papyrus.designer.transformation.core.Messages;
import org.eclipse.papyrus.designer.transformation.core.m2minterfaces.IM2MTrafoCDP;
import org.eclipse.papyrus.designer.transformation.core.transformations.LazyCopier;
import org.eclipse.papyrus.designer.transformation.core.transformations.TransformationContext;
import org.eclipse.papyrus.designer.transformation.library.transformations.AbstractBootLoaderGen;
import org.eclipse.papyrus.designer.transformation.profile.Transformation.M2MTrafo;
import org.eclipse.papyrus.uml.tools.utils.StereotypeUtil;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.LiteralInteger;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Slot;
import org.eclipse.uml2.uml.StructuralFeature;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class BootLoaderGenCpp
extends AbstractBootLoaderGen
implements IM2MTrafoCDP {
    public static final URI CPP_BOOTLOADER_URI = URI.createURI((String)"pathmap://DML_TRAFOS_CPP/BootLoaderCpp.uml");
    public static final String CPP_BOOTLOADER_QNAME = "BootLoaderCpp::BootLoader";
    public static final String CPP_NODEINFO_QNAME = "BootLoaderCpp::NodeInfo";

    public void init(LazyCopier copier, int nodeIndex, int numberOfNodes) throws TransformationException {
        Class _copy;
        this.outputSizeof = false;
        super.init(copier, nodeIndex, numberOfNodes);
        ResourceSet _resourceSet = ModelManagement.getResourceSet();
        Element _content = LibraryUtils.getContent((URI)CPP_BOOTLOADER_URI, (ResourceSet)_resourceSet);
        Package bootloader_ml = (Package)_content;
        if (bootloader_ml == null) {
            String _format = String.format(Messages.BootLoaderGen_CannotRetrieveTemplate, CPP_BOOTLOADER_URI);
            throw new TransformationException(_format);
        }
        NamedElement _qualifiedElement = ElementUtils.getQualifiedElement((Package)bootloader_ml, (String)CPP_BOOTLOADER_QNAME);
        Class template = (Class)_qualifiedElement;
        if (template == null) {
            String _format_1 = String.format(Messages.BootLoaderGen_CannotRetrieveTemplate, CPP_BOOTLOADER_QNAME);
            throw new TransformationException(_format_1);
        }
        this.m_bootLoader = _copy = (Class)copier.getCopy((Element)template);
        Include cppInclude = (Include)StereotypeUtil.applyApp((Element)this.m_bootLoader, Include.class);
        if (cppInclude == null) {
            throw new TransformationException("Cannot apply cppInclude stereotype. Make sure that the C/C++ profile is applied to your model.");
        }
        String existingBody = cppInclude.getBody();
        String bodyStr = "";
        if (this.outputSizeof) {
            String _bodyStr = bodyStr;
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("#include <iostream>");
            _builder.newLine();
            _builder.append("using namespace std");
            _builder.newLine();
            bodyStr = String.valueOf(_bodyStr) + _builder;
        }
        cppInclude.setBody(String.valueOf(existingBody) + bodyStr);
        NamedElement _qualifiedElement_1 = ElementUtils.getQualifiedElement((Package)bootloader_ml, (String)CPP_NODEINFO_QNAME);
        Class nodeInfo = (Class)_qualifiedElement_1;
        Property nodeIndexElem = nodeInfo.getAttribute("nodeIndex", null);
        Property numberOfNodesElem = nodeInfo.getAttribute("numberOfNodes", null);
        ValueSpecification _defaultValue = nodeIndexElem.getDefaultValue();
        ((LiteralInteger)_defaultValue).setValue(nodeIndex + 0);
        ValueSpecification _defaultValue_1 = numberOfNodesElem.getDefaultValue();
        ((LiteralInteger)_defaultValue_1).setValue(numberOfNodes);
        copier.getCopy((Element)nodeInfo);
    }

    public String languageCreateInstance(InstanceSpecification is, Class implementation) {
        StringConcatenation _builder = new StringConcatenation();
        return _builder.toString();
    }

    public String languageCreateConn(String varName) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append(varName, "");
        _builder.append(".");
        _builder.append("createConnections", "");
        _builder.append("();");
        _builder.newLineIfNotEmpty();
        return _builder.toString();
    }

    public String languageRunStart(String varName, boolean useOO) {
        StringConcatenation _builder = new StringConcatenation();
        if (useOO) {
            _builder.append(varName, "");
            _builder.append(".run();");
            _builder.newLineIfNotEmpty();
        } else {
            _builder.append(varName, "");
            _builder.append(".get_start()->run();");
            _builder.newLineIfNotEmpty();
        }
        return _builder.toString();
    }

    public String languageAssignRef(String accessName, String referenceVarName) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append(accessName, "");
        _builder.append(" = &");
        _builder.append(referenceVarName, "");
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        return _builder.toString();
    }

    public void instanceConfig(Stack<Slot> slotPath, InstanceSpecification instance) throws TransformationException {
        Slot slot = slotPath.peek();
        StructuralFeature sf = slot.getDefiningFeature();
        if (sf == null) {
            String _name = instance.getName();
            String _format = String.format("A slot for instance %s has no defining feature", _name);
            throw new TransformationException(_format);
        }
        String _name_1 = instance.getName();
        String _plus = String.valueOf(_name_1) + ".";
        String _name_2 = sf.getName();
        String varName = String.valueOf(_plus) + _name_2;
        EList _values = slot.getValues();
        for (ValueSpecification value : _values) {
            boolean _tripleNotEquals;
            String _stringValue = value.stringValue();
            boolean bl = _tripleNotEquals = _stringValue != null;
            if (!_tripleNotEquals) continue;
            String _m_initCodeCConfig = this.m_initCodeCConfig;
            String _stringValue_1 = value.stringValue();
            String _plus_1 = String.valueOf(varName) + " = " + _stringValue_1;
            String _plus_2 = String.valueOf(_plus_1) + ";\n";
            this.m_initCodeCConfig = String.valueOf(_m_initCodeCConfig) + _plus_2;
        }
    }

    public void applyTrafo(M2MTrafo trafo, Package deploymentPlan) throws TransformationException {
        this.init(TransformationContext.current.copier, 0, 0);
        Stack slotPath = new Stack();
        EList _topLevelInstances = DepUtils.getTopLevelInstances((Package)deploymentPlan);
        for (InstanceSpecification is : _topLevelInstances) {
            this.addInstance(is, slotPath);
        }
        this.addInit("C/C++");
    }

    public void languageInit() {
    }

    public String languageActivation(Class[] activationKeys) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.newLine();
        _builder.append("// activation code");
        _builder.newLine();
        Class[] classArray = activationKeys;
        int n = activationKeys.length;
        int n2 = 0;
        while (n2 < n) {
            Class implementation = classArray[n2];
            EList varNameList = (EList)this.m_activation.get(implementation);
            _builder.newLineIfNotEmpty();
            for (String varName : varNameList) {
                _builder.append(varName, "");
                _builder.append(".get_lc()->activate();");
                _builder.newLineIfNotEmpty();
            }
            ++n2;
        }
        return _builder.toString();
    }

    public String languageDeactivation(Class[] activationKeys) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.newLine();
        _builder.append("// deactivation code (reverse order)");
        _builder.newLine();
        List _reverse = ListExtensions.reverse((List)((List)Conversions.doWrapArray((Object)activationKeys)));
        for (Class implementation : _reverse) {
            EList varNameList = (EList)this.m_activation.get(implementation);
            _builder.newLineIfNotEmpty();
            for (String varName : varNameList) {
                _builder.append(varName, "");
                _builder.append(".get_lc()->deactivate();");
                _builder.newLineIfNotEmpty();
            }
        }
        return _builder.toString();
    }

    public String languageDefaultExecCode() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("// no user entry point => enter endless loop");
        _builder.newLine();
        _builder.append("for (;;) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("usleep(100);");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder.toString();
    }
}

