/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.bpmn.BPMNProfile;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ProcessType implements Enumerator
{
    NONE(0, "none", "none"),
    PUBLIC(1, "public", "public"),
    PRIVATE(2, "private", "private");

    public static final int NONE_VALUE = 0;
    public static final int PUBLIC_VALUE = 1;
    public static final int PRIVATE_VALUE = 2;
    private static final ProcessType[] VALUES_ARRAY;
    public static final List<ProcessType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ProcessType[]{NONE, PUBLIC, PRIVATE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ProcessType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ProcessType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ProcessType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ProcessType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ProcessType get(int value) {
        switch (value) {
            case 0: {
                return NONE;
            }
            case 1: {
                return PUBLIC;
            }
            case 2: {
                return PRIVATE;
            }
        }
        return null;
    }

    private ProcessType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

