/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfindex.query;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.emf.emfindex.ContainerDescriptor;
import org.eclipse.emf.emfindex.MemoryIndexImpl;
import org.eclipse.emf.emfindex.ResourceDescriptor;
import org.eclipse.emf.emfindex.query.AbstractBaseQueryExecutorStrategy;
import org.eclipse.emf.emfindex.query.LazyQueryResultImpl;
import org.eclipse.emf.emfindex.query.QueryResult;
import org.eclipse.emf.emfindex.query.ResourceDescriptorQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceQueryExecutorStrategyImpl
extends AbstractBaseQueryExecutorStrategy<ResourceDescriptor, ResourceDescriptorQuery, MemoryIndexImpl> {
    @Override
    public boolean canExecute(ResourceDescriptorQuery query, MemoryIndexImpl index) {
        return true;
    }

    @Override
    public QueryResult<ResourceDescriptor> execute(final ResourceDescriptorQuery query, final MemoryIndexImpl index) {
        return new LazyQueryResultImpl<ResourceDescriptor>(new Iterable<ResourceDescriptor>(){

            @Override
            public Iterator<ResourceDescriptor> iterator() {
                return ResourceQueryExecutorStrategyImpl.this.getResult(query, index);
            }
        });
    }

    public Iterator<ResourceDescriptor> getResult(final ResourceDescriptorQuery query, MemoryIndexImpl index) {
        Iterator containerDescriptors = query.getContainerQuery() != null ? index.getQueryExecutor().execute(query.getContainerQuery()).iterator() : index.allContainerDescriptors();
        ArrayList scope = new ArrayList();
        if (!containerDescriptors.hasNext()) {
            scope.add(index.allResourceDescriptors());
        } else {
            do {
                scope.add(((ContainerDescriptor)containerDescriptors.next()).getResourceDescriptors().iterator());
            } while (containerDescriptors.hasNext());
        }
        return Iterators.filter((Iterator)Iterators.concat(scope.iterator()), (Predicate)new Predicate<ResourceDescriptor>(){

            public boolean apply(ResourceDescriptor candidate) {
                return ResourceQueryExecutorStrategyImpl.this.match(query, candidate);
            }
        });
    }

    @Override
    protected boolean internalMatch(ResourceDescriptorQuery query, ResourceDescriptor candidate) {
        return !(query.getIndexedVersionAfter() >= candidate.getIndexedVersion() || query.getIndexedVersionBefore() <= candidate.getIndexedVersion() || query.getURI() != null && !query.getURI().equals((Object)candidate.getURI()) || !query.getURINotIn().isEmpty() && query.getURINotIn().contains(candidate.getURI()));
    }
}

