/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfindex.ui.builder;

import com.google.inject.Inject;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.emfindex.Logger;
import org.eclipse.emf.emfindex.query.QueryExecutor;
import org.eclipse.emf.emfindex.store.IndexUpdater;
import org.eclipse.emf.emfindex.store.ResourceIndexer;
import org.eclipse.emf.emfindex.store.UpdateCommand;
import org.eclipse.emf.emfindex.store.UpdateableIndex;

public class EmfIndexProjectBuilder
extends IncrementalProjectBuilder {
    public static final String BUILDER_ID = "org.eclipse.emf.emfindex.ui.emfIndexBuilder";
    @Inject
    private ResourceIndexer.Registry indexerRegistry;
    @Inject
    private Logger logger;
    @Inject
    private UpdateableIndex index;

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        if (kind == 6) {
            this.fullBuild(monitor);
        } else {
            IResourceDelta delta = this.getDelta(this.getProject());
            if (delta == null) {
                this.fullBuild(monitor);
            } else {
                this.incrementalBuild(delta, monitor);
            }
        }
        return null;
    }

    protected void fullBuild(IProgressMonitor monitor) throws CoreException {
        try {
            this.getProject().accept(new IResourceVisitor(){

                public boolean visit(IResource resource) {
                    EmfIndexProjectBuilder.this.tryIndexResource(resource, false);
                    return resource instanceof IContainer;
                }
            });
        }
        catch (CoreException e) {
            this.logger.logError("Error during full build", (Throwable)e);
        }
    }

    protected void incrementalBuild(IResourceDelta delta, IProgressMonitor monitor) throws CoreException {
        delta.accept(new IResourceDeltaVisitor(){

            public boolean visit(IResourceDelta delta) throws CoreException {
                IResource resource = delta.getResource();
                switch (delta.getKind()) {
                    case 1: 
                    case 4: {
                        EmfIndexProjectBuilder.this.tryIndexResource(resource, false);
                        break;
                    }
                    case 2: {
                        EmfIndexProjectBuilder.this.tryIndexResource(resource, true);
                    }
                }
                return resource instanceof IContainer;
            }
        });
    }

    protected boolean tryIndexResource(IResource resource, final boolean isDeleted) {
        if (resource instanceof IFile) {
            IFile file = (IFile)resource;
            if (file.isDerived()) {
                return false;
            }
            try {
                final URI resourceURI = URI.createPlatformResourceURI((String)resource.getFullPath().toString(), (boolean)true);
                final ResourceIndexer resourceIndexer = this.indexerRegistry.getResourceIndexer(resourceURI);
                if (resourceIndexer != null) {
                    this.index.executeUpdateCommand((UpdateCommand)new UpdateCommand<Boolean>(){

                        public Boolean execute(IndexUpdater indexUpdater, QueryExecutor queryExecutor) {
                            if (isDeleted) {
                                resourceIndexer.resourceDeleted(resourceURI, indexUpdater);
                            } else {
                                resourceIndexer.resourceChanged(resourceURI, indexUpdater);
                            }
                            return true;
                        }
                    });
                }
            }
            catch (Exception e) {
                this.logger.logError("Cannot index resource " + resource.getFullPath().toString(), (Throwable)e);
            }
        }
        return false;
    }
}

