/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfindex.store;

import com.google.inject.Inject;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.emfindex.ContainerDescriptor;
import org.eclipse.emf.emfindex.MemoryIndexImpl;
import org.eclipse.emf.emfindex.ResourceDescriptor;
import org.eclipse.emf.emfindex.URI2ResourceCache;
import org.eclipse.emf.emfindex.store.DescriptorFactory;
import org.eclipse.emf.emfindex.store.DescriptorFactoryImpl;
import org.eclipse.emf.emfindex.store.IndexUpdater;

public class IndexUpdaterImpl
implements IndexUpdater {
    private MemoryIndexImpl index;
    private DescriptorFactory descriptorFactory;

    @Inject
    public IndexUpdaterImpl(MemoryIndexImpl index) {
        this.index = index;
        index.addIndexAdapter(new URI2ResourceCache());
        this.descriptorFactory = new DescriptorFactoryImpl();
    }

    public void add(ContainerDescriptor containerContainerDescriptor, ContainerDescriptor newContainerDescriptor) {
    }

    public void update(ContainerDescriptor rootContainerDescriptor) {
    }

    public void deleteContainerDescriptor(String name) {
    }

    public void deleteResourceDescriptor(URI resourceURI) {
        ResourceDescriptor existingResourceDescriptor = this.index.findIndexAdapter(URI2ResourceCache.class).findResourceDescriptor(resourceURI);
        if (existingResourceDescriptor != null) {
            this.remove((EObject)existingResourceDescriptor);
        }
    }

    public void update(ResourceDescriptor rootResourceDescriptor) {
        URI resourceURI = rootResourceDescriptor.getURI();
        ResourceDescriptor existingResourceDescriptor = this.index.findIndexAdapter(URI2ResourceCache.class).findResourceDescriptor(resourceURI);
        if (existingResourceDescriptor != null) {
            EcoreUtil.replace((EObject)((EObject)existingResourceDescriptor), (EObject)((EObject)rootResourceDescriptor));
        } else {
            Resource newIndexResource = this.index.createResource();
            newIndexResource.getContents().add((Object)((EObject)rootResourceDescriptor));
        }
        Resource indexResource = ((EObject)rootResourceDescriptor).eResource();
        if (indexResource != null) {
            indexResource.setModified(true);
        }
    }

    private void remove(EObject oldObject) {
        Resource.Internal resource = ((InternalEObject)oldObject).eDirectResource();
        EcoreUtil.remove((EObject)oldObject);
        if (resource != null) {
            if (resource.getContents().isEmpty()) {
                this.index.deleteResource((Resource)resource);
            } else {
                resource.setModified(true);
            }
        }
    }

    public DescriptorFactory getDescriptorFactory() {
        return this.descriptorFactory;
    }
}

