/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.jpa;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.eclipse.emf.teneo.PersistenceOptions;
import org.eclipse.emf.teneo.TeneoException;
import org.eclipse.emf.teneo.annotations.mapper.PersistenceMappingBuilder;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEPackage;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedModel;
import org.eclipse.emf.teneo.extension.ExtensionManager;
import org.eclipse.emf.teneo.extension.ExtensionManagerFactory;
import org.eclipse.emf.teneo.jpa.convert.ORMGenerator;

public class GenerateORM {
    public static void main(String[] args) {
        Properties options = new Properties();
        ArrayList<String> ecores = new ArrayList<String>();
        String targetFileName = null;
        int i = 0;
        while (i < args.length) {
            if (i == 0) {
                targetFileName = args[0];
            } else if (args[i].startsWith("+")) {
                String[] keyValue = args[i].substring(1).split(",");
                options.put(keyValue[0], keyValue[1]);
            } else if (args[i].startsWith("-")) {
                String[] epacks;
                String[] stringArray = epacks = args[i].substring(1).split(",");
                int n = epacks.length;
                int n2 = 0;
                while (n2 < n) {
                    String element = stringArray[n2];
                    try {
                        Class.forName(element);
                    }
                    catch (Throwable t) {
                        t.printStackTrace(System.err);
                    }
                    ++n2;
                }
            } else {
                ecores.add(args[i]);
            }
            ++i;
        }
        GenerateORM.createORMapperFile(targetFileName, ecores.toArray(new String[ecores.size()]), options);
    }

    private static void createORMapperFile(String targetFileName, String[] ecores, Properties options) {
        try {
            File firstEcore = new File(ecores[0]);
            File file = new File(firstEcore.getParentFile(), targetFileName);
            File archiveFile = new File(firstEcore.getParentFile(), String.valueOf(targetFileName) + "_old");
            if (file.exists()) {
                if (archiveFile.exists()) {
                    archiveFile.delete();
                }
                GenerateORM.copyFile(file, archiveFile);
                file.delete();
            }
            file.createNewFile();
            ExtensionManager extensionManager = ExtensionManagerFactory.getInstance().create();
            ORMGenerator converter = new ORMGenerator();
            PersistenceOptions po = converter.getDefaultPersistenceOptions(options);
            PAnnotatedModel paModel = ((PersistenceMappingBuilder)extensionManager.getExtension(PersistenceMappingBuilder.class)).buildMapping(ecores, po, extensionManager);
            String orm = converter.generateORM((List<PAnnotatedEPackage>)paModel.getPaEPackages(), po);
            FileWriter writer = new FileWriter(file);
            writer.write(orm);
            writer.flush();
        }
        catch (IOException e) {
            throw new TeneoException("IOException when creating or mapping file", (Throwable)e);
        }
    }

    public static void copyFile(File src, File dst) throws IOException {
        int len;
        if (!dst.exists()) {
            dst.createNewFile();
        }
        FileInputStream in = new FileInputStream(src);
        FileOutputStream out = new FileOutputStream(dst);
        byte[] buf = new byte[1024];
        while ((len = ((InputStream)in).read(buf)) > 0) {
            ((OutputStream)out).write(buf, 0, len);
        }
        ((InputStream)in).close();
        ((OutputStream)out).close();
    }
}

