/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.eclipselink.common.ui.wizards.pages;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.edit.provider.AdapterFactoryItemDelegator;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.teneo.eclipselink.common.ui.Activator;
import org.eclipse.emf.teneo.eclipselink.common.ui.internal.messages.Messages;
import org.eclipse.emf.teneo.eclipselink.common.ui.wizards.pages.BasicModelAndDatabaseAccessParametersPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRootObjectAndModelEditorPage
extends WizardPage {
    protected static QualifiedName rootObjectName = new QualifiedName(Activator.getDefault().getBundle().getSymbolicName(), "rootObject");
    protected static QualifiedName editorIdName = new QualifiedName(Activator.getDefault().getBundle().getSymbolicName(), "editorId");
    protected Combo rootObjectField;
    protected Combo editorIdField;
    protected AdapterFactoryItemDelegator adapterFactoryItemDelegator;
    protected List<EObject> rootObjectCandidates = new ArrayList<EObject>();

    public AbstractRootObjectAndModelEditorPage(String pageName) {
        super(pageName);
        ReflectiveItemProviderAdapterFactory adapterFactory = new ReflectiveItemProviderAdapterFactory();
        this.adapterFactoryItemDelegator = new AdapterFactoryItemDelegator((AdapterFactory)adapterFactory);
    }

    public EObject getRootObject() {
        EObject result = null;
        for (EObject eObject : this.rootObjectCandidates) {
            String name = this.adapterFactoryItemDelegator.getText((Object)eObject);
            if (!name.equals(this.rootObjectField.getText())) continue;
            result = eObject;
        }
        return result;
    }

    public String getEditorId() {
        return this.editorIdField.getText();
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(768));
        new Label(composite, 16384).setText(Messages.label_rootObject);
        this.rootObjectField = new Combo(composite, 2048);
        this.rootObjectField.setLayoutData((Object)new GridData(768));
        this.rootObjectField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AbstractRootObjectAndModelEditorPage.this.setPageComplete(AbstractRootObjectAndModelEditorPage.this.validatePage());
                EObject rootObject = AbstractRootObjectAndModelEditorPage.this.getRootObject();
                if (rootObject != null) {
                    URI uri = AbstractRootObjectAndModelEditorPage.this.createDatabaseURI(AbstractRootObjectAndModelEditorPage.this.getTypedPreviousPage().getPersistenceUnitName(), rootObject);
                    AbstractRootObjectAndModelEditorPage.this.setMessage(NLS.bind((String)Messages.message_loadsModelFromDatabaseUsingURI$0, (Object)uri));
                }
            }
        });
        new Label(composite, 16384).setText(Messages.label_editorID);
        this.editorIdField = new Combo(composite, 2048);
        this.editorIdField.setLayoutData((Object)new GridData(768));
        this.initEditorIdField();
        this.editorIdField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AbstractRootObjectAndModelEditorPage.this.setPageComplete(AbstractRootObjectAndModelEditorPage.this.validatePage());
            }
        });
        this.setPageComplete(this.validatePage());
        this.setControl((Control)composite);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.updateRootObjectField();
        } else {
            this.persistWidgets();
        }
    }

    public void dispose() {
        this.persistWidgets();
        super.dispose();
    }

    protected void initEditorIdField() {
        for (String editorId : this.getEditorIds()) {
            this.editorIdField.add(editorId);
        }
        int index = 0;
        try {
            String lastEditorId = ResourcesPlugin.getWorkspace().getRoot().getPersistentProperty(editorIdName);
            index = Arrays.asList(this.editorIdField.getItems()).indexOf(lastEditorId);
            index = index != -1 ? index : 0;
        }
        catch (CoreException cex) {
            Activator.getDefault().getLog().log(cex.getStatus());
        }
        this.editorIdField.select(index);
    }

    protected void updateRootObjectField() {
        this.rootObjectField.removeAll();
        this.rootObjectCandidates = this.loadRootObjectCandidates();
        for (EObject eObject : this.rootObjectCandidates) {
            String label = this.adapterFactoryItemDelegator.getText((Object)eObject);
            this.rootObjectField.add(label);
        }
        int index = 0;
        try {
            String lastRootObject = ResourcesPlugin.getWorkspace().getRoot().getPersistentProperty(rootObjectName);
            index = Arrays.asList(this.rootObjectField.getItems()).indexOf(lastRootObject);
            index = index != -1 ? index : 0;
        }
        catch (CoreException cex) {
            Activator.getDefault().getLog().log(cex.getStatus());
        }
        this.rootObjectField.select(index);
    }

    protected boolean validatePage() {
        this.setErrorMessage(null);
        if (this.isBlank(this.rootObjectField.getText())) {
            this.setErrorMessage(Messages.error_rootObjectMissing);
            return false;
        }
        if (!Arrays.asList(this.rootObjectField.getItems()).contains(this.rootObjectField.getText())) {
            this.setErrorMessage(Messages.error_rootObjectMustBeExistingRootObjectCandidate);
            return false;
        }
        if (this.isBlank(this.editorIdField.getText())) {
            this.setErrorMessage(Messages.error_editorIDMissing);
            return false;
        }
        if (!Arrays.asList(this.editorIdField.getItems()).contains(this.editorIdField.getText())) {
            this.setErrorMessage(Messages.error_editorIDMustIdentifyExistingEditor);
            return false;
        }
        return true;
    }

    protected void persistWidgets() {
        try {
            ResourcesPlugin.getWorkspace().getRoot().setPersistentProperty(rootObjectName, this.rootObjectField.getText());
            ResourcesPlugin.getWorkspace().getRoot().setPersistentProperty(editorIdName, this.editorIdField.getText());
        }
        catch (CoreException cex) {
            Activator.getDefault().getLog().log(cex.getStatus());
        }
    }

    protected abstract URI createDatabaseURI(String var1, EClass var2);

    protected abstract URI createDatabaseURI(String var1, EObject var2);

    protected abstract Map<String, Object> getPersistenceUnitProperties();

    protected abstract Map<String, Object> getDatabaseLoginOptionsFromPreviousPage();

    protected boolean isBlank(String string) {
        return string == null || string.trim().length() == 0;
    }

    protected BasicModelAndDatabaseAccessParametersPage getTypedPreviousPage() {
        return (BasicModelAndDatabaseAccessParametersPage)this.getPreviousPage();
    }

    protected List<EObject> loadRootObjectCandidates() {
        ArrayList<EObject> result;
        block9: {
            result = new ArrayList<EObject>();
            EPackage ePackage = EPackage.Registry.INSTANCE.getEPackage(this.getTypedPreviousPage().getPackageNsURI());
            EClass eRootClass = (EClass)ePackage.getEClassifier(this.getTypedPreviousPage().getRootObjectTypeName());
            URI uri = this.createDatabaseURI(this.getTypedPreviousPage().getPersistenceUnitName(), eRootClass);
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            resourceSet.getLoadOptions().putAll(this.getPersistenceUnitProperties());
            if ("from_user_preferences".equals(this.getTypedPreviousPage().getUseLoginFrom())) {
                resourceSet.getLoadOptions().putAll(this.getDatabaseLoginOptionsFromPreviousPage());
            }
            Resource resource = null;
            try {
                try {
                    resource = resourceSet.getResource(uri, true);
                    EList contents = resource.getContents();
                    if (contents.size() > 0) {
                        result.addAll((Collection<EObject>)contents);
                        break block9;
                    }
                    this.setErrorMessage(NLS.bind((String)Messages.error_databaseContainsNo$0Objects, (Object)eRootClass.getName()));
                }
                catch (Exception exception) {
                    this.setErrorMessage(Messages.error_failedToOpenDatabase);
                    Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.emf.teneo.eclipselink.common.ui", exception.getMessage(), (Throwable)exception));
                    if (resource != null) {
                        resource.unload();
                    }
                }
            }
            finally {
                if (resource != null) {
                    resource.unload();
                }
            }
        }
        return result;
    }

    protected List<String> getEditorIds() {
        ArrayList<String> result = new ArrayList<String>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] elements = registry.getConfigurationElementsFor("org.eclipse.ui.editors");
        if (elements != null) {
            IConfigurationElement[] iConfigurationElementArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement element = iConfigurationElementArray[n2];
                String extensions = element.getAttribute("extensions");
                if (extensions != null && extensions.indexOf("database") != -1) {
                    result.add(element.getAttribute("id"));
                }
                ++n2;
            }
        }
        return result;
    }
}

