/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.hibernate;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EPackageConstructor {
    private static final Log log = LogFactory.getLog(EPackageConstructor.class);
    private List<EPackage> ePackages = null;
    private List<String> ecoreModelClasses = new ArrayList<String>();
    private List<String> ecoreModelFiles = new ArrayList<String>();
    private boolean initialized = false;

    public void setModelFiles(List<String> ecoreModelFiles) {
        this.ecoreModelFiles = ecoreModelFiles;
    }

    public void setModelClasses(List<String> ecoreModelClasses) {
        this.ecoreModelClasses = ecoreModelClasses;
    }

    public List<EPackage> getEPackages() {
        if (this.ePackages == null) {
            this.initialize();
        }
        return this.ePackages;
    }

    private void initialize() {
        if (this.initialized) {
            return;
        }
        log.debug((Object)"Reading EPackages");
        ArrayList<EPackage> ePacks = new ArrayList<EPackage>();
        ePacks.addAll(this.buildFromModelClasses());
        ePacks.addAll(this.buildFromModelFiles());
        for (EPackage epackage : ePacks) {
            log.info((Object)("Registered EPackage: " + epackage.getNsURI()));
        }
        for (EPackage ePackage : new ArrayList(ePacks)) {
            this.addSubPackages(ePacks, ePackage);
        }
        this.ePackages = ePacks;
        this.initialized = true;
    }

    private void addSubPackages(List<EPackage> list, EPackage ePackage) {
        for (EPackage subPackage : ePackage.getESubpackages()) {
            if (list.contains(subPackage)) continue;
            list.add(subPackage);
            this.addSubPackages(list, subPackage);
        }
    }

    private List<EPackage> buildFromModelClasses() {
        ArrayList<EPackage> result = new ArrayList<EPackage>();
        for (String ecoreModelPackageClassName : this.ecoreModelClasses) {
            try {
                Class<?> cls = this.getClass().getClassLoader().loadClass(ecoreModelPackageClassName);
                Method m = cls.getMethod("init", new Class[0]);
                EPackage emp = (EPackage)m.invoke(null, new Object[0]);
                result.add(emp);
            }
            catch (Exception e) {
                throw new IllegalStateException("Excption while trying to retrieve EcoreModelPackage instance from class: " + ecoreModelPackageClassName, e);
            }
        }
        return result;
    }

    private List<EPackage> buildFromModelFiles() {
        ArrayList<String> ecoreFiles = new ArrayList<String>();
        ArrayList<String> xsdFiles = new ArrayList<String>();
        for (String modelFile : this.ecoreModelFiles) {
            if (modelFile.endsWith(".xsd")) {
                xsdFiles.add(modelFile.trim());
                continue;
            }
            if (!modelFile.trim().endsWith(".ecore")) {
                log.warn((Object)("Filename " + modelFile + " passed as modelFile but it does not end on either " + "xsd or ecore, processing it anyway."));
            }
            ecoreFiles.add(modelFile.trim());
        }
        ArrayList<EPackage> result = new ArrayList<EPackage>();
        result.addAll(this.readFromEcore(ecoreFiles));
        return result;
    }

    private List<EPackage> readFromEcore(List<String> ecoreFiles) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new EcoreResourceFactoryImpl());
        ArrayList<EPackage> epackages = new ArrayList<EPackage>();
        for (String ecoreFile : ecoreFiles) {
            log.debug((Object)("Reading ecore file: " + ecoreFile));
            try {
                java.net.URI netURI = this.getClass().getResource(ecoreFile).toURI();
                Resource res = resourceSet.getResource(URI.createURI((String)netURI.toString()), true);
                for (Object obj : res.getContents()) {
                    if (!(obj instanceof EPackage)) continue;
                    epackages.add((EPackage)obj);
                }
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        return epackages;
    }
}

