/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.samples.emf.schemaconstructs.substitutionzvon.util;

import java.math.BigInteger;
import java.util.Collection;
import java.util.Map;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.emf.ecore.xml.type.util.XMLTypeValidator;
import org.eclipse.emf.teneo.samples.emf.schemaconstructs.substitutionzvon.ComplexAAA;
import org.eclipse.emf.teneo.samples.emf.schemaconstructs.substitutionzvon.ComplexEvenType;
import org.eclipse.emf.teneo.samples.emf.schemaconstructs.substitutionzvon.ComplexOddType;
import org.eclipse.emf.teneo.samples.emf.schemaconstructs.substitutionzvon.DocumentRoot;
import org.eclipse.emf.teneo.samples.emf.schemaconstructs.substitutionzvon.RootType;
import org.eclipse.emf.teneo.samples.emf.schemaconstructs.substitutionzvon.SubstitutionzvonPackage;

public class SubstitutionzvonValidator
extends EObjectValidator {
    public static final SubstitutionzvonValidator INSTANCE = new SubstitutionzvonValidator();
    public static final String DIAGNOSTIC_SOURCE = "org.eclipse.emf.teneo.samples.emf.schemaconstructs.substitutionzvon";
    private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 0;
    protected static final int DIAGNOSTIC_CODE_COUNT = 0;
    protected XMLTypeValidator xmlTypeValidator = XMLTypeValidator.INSTANCE;
    public static final BigInteger AAA__MIN__VALUE = new BigInteger("1");
    public static final BigInteger AAA__MAX__VALUE = new BigInteger("9");
    public static final Collection EVEN_TYPE__ENUMERATION__VALUES = SubstitutionzvonValidator.wrapEnumerationValues((Object[])new Object[]{new BigInteger("2"), new BigInteger("4"), new BigInteger("6"), new BigInteger("8")});
    public static final Collection ODD_TYPE__ENUMERATION__VALUES = SubstitutionzvonValidator.wrapEnumerationValues((Object[])new Object[]{new BigInteger("1"), new BigInteger("3"), new BigInteger("5"), new BigInteger("7"), new BigInteger("9")});

    protected EPackage getEPackage() {
        return SubstitutionzvonPackage.eINSTANCE;
    }

    protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map context) {
        switch (classifierID) {
            case 0: {
                return this.validateComplexAAA((ComplexAAA)value, diagnostics, context);
            }
            case 1: {
                return this.validateComplexEvenType((ComplexEvenType)value, diagnostics, context);
            }
            case 2: {
                return this.validateComplexOddType((ComplexOddType)value, diagnostics, context);
            }
            case 3: {
                return this.validateDocumentRoot((DocumentRoot)value, diagnostics, context);
            }
            case 4: {
                return this.validateRootType((RootType)value, diagnostics, context);
            }
            case 5: {
                return this.validateAAA((BigInteger)value, diagnostics, context);
            }
            case 6: {
                return this.validateEvenType((BigInteger)value, diagnostics, context);
            }
            case 7: {
                return this.validateOddType((BigInteger)value, diagnostics, context);
            }
        }
        return true;
    }

    public boolean validateComplexAAA(ComplexAAA complexAAA, DiagnosticChain diagnostics, Map context) {
        return this.validate_EveryDefaultConstraint(complexAAA, diagnostics, context);
    }

    public boolean validateComplexEvenType(ComplexEvenType complexEvenType, DiagnosticChain diagnostics, Map context) {
        return this.validate_EveryDefaultConstraint(complexEvenType, diagnostics, context);
    }

    public boolean validateComplexOddType(ComplexOddType complexOddType, DiagnosticChain diagnostics, Map context) {
        return this.validate_EveryDefaultConstraint(complexOddType, diagnostics, context);
    }

    public boolean validateDocumentRoot(DocumentRoot documentRoot, DiagnosticChain diagnostics, Map context) {
        return this.validate_EveryDefaultConstraint(documentRoot, diagnostics, context);
    }

    public boolean validateRootType(RootType rootType, DiagnosticChain diagnostics, Map context) {
        return this.validate_EveryDefaultConstraint(rootType, diagnostics, context);
    }

    public boolean validateAAA(BigInteger aaa, DiagnosticChain diagnostics, Map context) {
        boolean result = this.validateAAA_Min(aaa, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validateAAA_Max(aaa, diagnostics, context);
        }
        return result;
    }

    public boolean validateAAA_Min(BigInteger aaa, DiagnosticChain diagnostics, Map context) {
        boolean result;
        boolean bl = result = aaa.compareTo(AAA__MIN__VALUE) >= 0;
        if (!result && diagnostics != null) {
            this.reportMinViolation(SubstitutionzvonPackage.eINSTANCE.getAAA(), aaa, AAA__MIN__VALUE, true, diagnostics, context);
        }
        return result;
    }

    public boolean validateAAA_Max(BigInteger aaa, DiagnosticChain diagnostics, Map context) {
        boolean result;
        boolean bl = result = aaa.compareTo(AAA__MAX__VALUE) <= 0;
        if (!result && diagnostics != null) {
            this.reportMaxViolation(SubstitutionzvonPackage.eINSTANCE.getAAA(), aaa, AAA__MAX__VALUE, true, diagnostics, context);
        }
        return result;
    }

    public boolean validateEvenType(BigInteger evenType, DiagnosticChain diagnostics, Map context) {
        boolean result = this.validateEvenType_Enumeration(evenType, diagnostics, context);
        return result;
    }

    public boolean validateEvenType_Enumeration(BigInteger evenType, DiagnosticChain diagnostics, Map context) {
        boolean result = EVEN_TYPE__ENUMERATION__VALUES.contains(evenType);
        if (!result && diagnostics != null) {
            this.reportEnumerationViolation(SubstitutionzvonPackage.eINSTANCE.getEvenType(), evenType, EVEN_TYPE__ENUMERATION__VALUES, diagnostics, context);
        }
        return result;
    }

    public boolean validateOddType(BigInteger oddType, DiagnosticChain diagnostics, Map context) {
        boolean result = this.validateOddType_Enumeration(oddType, diagnostics, context);
        return result;
    }

    public boolean validateOddType_Enumeration(BigInteger oddType, DiagnosticChain diagnostics, Map context) {
        boolean result = ODD_TYPE__ENUMERATION__VALUES.contains(oddType);
        if (!result && diagnostics != null) {
            this.reportEnumerationViolation(SubstitutionzvonPackage.eINSTANCE.getOddType(), oddType, ODD_TYPE__ENUMERATION__VALUES, diagnostics, context);
        }
        return result;
    }
}

