/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.jpox.mapper.property;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEAttribute;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEStructuralFeature;
import org.eclipse.emf.teneo.annotations.pannotation.Column;
import org.eclipse.emf.teneo.extension.ExtensionPoint;
import org.eclipse.emf.teneo.jpox.mapper.AbstractMapper;
import org.eclipse.emf.teneo.simpledom.Element;

public class BasicMapper
extends AbstractMapper
implements ExtensionPoint {
    protected static final Log log = LogFactory.getLog(BasicMapper.class);

    public void map(PAnnotatedEAttribute aAttribute, Element eclassElement) {
        log.debug((Object)("Processing basic field: " + aAttribute.getModelElement().getName()));
        Element field = eclassElement.addElement("field");
        field.addAttribute("name", this.namingHandler.correctName(this.mappingContext, (EStructuralFeature)aAttribute.getModelElement())).addAttribute("persistence-modifier", "persistent");
        EAttribute eAttribute = aAttribute.getModelEAttribute();
        if (eAttribute.getEType().getInstanceClass() != null && eAttribute.getEType().getInstanceClass().isArray()) {
            field.addAttribute("embedded", "true");
            field.addElement("array").addAttribute("embedded-element", "true");
            return;
        }
        Column overridden = this.mappingContext.getAttributeOverride((PAnnotatedEStructuralFeature)aAttribute);
        if (overridden != null) {
            this.mappingContext.getColumnMapper().map(overridden, field);
        } else if (aAttribute.getColumn() != null) {
            this.mappingContext.getColumnMapper().map(aAttribute.getColumn(), field);
        } else if (this.mappingContext.getEmbeddingFeature() != null) {
            PAnnotatedEStructuralFeature pae = this.mappingContext.getEmbeddingFeature();
            String name = String.valueOf(pae.getModelEStructuralFeature().getName()) + "_" + aAttribute.getModelEAttribute().getName() + "_ID";
            field.addAttribute("column", name);
        }
        field.addAttribute("null-value", this.mappingContext.isForceOptional() || aAttribute.getBasic().isOptional() ? "none" : "exception");
        Class instanceClass = eAttribute.getEAttributeType().getInstanceClass();
        if (Object.class.equals((Object)instanceClass)) {
            field.addAttribute("serialized", "true");
        } else if (instanceClass.getName().indexOf(".") != -1 && !Object.class.getPackage().equals(instanceClass.getPackage())) {
            field.addAttribute("embedded", "true");
        }
        if (aAttribute.requiresIsSetMapping()) {
            eclassElement.addElement("field").addAttribute("name", String.valueOf(eAttribute.getName()) + "ESet").addAttribute("persistence-modifier", "persistent");
        }
    }
}

