/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.jpox.mapper.property;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.teneo.annotations.mapper.StoreMappingException;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEAttribute;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEClass;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEReference;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEStructuralFeature;
import org.eclipse.emf.teneo.ecore.EModelResolver;
import org.eclipse.emf.teneo.extension.ExtensionPoint;
import org.eclipse.emf.teneo.jpox.mapper.AbstractMapper;
import org.eclipse.emf.teneo.simpledom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EClassFeatureMapper
extends AbstractMapper
implements ExtensionPoint {
    protected static final Log log = LogFactory.getLog(EClassFeatureMapper.class);

    public void map(PAnnotatedEClass aClass, Element classElement) {
        log.debug((Object)("Processing aclass: " + aClass.getModelEClass().getName() + "/" + aClass.getModelElement().getName()));
        Class implClass = EModelResolver.instance().getJavaClass((EClassifier)aClass.getModelEClass());
        ArrayList<PAnnotatedEStructuralFeature> features = new ArrayList<PAnnotatedEStructuralFeature>((Collection<PAnnotatedEStructuralFeature>)aClass.getPaEStructuralFeatures());
        List inheritedFeatures = this.mappingContext.getInheritedFeatures(aClass);
        features.addAll(inheritedFeatures);
        for (PAnnotatedEStructuralFeature aStructuralFeature : features) {
            EReference eref;
            boolean isTransient;
            boolean bl = isTransient = aStructuralFeature.getTransient() != null;
            if (!isTransient && aStructuralFeature.getColumn() != null) {
                boolean bl2 = isTransient = isTransient || !aStructuralFeature.getColumn().isInsertable() && !aStructuralFeature.getColumn().isUpdatable();
            }
            if (aStructuralFeature.getModelElement() instanceof EReference && (eref = (EReference)aStructuralFeature.getModelElement()).isContainer()) continue;
            if (isTransient && this.hasJavaMember(implClass, aStructuralFeature.getModelEStructuralFeature())) {
                Element field = classElement.addElement("field");
                field.addAttribute("name", this.namingHandler.correctName(this.mappingContext, (EStructuralFeature)aStructuralFeature.getModelElement())).addAttribute("persistence-modifier", "none");
                log.debug((Object)("TRANSIENT: " + aStructuralFeature.getModelElement().getName()));
                continue;
            }
            if (isTransient) continue;
            this.mappingContext.startMapping(aStructuralFeature);
            this.processPersistableMember(classElement, aStructuralFeature);
            this.mappingContext.endMapping(aStructuralFeature);
        }
        this.setNotPersistable(classElement, implClass, features);
    }

    protected void setNotPersistable(Element classElement, Class<?> implClass, List<PAnnotatedEStructuralFeature> features) {
        Field[] fields;
        Field[] fieldArray = fields = implClass.getFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if (!Modifier.isStatic(field.getModifiers()) && !field.getName().endsWith("ESet")) {
                boolean esfField = false;
                for (PAnnotatedEStructuralFeature asf : features) {
                    if (asf.getModelEStructuralFeature().getName().compareToIgnoreCase(field.getName()) != 0) continue;
                    esfField = true;
                    break;
                }
                if (!esfField) {
                    classElement.addElement("field").addAttribute("name", field.getName()).addAttribute("persistence-modifier", "none");
                }
            }
            ++n2;
        }
    }

    protected void processPersistableMember(Element eclassElement, PAnnotatedEStructuralFeature aStructuralFeature) {
        if (aStructuralFeature instanceof PAnnotatedEAttribute) {
            PAnnotatedEAttribute aAttribute = (PAnnotatedEAttribute)aStructuralFeature;
            if (aAttribute.getId() != null) {
                this.mappingContext.getIdMapper().map(aAttribute, eclassElement);
            } else if (aAttribute.getOneToMany() != null) {
                this.mappingContext.getManyBasicMapper().map(aAttribute, eclassElement);
            } else if (aAttribute.getBasic() != null) {
                this.mappingContext.getBasicMapper().map(aAttribute, eclassElement);
            } else if (aAttribute.getVersion() != null) {
                Element field = eclassElement.addElement("field");
                field.addAttribute("name", this.namingHandler.correctName(this.mappingContext, (EStructuralFeature)aStructuralFeature.getModelElement())).addAttribute("persistence-modifier", "none");
            }
        } else {
            PAnnotatedEReference aReference = (PAnnotatedEReference)aStructuralFeature;
            if (aReference.getManyToMany() != null) {
                this.mappingContext.getManyToManyMapper().map(eclassElement, aReference);
            } else if (aReference.getOneToMany() != null) {
                this.mappingContext.getOneToManyMapper().map(aReference, eclassElement);
            } else if (aReference.getOneToOne() != null) {
                this.mappingContext.getOneToOneMapper().map(aReference, eclassElement);
            } else if (aReference.getManyToOne() != null) {
                this.mappingContext.getManyToOneMapper().map(aReference, eclassElement);
            } else {
                throw new StoreMappingException("No otm, mtm, mto, oto for ereference " + aReference.getModelElement().getName());
            }
        }
    }

    public boolean hasJavaMember(Class implClass, EStructuralFeature efeature) {
        Field[] fields;
        String featureName = efeature.getName();
        Field[] fieldArray = fields = implClass.getDeclaredFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field element = fieldArray[n2];
            log.debug((Object)(String.valueOf(element.getName()) + "-" + efeature.getName()));
            if (element.getName().compareToIgnoreCase(featureName) == 0) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

