/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.type;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EStructuralFeature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistentStoreAdapter
implements Adapter {
    private static final long serialVersionUID = 1L;
    private Notifier target;
    private boolean targetCreatedByORM;
    private Map<EStructuralFeature, Object> storeCollections = new HashMap<EStructuralFeature, Object>();

    public void addStoreCollection(EStructuralFeature eFeature, Object storeCollection) {
        this.storeCollections.put(eFeature, storeCollection);
    }

    public Object getStoreCollection(EStructuralFeature eFeature) {
        return this.storeCollections.get(eFeature);
    }

    public Notifier getTarget() {
        return this.target;
    }

    public boolean isAdapterForType(Object type) {
        return false;
    }

    public void notifyChanged(Notification notification) {
        EStructuralFeature eFeature = (EStructuralFeature)notification.getFeature();
        Object collectionObject = this.storeCollections.get(eFeature);
        if (collectionObject == null) {
            return;
        }
        List list = collectionObject instanceof List ? (List)collectionObject : null;
        Map map = collectionObject instanceof Map ? (Map)collectionObject : null;
        switch (notification.getEventType()) {
            case 3: {
                if (list != null) {
                    if (notification.getPosition() != -1) {
                        list.add(notification.getPosition(), this.replaceValue(notification.getNewValue(), eFeature));
                    } else {
                        list.add(this.replaceValue(notification.getNewValue(), eFeature));
                    }
                }
                if (map == null) break;
                Map.Entry entry = (Map.Entry)notification.getNewValue();
                map.put(entry.getKey(), entry.getValue());
                break;
            }
            case 5: {
                if (list != null) {
                    if (notification.getPosition() != -1) {
                        list.addAll(notification.getPosition(), this.replaceValues((List)notification.getNewValue(), eFeature));
                    } else {
                        list.addAll(this.replaceValues((List)notification.getNewValue(), eFeature));
                    }
                }
                if (map == null) break;
                for (Object o : (List)notification.getNewValue()) {
                    Map.Entry entry = (Map.Entry)o;
                    map.put(entry.getKey(), entry.getValue());
                }
                break;
            }
            case 4: {
                if (list != null) {
                    if (notification.getPosition() != -1) {
                        list.remove(notification.getPosition());
                    } else {
                        list.remove(this.replaceValue(notification.getOldValue(), eFeature));
                    }
                }
                if (map == null) break;
                Map.Entry entry = (Map.Entry)notification.getNewValue();
                map.remove(entry.getKey());
                break;
            }
            case 6: {
                if (list != null) {
                    list.removeAll(this.replaceValues((List)notification.getOldValue(), eFeature));
                }
                if (map == null) break;
                for (Object o : (List)notification.getNewValue()) {
                    Map.Entry entry = (Map.Entry)o;
                    map.remove(entry.getKey());
                }
                break;
            }
            case 7: {
                if (list == null) break;
                int oldPosition = (Integer)notification.getOldValue();
                int newPosition = notification.getPosition();
                Object o = list.remove(oldPosition);
                if (o != notification.getNewValue()) {
                    throw new IllegalStateException("Persistent list and EList are out of sync");
                }
                list.add(newPosition, o);
                break;
            }
            case 1: {
                if (list == null) break;
                int position = notification.getPosition();
                list.set(position, this.replaceValue(notification.getNewValue(), eFeature));
            }
        }
    }

    public void setTarget(Notifier newTarget) {
        this.target = newTarget;
    }

    public boolean isTargetCreatedByORM() {
        return this.targetCreatedByORM;
    }

    public void setTargetCreatedByORM(boolean targetCreatedByORM) {
        this.targetCreatedByORM = targetCreatedByORM;
    }

    public Map<EStructuralFeature, Object> getStoreCollections() {
        return this.storeCollections;
    }

    protected Object replaceValue(Object value, EStructuralFeature eFeature) {
        return value;
    }

    protected List<Object> replaceValues(List<Object> values, EStructuralFeature eFeature) {
        return values;
    }
}

