/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.jpox.mapper.association;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEReference;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEStructuralFeature;
import org.eclipse.emf.teneo.annotations.pannotation.CascadeType;
import org.eclipse.emf.teneo.extension.ExtensionPoint;
import org.eclipse.emf.teneo.jpox.mapper.MappingUtil;
import org.eclipse.emf.teneo.jpox.mapper.association.AssociationMapper;
import org.eclipse.emf.teneo.jpox.mapping.AnyTypeEObject;
import org.eclipse.emf.teneo.mapping.strategy.EntityNameStrategy;
import org.eclipse.emf.teneo.simpledom.Element;

public class ManyToOneMapper
extends AssociationMapper
implements ExtensionPoint {
    protected static final Log log = LogFactory.getLog(ManyToOneMapper.class);

    public void map(PAnnotatedEReference aReference, Element eclassElement) {
        log.debug((Object)("Processing many to one ereference: " + aReference.getModelElement().getName()));
        EReference eReference = (EReference)aReference.getModelElement();
        EList cascade = aReference.getManyToOne().getCascade();
        boolean cascadeRemove = cascade.contains(CascadeType.ALL) || cascade.contains(CascadeType.REMOVE);
        log.debug((Object)("Cascaderemove " + cascadeRemove));
        Element field = eclassElement.addElement("field");
        field.addAttribute("name", this.namingHandler.correctName(this.mappingContext, (EStructuralFeature)eReference)).addAttribute("persistence-modifier", "persistent");
        this.setCommonReferenceAttributes(field, aReference, cascadeRemove);
        boolean setNullable = this.mappingContext.isForceOptional() || aReference.getManyToOne().isOptional() || eReference.getEOpposite() != null || cascadeRemove;
        field.addAttribute("null-value", setNullable ? "none" : "exception");
        if (aReference.getEmbedded() != null) {
            this.mappingContext.getEmbeddedMapper().map(aReference, field);
        } else {
            Element fk = field.addElement("foreign-key");
            this.setFKName((PAnnotatedEStructuralFeature)aReference, fk);
            if (aReference.getJoinColumns() != null && aReference.getJoinColumns().size() > 0) {
                this.mappingContext.getJoinColumnMapper().map((List)aReference.getJoinColumns(), field);
            }
        }
        String targetEntity = aReference.getManyToOne().getTargetEntity();
        String implName = null;
        implName = targetEntity.compareTo(EntityNameStrategy.EOBJECT_ECLASS_NAME) == 0 ? AnyTypeEObject.class.getName() : MappingUtil.getImplNameOfEClass(aReference.getManyToOne().getTargetEntity(), this.mappingContext);
        field.addElement("extension").addAttribute("vendor-name", "jpox").addAttribute("key", "implementation-classes").addAttribute("value", implName);
    }
}

