/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.eclipselink.examples.library.orm;

import org.eclipse.emf.teneo.eclipselink.examples.library.impl.BookImpl;
import org.eclipse.emf.teneo.eclipselink.examples.library.impl.PublisherImpl;
import org.eclipse.emf.teneo.eclipselink.examples.library.impl.TypeWriterImpl;
import org.eclipse.persistence.config.DescriptorCustomizer;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.indirection.IndirectList;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.ManyToManyMapping;
import org.eclipse.persistence.mappings.OneToManyMapping;

public class WriterCustomizer
implements DescriptorCustomizer {
    public void customize(ClassDescriptor descriptor) throws Exception {
        OneToManyMapping booksMapping = new OneToManyMapping();
        booksMapping.setAttributeName("books");
        booksMapping.setReferenceClass(BookImpl.class);
        booksMapping.setCascadeMerge(true);
        booksMapping.setCascadeRefresh(true);
        booksMapping.setCascadeRemove(false);
        booksMapping.setCascadePersist(true);
        booksMapping.useTransparentCollection();
        booksMapping.useCollectionClass(IndirectList.class);
        booksMapping.addTargetForeignKeyFieldName("EMFLIB_BOOK.AUTHOR_ID", "EMFLIB_WRITER.ID");
        descriptor.addMapping((DatabaseMapping)booksMapping);
        ManyToManyMapping publishersMapping = new ManyToManyMapping();
        publishersMapping.setIsReadOnly(true);
        publishersMapping.setAttributeName("publishers");
        publishersMapping.setReferenceClass(PublisherImpl.class);
        publishersMapping.useTransparentCollection();
        publishersMapping.useCollectionClass(IndirectList.class);
        publishersMapping.setRelationTableName("EMFLIB_WRITER_PUBLISHER");
        publishersMapping.addSourceRelationKeyFieldName("EMFLIB_WRITER_PUBLISHER.WRITER_ID", "EMFLIB_WRITER.ID");
        publishersMapping.addTargetRelationKeyFieldName("EMFLIB_WRITER_PUBLISHER.PUBLISHER_ID", "EMFLIB_PUBLISHER.ID");
        descriptor.addMapping((DatabaseMapping)publishersMapping);
        ManyToManyMapping typewritersMapping = new ManyToManyMapping();
        typewritersMapping.setAttributeName("typewriters");
        typewritersMapping.setReferenceClass(TypeWriterImpl.class);
        typewritersMapping.useTransparentCollection();
        typewritersMapping.useCollectionClass(IndirectList.class);
        typewritersMapping.setCascadeAll(true);
        typewritersMapping.setRelationTableName("EMFLIB_WRITER_TYPEWRITER");
        typewritersMapping.addSourceRelationKeyFieldName("EMFLIB_WRITER_TYPEWRITER.WRITER_ID", "EMFLIB_WRITER.ID");
        typewritersMapping.addTargetRelationKeyFieldName("EMFLIB_WRITER_TYPEWRITER.TYPEWRITER_ID", "EMFLIB_TYPEWRITER.ID");
        descriptor.addMapping((DatabaseMapping)typewritersMapping);
    }
}

