/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.mapping.elist;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.common.util.DelegatingEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.DelegatingEcoreEList;
import org.eclipse.emf.teneo.mapping.elist.PersistableDelegateList;
import org.eclipse.emf.teneo.util.StoreUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PersistableEList<E>
extends DelegatingEcoreEList<E>
implements PersistableDelegateList<E> {
    private static final long serialVersionUID = 1L;
    private static Log log = LogFactory.getLog(PersistableEList.class);
    protected List<E> delegate;
    private EStructuralFeature estructuralFeature;
    private String eFeaturePath = "";
    private boolean isLoaded = false;
    private boolean isLoading = false;
    protected final String logString;

    public PersistableEList(InternalEObject owner, EStructuralFeature feature, List<E> list) {
        super(owner);
        this.estructuralFeature = feature;
        if (list == null) {
            this.delegate = new ArrayList();
            this.isLoaded = true;
        } else if (list instanceof EList) {
            this.delegate = new ArrayList<E>(list);
            this.isLoaded = true;
        } else if (list instanceof ArrayList) {
            this.delegate = list;
            this.isLoaded = list.size() > 0;
        } else {
            this.delegate = list;
        }
        this.logString = "EList of type: " + this.getClass().getName() + " of member " + this.estructuralFeature.getName() + " owned by " + owner.getClass().getName() + " with delegate list " + this.delegate.getClass().getName();
        log.debug((Object)("Created persistable list " + this.logString));
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.eFeaturePath = StoreUtil.structuralFeatureToString(this.estructuralFeature);
        this.estructuralFeature = null;
        this.additionalWriteObject();
        out.defaultWriteObject();
    }

    protected void additionalWriteObject() {
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.estructuralFeature = StoreUtil.stringToStructureFeature(this.eFeaturePath);
    }

    public EStructuralFeature getEStructuralFeature() {
        return this.estructuralFeature;
    }

    public Object getFeature() {
        return this.estructuralFeature;
    }

    public boolean isUnique() {
        return this.estructuralFeature.isUnique();
    }

    public int getFeatureID() {
        return this.owner.eClass().getFeatureID(this.estructuralFeature);
    }

    @Override
    public List<E> getDelegate() {
        return this.delegate;
    }

    protected List<E> delegateList() {
        this.load();
        return this.delegate;
    }

    public void replaceDelegate(List<E> newDelegate) {
        this.delegate = newDelegate;
        this.isLoaded = false;
    }

    public String getLogString() {
        return this.logString;
    }

    protected void load() {
        if (this.isLoaded) {
            return;
        }
        if (this.isLoading) {
            return;
        }
        this.isLoading = true;
        log.debug((Object)("Loading " + this.getLogString()));
        boolean eDeliver = this.owner.eDeliver();
        boolean setDeliver = false;
        try {
            if (eDeliver) {
                log.debug((Object)("Owner " + this.owner.getClass() + " set eDeliver to false"));
                this.owner.eSetDeliver(false);
                setDeliver = true;
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {}
        try {
            this.doLoad();
        }
        finally {
            this.isLoaded = true;
            this.isLoading = false;
            if (setDeliver) {
                this.owner.eSetDeliver(eDeliver);
            }
        }
    }

    protected boolean isNotificationRequired() {
        if (!this.isLoaded() || this.isLoading()) {
            return false;
        }
        return super.isNotificationRequired();
    }

    @Override
    public boolean isLoaded() {
        return this.isLoaded;
    }

    public void setIsLoaded(boolean isLoaded) {
        this.isLoaded = isLoaded;
    }

    public void setIsLoading(boolean isLoading) {
        this.isLoading = isLoading;
    }

    public boolean isLoading() {
        return this.isLoading;
    }

    protected abstract void doLoad();

    public abstract boolean isPersistencyWrapped();

    protected void delegateAdd(int index, E object) {
        this.load();
        super.delegateAdd(index, object);
    }

    protected void delegateAdd(E object) {
        this.load();
        super.delegateAdd(object);
    }

    protected List<E> delegateBasicList() {
        this.load();
        return super.delegateBasicList();
    }

    protected void delegateClear() {
        this.load();
        super.delegateClear();
    }

    protected boolean delegateContains(Object object) {
        this.load();
        return super.delegateContains(object);
    }

    protected boolean delegateContainsAll(Collection<?> collection) {
        this.load();
        return super.delegateContainsAll(collection);
    }

    protected boolean delegateEquals(Object object) {
        this.load();
        return super.delegateEquals(object);
    }

    protected E delegateGet(int index) {
        this.load();
        return (E)super.delegateGet(index);
    }

    protected int delegateHashCode() {
        this.load();
        return super.delegateHashCode();
    }

    protected int delegateIndexOf(Object object) {
        this.load();
        return super.delegateIndexOf(object);
    }

    protected boolean delegateIsEmpty() {
        this.load();
        return super.delegateIsEmpty();
    }

    protected Iterator<E> delegateIterator() {
        this.load();
        return super.delegateIterator();
    }

    protected int delegateLastIndexOf(Object object) {
        this.load();
        return super.delegateLastIndexOf(object);
    }

    protected ListIterator<E> delegateListIterator() {
        return super.delegateListIterator();
    }

    protected E delegateRemove(int index) {
        this.load();
        return (E)super.delegateRemove(index);
    }

    protected E delegateSet(int index, E object) {
        this.load();
        return (E)super.delegateSet(index, object);
    }

    protected int delegateSize() {
        this.load();
        return super.delegateSize();
    }

    protected Object[] delegateToArray() {
        this.load();
        return super.delegateToArray();
    }

    protected <T> T[] delegateToArray(T[] array) {
        this.load();
        return super.delegateToArray((Object[])array);
    }

    protected String delegateToString() {
        this.load();
        return super.delegateToString();
    }

    public Iterator<E> basicIterator() {
        if (!this.isLoaded()) {
            return new DelegatingEList.NonResolvingEIterator<E>((DelegatingEList)this){

                public boolean hasNext() {
                    return false;
                }
            };
        }
        return super.basicIterator();
    }

    public ListIterator<E> basicListIterator() {
        if (!this.isLoaded()) {
            return new DelegatingEList.NonResolvingEListIterator<E>((DelegatingEList)this){

                public boolean hasNext() {
                    return false;
                }

                public boolean hasPrevious() {
                    return false;
                }
            };
        }
        return super.basicListIterator();
    }

    public ListIterator<E> basicListIterator(int index) {
        if (!this.isLoaded()) {
            return new DelegatingEList.NonResolvingEListIterator<E>((DelegatingEList)this){

                public boolean hasNext() {
                    return false;
                }

                public boolean hasPrevious() {
                    return false;
                }
            };
        }
        return super.basicListIterator(index);
    }

    public boolean equals(Object object) {
        return this == object;
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

