/*
 * Copyright (c) 2007-2009, 2011, 2012, 2019, 2022 Eike Stepper (Loehne, Germany) and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *    Eike Stepper - initial API and implementation
 */
package org.eclipse.emf.cdo.server;

import org.eclipse.net4j.util.container.IContainer;
import org.eclipse.net4j.util.security.IAuthenticator;

/**
 * Manages the user {@link ISession sessions} of a {@link IRepository repository}.
 *
 * @author Eike Stepper
 * @noextend This interface is not intended to be extended by clients.
 * @noimplement This interface is not intended to be implemented by clients.
 */
public interface ISessionManager extends IContainer<ISession>
{
  /**
   * @since 2.0
   */
  public IRepository getRepository();

  public ISession[] getSessions();

  /**
   * @since 2.0
   */
  public ISession getSession(int sessionID);

  /**
   * @since 4.2
   */
  public IAuthenticator getAuthenticator();

  /**
   * @since 4.2
   */
  public void setAuthenticator(IAuthenticator authenticator);

  /**
   * @since 4.17
   */
  public ITopicManager getTopicManager();
}
