/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.migrator;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.cdo.internal.migrator.CDOMigratorUtil;
import org.eclipse.emf.cdo.internal.migrator.messages.Messages;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.DiagnosticException;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.importer.ModelImporter;

public class CDOImporter
extends ModelImporter {
    public static final String IMPORTER_ID = "org.eclipse.emf.importer.cdo";

    public String getID() {
        return IMPORTER_ID;
    }

    protected Diagnostic doComputeEPackages(Monitor monitor) throws Exception {
        Diagnostic diagnostic = Diagnostic.OK_INSTANCE;
        List locationURIs = this.getModelLocationURIs();
        if (locationURIs.isEmpty()) {
            diagnostic = new BasicDiagnostic(4, "org.eclipse.emf.cdo.internal.migrator", 0, Messages.getString("CDOImporter_2"), null);
        } else {
            monitor.beginTask("", 2);
            monitor.subTask(MessageFormat.format(Messages.getString("CDOImporter_4"), locationURIs));
            ResourceSet ecoreResourceSet = this.createResourceSet();
            for (URI ecoreModelLocation : locationURIs) {
                ecoreResourceSet.getResource(ecoreModelLocation, true);
            }
            EcoreUtil.resolveAll((ResourceSet)ecoreResourceSet);
            for (Resource resource : ecoreResourceSet.getResources()) {
                this.getEPackages().addAll(EcoreUtil.getObjectsByType((Collection)resource.getContents(), (EClassifier)EcorePackage.Literals.EPACKAGE));
            }
            BasicDiagnostic diagnosticChain = new BasicDiagnostic("org.eclipse.emf.converter", 1, Messages.getString("CDOImporter_5"), null);
            for (EPackage ePackage : this.getEPackages()) {
                Diagnostician.INSTANCE.validate((EObject)ePackage, (DiagnosticChain)diagnosticChain);
            }
            if (diagnosticChain.getSeverity() != 0) {
                diagnostic = diagnosticChain;
            }
        }
        return diagnostic;
    }

    public void addToResource(EPackage ePackage, ResourceSet resourceSet) {
        if (ePackage.eResource() != null && this.getGenModel().eResource() != null) {
            URI ePackageURI = ePackage.eResource().getURI();
            URI genModelURI = this.getGenModel().eResource().getURI();
            if (!ePackageURI.trimSegments(1).equals(genModelURI.trimSegments(1))) {
                ePackage.eResource().getContents().remove((Object)ePackage);
            }
        }
        super.addToResource(ePackage, resourceSet);
    }

    protected void adjustGenModel(Monitor monitor) {
        super.adjustGenModel(monitor);
        GenModel genModel = this.getGenModel();
        URI genModelURI = this.createFileURI(this.getGenModelPath().toString());
        for (URI uri : this.getModelLocationURIs()) {
            genModel.getForeignModel().add((Object)this.makeRelative(uri, genModelURI).toString());
        }
        CDOMigratorUtil.adjustGenModel(genModel);
    }

    protected void handleOriginalGenModel() throws DiagnosticException {
        URI genModelURI = this.getOriginalGenModel().eResource().getURI();
        StringBuffer text = new StringBuffer();
        for (String value : this.getOriginalGenModel().getForeignModel()) {
            if (!value.endsWith(".ecore") && !value.endsWith(".emof")) continue;
            text.append(this.makeAbsolute(URI.createURI((String)value), genModelURI).toString());
            text.append(" ");
        }
        if (text.length() == 0) {
            UniqueEList locations = new UniqueEList();
            for (GenPackage genPackage : this.getOriginalGenModel().getGenPackages()) {
                URI ecoreURI = genPackage.getEcorePackage().eResource().getURI();
                if (!locations.add(ecoreURI)) continue;
                text.append(this.makeAbsolute(URI.createURI((String)ecoreURI.toString()), genModelURI).toString());
                text.append(" ");
            }
        }
        this.setModelLocation(text.toString().trim());
    }
}

