/*
 * Copyright (c) 2009, 2011-2013 Eike Stepper (Loehne, Germany) and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *    Eike Stepper - initial API and implementation
 *    Stefan Winkler - 271444: [DB] Multiple refactorings bug 271444
 */
package org.eclipse.emf.cdo.server.db;

import org.eclipse.net4j.db.IDBConnection;
import org.eclipse.net4j.db.IDBPreparedStatement;

import java.sql.Connection;
import java.sql.PreparedStatement;

/**
 * Caches JDBC {@link IDBPreparedStatement statements} according to given {@link ReuseProbability reuse probabilities}.
 *
 * @author Stefan Winkler
 * @since 2.0
 * @noextend This interface is not intended to be extended by clients.
 * @noimplement This interface is not intended to be implemented by clients.
 * @deprecated As of 4.2 use {@link IDBConnection}.
 */
@Deprecated
public interface IPreparedStatementCache
{
  @Deprecated
  public void setConnection(Connection connection);

  @Deprecated
  public PreparedStatement getPreparedStatement(String sql, ReuseProbability reuseProbability);

  @Deprecated
  public void releasePreparedStatement(PreparedStatement ps);

  /**
   * An enum for the degree of probability to which a prepared statement is reused later on. This is used for managing
   * the cache of prepared statements so that statements which are more likely reused are kept in the cache longer. Rule
   * of thumb:
   * <ul>
   * <li>For global statements which are used regularly (such as lookup object in cdo_objects) use
   * {@link ReuseProbability#MAX MAX}.
   * <li>For constant object-specific statements which are used regularly use {@link ReuseProbability#HIGH HIGH}.
   * <li>For object-specific statements which are assembled from constants which are used regularly use
   * {@link ReuseProbability#MEDIUM MEDIUM}.
   * <li>For all other dynamic statements, like queries, use {@link ReuseProbability#LOW LOW}
   * </ul>
   *
   * @author Stefan Winkler
   * @since 2.0
   * @noextend This interface is not intended to be extended by clients.
   */
  @Deprecated
  public static enum ReuseProbability
  {
    @Deprecated
    MAX,

    @Deprecated
    HIGH,

    @Deprecated
    MEDIUM,

    @Deprecated
    LOW;
  }
}
