/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.spi.cdo;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.CDOState;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.commit.CDOChangeSetData;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionProvider;
import org.eclipse.emf.cdo.common.revision.CDORevisionUtil;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDORevisionDelta;
import org.eclipse.emf.cdo.common.util.CDOException;
import org.eclipse.emf.cdo.spi.common.revision.CDORevisionMerger;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionDelta;
import org.eclipse.emf.cdo.transaction.CDOCommitContext;
import org.eclipse.emf.cdo.transaction.CDOConflictResolver2;
import org.eclipse.emf.cdo.transaction.CDODefaultTransactionHandler;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.transaction.CDOTransactionHandler;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.cdo.view.CDOAdapterPolicy;
import org.eclipse.emf.cdo.view.CDOViewInvalidationEvent;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.internal.cdo.bundle.OM;
import org.eclipse.emf.internal.cdo.messages.Messages;
import org.eclipse.emf.internal.cdo.view.CDOStateMachine;
import org.eclipse.emf.spi.cdo.AbstractConflictResolver;
import org.eclipse.emf.spi.cdo.CDOChangeSubscriptionAdapter;
import org.eclipse.emf.spi.cdo.InternalCDOObject;
import org.eclipse.emf.spi.cdo.InternalCDOTransaction;
import org.eclipse.net4j.util.collection.Pair;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;

public abstract class AbstractObjectConflictResolver
extends AbstractConflictResolver
implements CDOConflictResolver2 {
    @Override
    public void resolveConflicts(Set<CDOObject> conflicts) {
        Map<CDOID, CDORevisionDelta> localDeltas = this.getTransaction().getRevisionDeltas();
        for (CDOObject conflict : conflicts) {
            CDORevisionDelta localDelta = localDeltas.get(conflict.cdoID());
            this.resolveConflict(conflict, localDelta);
        }
    }

    protected void resolveConflict(CDOObject conflict, CDORevisionDelta localDelta) {
    }

    @Override
    public void resolveConflicts(Map<CDOObject, Pair<CDORevision, CDORevisionDelta>> conflicts, List<CDORevisionDelta> allRemoteDeltas) {
        Map<CDOID, CDORevisionDelta> localDeltas = this.getTransaction().getRevisionDeltas();
        for (Map.Entry<CDOObject, Pair<CDORevision, CDORevisionDelta>> entry : conflicts.entrySet()) {
            CDOObject conflict = entry.getKey();
            CDORevision oldRevision = (CDORevision)entry.getValue().getElement1();
            CDORevisionDelta remoteDelta = (CDORevisionDelta)entry.getValue().getElement2();
            CDORevisionDelta localDelta = localDeltas.get(conflict.cdoID());
            try {
                this.resolveConflict(conflict, oldRevision, localDelta, remoteDelta, allRemoteDeltas);
            }
            catch (Exception ex) {
                OM.LOG.error((Throwable)ex);
            }
        }
    }

    protected void resolveConflict(CDOObject conflict, CDORevision oldRemoteRevision, CDORevisionDelta localDelta, CDORevisionDelta remoteDelta, List<CDORevisionDelta> allRemoteDeltas) {
        throw new UnsupportedOperationException("Must be overridden");
    }

    @Deprecated
    public static void rollbackObject(CDOObject object) {
        CDOStateMachine.INSTANCE.rollback((InternalCDOObject)object, (InternalCDOTransaction)object.cdoView());
    }

    public static void readObject(CDOObject object) {
        CDOStateMachine.INSTANCE.read((InternalCDOObject)object);
    }

    public static void changeObject(CDOObject object, CDORevisionDelta revisionDelta) {
        AbstractObjectConflictResolver.readObject(object);
        InternalCDORevision revision = (InternalCDORevision)object.cdoRevision().copy();
        ((InternalCDORevisionDelta)revisionDelta).setVersion(revision.getVersion());
        CDORevisionMerger merger = new CDORevisionMerger();
        merger.merge(revision, revisionDelta);
        ((InternalCDOObject)object).cdoInternalSetRevision((CDORevision)revision);
        ((InternalCDOObject)object).cdoInternalSetState(CDOState.DIRTY);
        ((InternalCDOObject)object).cdoInternalPostLoad();
    }

    @Deprecated
    public static class MergeLocalChangesPerFeature
    extends ThreeWayMerge {
        @Deprecated
        public MergeLocalChangesPerFeature() {
        }

        @Override
        @Deprecated
        protected void resolveConflict(CDOObject conflict, CDORevisionDelta localDelta, List<CDORevisionDelta> remoteDeltas) {
            if (this.hasFeatureConflicts(localDelta, remoteDeltas)) {
                throw new CDOException(Messages.getString("AbstractObjectConflictResolver.0"));
            }
            MergeLocalChangesPerFeature.rollbackObject(conflict);
            for (CDORevisionDelta remoteDelta : remoteDeltas) {
                for (CDOFeatureDelta remoteFeatureDelta : remoteDelta.getFeatureDeltas()) {
                    ((InternalCDORevisionDelta)localDelta).addFeatureDelta(remoteFeatureDelta, null);
                }
            }
            MergeLocalChangesPerFeature.changeObject(conflict, localDelta);
        }

        @Deprecated
        protected boolean hasFeatureConflicts(CDORevisionDelta localDelta, List<CDORevisionDelta> remoteDeltas) {
            HashSet<EStructuralFeature> features = new HashSet<EStructuralFeature>();
            for (CDOFeatureDelta localFeatureDelta : localDelta.getFeatureDeltas()) {
                features.add(localFeatureDelta.getFeature());
            }
            for (CDORevisionDelta remoteDelta : remoteDeltas) {
                for (CDOFeatureDelta remoteFeatureDelta : remoteDelta.getFeatureDeltas()) {
                    EStructuralFeature feature = remoteFeatureDelta.getFeature();
                    if (!features.contains(feature)) continue;
                    return true;
                }
            }
            return false;
        }
    }

    @Deprecated
    public static class TakeRemoteChangesThenApplyLocalChanges
    extends AbstractObjectConflictResolver {
        @Deprecated
        public TakeRemoteChangesThenApplyLocalChanges() {
        }

        @Override
        @Deprecated
        public void resolveConflicts(Map<CDOObject, Pair<CDORevision, CDORevisionDelta>> conflicts, List<CDORevisionDelta> allRemoteDeltas) {
            CDOChangeSetData remoteChangeSet = this.createChangeSet(allRemoteDeltas);
            InternalCDOTransaction transaction = (InternalCDOTransaction)this.getTransaction();
            CDOChangeSetData localChangeSet = transaction.getChangeSetData();
            transaction.rollback();
            transaction.applyChangeSet(remoteChangeSet, (CDORevisionProvider)transaction, (CDORevisionProvider)transaction, (CDOBranchPoint)transaction, false);
            transaction.applyChangeSet(localChangeSet, (CDORevisionProvider)transaction, (CDORevisionProvider)transaction, (CDOBranchPoint)transaction, false);
        }

        private CDOChangeSetData createChangeSet(List<CDORevisionDelta> revisionDeltas) {
            List newObjects = Collections.emptyList();
            ArrayList<CDORevisionDelta> changedObjects = new ArrayList<CDORevisionDelta>();
            List detachedObjects = Collections.emptyList();
            for (CDORevisionDelta delta : revisionDeltas) {
                changedObjects.add(delta);
            }
            CDOChangeSetData remoteChangeSet = CDORevisionUtil.createChangeSetData(newObjects, changedObjects, detachedObjects);
            return remoteChangeSet;
        }
    }

    public static abstract class ThreeWayMerge
    extends AbstractObjectConflictResolver
    implements CDOAdapterPolicy {
        private CDOTransactionHandler handler = new CDODefaultTransactionHandler(){

            @Override
            public void modifyingObject(CDOTransaction transaction, CDOObject object, CDOFeatureDelta ignored) {
                if (this.getTransaction() == transaction) {
                    adapter.attach(object);
                }
            }

            @Override
            public void committedTransaction(CDOTransaction transaction, CDOCommitContext commitContext) {
                if (this.getTransaction() == transaction) {
                    adapter.reset();
                    collector.reset();
                }
            }

            @Override
            public void rolledBackTransaction(CDOTransaction transaction) {
                if (this.getTransaction() == transaction && transaction.getLastSavepoint().getPreviousSavepoint() == null) {
                    adapter.reset();
                    collector.reset();
                }
            }
        };
        private CDOChangeSubscriptionAdapter adapter;
        private RevisionDeltaCollector collector = new RevisionDeltaCollector();

        @Override
        public boolean isValid(EObject object, Adapter adapter) {
            return adapter instanceof CDOChangeSubscriptionAdapter;
        }

        @Override
        protected void hookTransaction(CDOTransaction transaction) {
            transaction.addTransactionHandler(this.handler);
            this.adapter = new CDOChangeSubscriptionAdapter(this.getTransaction());
            transaction.addListener(this.collector);
        }

        @Override
        protected void unhookTransaction(CDOTransaction transaction) {
            transaction.removeListener(this.collector);
            this.adapter.dispose();
            this.adapter = null;
            transaction.removeTransactionHandler(this.handler);
        }

        @Override
        public void resolveConflicts(Set<CDOObject> conflicts) {
        }

        @Override
        protected void resolveConflict(CDOObject conflict, CDORevision oldRemoteRevision, CDORevisionDelta localDelta, CDORevisionDelta remoteDelta, List<CDORevisionDelta> allRemoteDeltas) {
            this.resolveConflict(conflict, localDelta, this.collector.getDeltas(conflict));
        }

        protected abstract void resolveConflict(CDOObject var1, CDORevisionDelta var2, List<CDORevisionDelta> var3);

        public static class RevisionDeltaCollector
        implements IListener {
            private Map<CDOObject, List<CDORevisionDelta>> deltas = new HashMap<CDOObject, List<CDORevisionDelta>>();

            public List<CDORevisionDelta> getDeltas(CDOObject notifier) {
                List<CDORevisionDelta> list = this.deltas.get(CDOUtil.getEObject(notifier));
                if (list == null) {
                    return Collections.emptyList();
                }
                return list;
            }

            public void reset() {
                this.deltas.clear();
            }

            public void notifyEvent(IEvent event) {
                try {
                    if (event instanceof CDOViewInvalidationEvent) {
                        CDOViewInvalidationEvent e = (CDOViewInvalidationEvent)event;
                        for (Map.Entry<CDOObject, CDORevisionDelta> entry : e.getRevisionDeltas().entrySet()) {
                            CDOObject notifier = entry.getKey();
                            List<CDORevisionDelta> list = this.deltas.get(notifier);
                            if (list == null) {
                                list = new ArrayList<CDORevisionDelta>();
                                this.deltas.put(notifier, list);
                            }
                            CDORevisionDelta delta = entry.getValue();
                            list.add(delta);
                        }
                    }
                }
                catch (Exception ex) {
                    OM.LOG.error((Throwable)ex);
                }
            }
        }
    }
}

