/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.apache.derby.impl.jdbc.UTF8Reader;

public final class ReaderToAscii
extends InputStream {
    private final Reader data;
    private char[] conv;
    private boolean closed;

    public ReaderToAscii(Reader data) {
        this.data = data;
        if (!(data instanceof UTF8Reader)) {
            this.conv = new char[256];
        }
    }

    @Override
    public int read() throws IOException {
        if (this.closed) {
            throw new IOException();
        }
        int c = this.data.read();
        if (c == -1) {
            return -1;
        }
        if (c <= 255) {
            return c & 0xFF;
        }
        return 63;
    }

    @Override
    public int read(byte[] buf, int off, int len) throws IOException {
        if (this.closed) {
            throw new IOException();
        }
        if (this.data instanceof UTF8Reader) {
            return ((UTF8Reader)this.data).readAsciiInto(buf, off, len);
        }
        if (len > this.conv.length) {
            len = this.conv.length;
        }
        if ((len = this.data.read(this.conv, 0, len)) == -1) {
            return -1;
        }
        for (int i = 0; i < len; ++i) {
            char c = this.conv[i];
            int cb = c <= '\u00ff' ? (int)((byte)c) : 63;
            buf[off++] = cb;
        }
        return len;
    }

    @Override
    public long skip(long len) throws IOException {
        if (this.closed) {
            throw new IOException();
        }
        return this.data.skip(len);
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            this.data.close();
        }
    }
}

