/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.util;

import org.apache.derby.iapi.services.context.Context;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.shared.common.error.ShutdownException;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

public class InterruptStatus {
    public static final int MAX_INTERRUPT_RETRIES = 120;
    public static final int INTERRUPT_RETRY_SLEEP = 500;
    private static final ThreadLocal<Exception> exception = new ThreadLocal();

    public static void setInterrupted() {
        LanguageConnectionContext lcc = null;
        try {
            lcc = (LanguageConnectionContext)InterruptStatus.getContextOrNull("LanguageConnectionContext");
        }
        catch (ShutdownException shutdownException) {
            // empty catch block
        }
        Thread.interrupted();
        StandardException e = StandardException.newException("08000", new Object[0]);
        if (lcc != null) {
            lcc.setInterruptedException(e);
        } else {
            exception.set(e);
        }
    }

    public static void saveInfoFromLcc(LanguageConnectionContext lcc) {
        StandardException e = lcc.getInterruptedException();
        if (e != null) {
            exception.set(e);
        }
    }

    public static boolean noteAndClearInterrupt(String s, int threadsInPageIO, int hashCode) {
        if (Thread.currentThread().isInterrupted()) {
            InterruptStatus.setInterrupted();
            if (SanityManager.DEBUG_ON("DebugInterruptRecovery")) {
                SanityManager.DEBUG_PRINT("DebugInterruptRecovery", Thread.currentThread().getName() + " " + Integer.toHexString(hashCode) + "@Interrupted: " + s + " threadsInPageIO: " + threadsInPageIO + "\n");
            }
            Thread.interrupted();
            return true;
        }
        return false;
    }

    public static void restoreIntrFlagIfSeen() {
        LanguageConnectionContext lcc = null;
        try {
            lcc = (LanguageConnectionContext)InterruptStatus.getContextOrNull("LanguageConnectionContext");
        }
        catch (ShutdownException shutdownException) {
            // empty catch block
        }
        if (lcc == null) {
            if (exception.get() != null) {
                exception.set(null);
                Thread.currentThread().interrupt();
            }
        } else if (lcc.getInterruptedException() != null) {
            lcc.setInterruptedException(null);
            Thread.currentThread().interrupt();
        }
    }

    public static void restoreIntrFlagIfSeen(LanguageConnectionContext lcc) {
        LanguageConnectionContext ctxLcc = null;
        try {
            ctxLcc = (LanguageConnectionContext)InterruptStatus.getContextOrNull("LanguageConnectionContext");
            SanityManager.ASSERT(lcc == ctxLcc, "lcc=" + lcc + " getContextOrNull=" + ctxLcc);
        }
        catch (ShutdownException shutdownException) {
            // empty catch block
        }
        if (lcc.getInterruptedException() != null) {
            lcc.setInterruptedException(null);
            Thread.currentThread().interrupt();
        }
    }

    public static void throwIf(LanguageConnectionContext lcc) throws StandardException {
        StandardException e;
        if (Thread.currentThread().isInterrupted()) {
            InterruptStatus.setInterrupted();
        }
        if ((e = lcc.getInterruptedException()) != null) {
            lcc.setInterruptedException(null);
            throw e;
        }
    }

    private static Context getContextOrNull(String contextID) {
        return ContextService.getContextOrNull(contextID);
    }
}

