/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.workspace;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.internal.workspace.AbstractCDOWorkspaceBase;
import org.eclipse.emf.cdo.server.IStoreAccessor;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.workspace.InternalCDOWorkspace;
import org.eclipse.emf.cdo.workspace.CDOWorkspaceBase;
import org.eclipse.emf.cdo.workspace.CDOWorkspaceUtil;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.net4j.util.factory.ProductCreationException;
import org.eclipse.net4j.util.io.ExtendedDataInputStream;
import org.eclipse.net4j.util.io.ExtendedDataOutputStream;
import org.eclipse.net4j.util.io.IOUtil;
import org.eclipse.net4j.util.om.monitor.Monitor;
import org.eclipse.net4j.util.om.monitor.OMMonitor;

public class FolderCDOWorkspaceBase
extends AbstractCDOWorkspaceBase {
    private final File folder;
    private final File addedAndDetachedFile;

    public FolderCDOWorkspaceBase(File folder) {
        this.folder = folder.getAbsoluteFile();
        this.addedAndDetachedFile = new File(folder, "_addedAndDetached.log");
    }

    @Override
    public void init(InternalCDOWorkspace workspace) {
        super.init(workspace);
        this.createFolder();
    }

    public final File getFolder() {
        return this.folder;
    }

    public final synchronized InternalCDORevision getRevision(CDOID id) {
        File file = this.getFile(id);
        return this.readRevision(file);
    }

    @Override
    public boolean isAddedObject(CDOID id) {
        File file = this.getFile(id);
        if (!file.exists()) {
            return false;
        }
        return file.length() == 0L;
    }

    @Override
    public void deleteAddedAndDetachedObjects(final IStoreAccessor.Raw accessor, final CDOBranch branch) {
        this.handleAddedAndDetachedObjects(new AddedAndDetachedHandler(){

            @Override
            public void handleAddedAndDetachedHandler(CDOID id, int detachedVersion) {
                int v = 1;
                while (v <= detachedVersion) {
                    accessor.rawDelete(id, v, branch, null, (OMMonitor)new Monitor());
                    ++v;
                }
            }
        });
    }

    public String toString() {
        return "FolderBase[" + this.folder + "]";
    }

    @Override
    protected void doClear() {
        IOUtil.delete((File)this.folder);
        this.checkExists(this.folder, false);
        this.createFolder();
    }

    @Override
    protected Set<CDOID> doGetIDs() {
        return this.doGetIDs(this.folder);
    }

    @Override
    protected void doRegisterChangedOrDetachedObject(InternalCDORevision revision) {
        File file = this.getFile(revision.getID());
        if (file.exists()) {
            return;
        }
        this.writeRevision(revision, file);
    }

    @Override
    protected void doRegisterAddedAndDetachedObject(InternalCDORevision revision) {
        CDOID id = revision.getID();
        int detachedVersion = revision.getVersion();
        String key = this.getKey(id);
        FileWriter writer = null;
        try {
            try {
                writer = new FileWriter(this.addedAndDetachedFile, true);
                writer.write(key);
                writer.write("\t");
                writer.write(Integer.toString(detachedVersion));
                writer.write("\n");
            }
            catch (IOException ex) {
                throw new IllegalStateException("Could not write to " + this.addedAndDetachedFile, ex);
            }
        }
        catch (Throwable throwable) {
            IOUtil.close(writer);
            throw throwable;
        }
        IOUtil.close((Closeable)writer);
    }

    @Override
    protected void doRegisterAddedObject(CDOID id) {
        File file = this.getFile(id);
        if (file.exists()) {
            return;
        }
        FileOutputStream fos = null;
        try {
            try {
                fos = new FileOutputStream(file);
            }
            catch (IOException ex) {
                throw new IllegalStateException("Could not write to " + file, ex);
            }
        }
        catch (Throwable throwable) {
            IOUtil.close(fos);
            throw throwable;
        }
        IOUtil.close((Closeable)fos);
    }

    @Override
    protected void doDeregisterObject(CDOID id) {
        File file = this.getFile(id);
        file.delete();
        this.checkExists(file, false);
    }

    protected final void handleAddedAndDetachedObjects(AddedAndDetachedHandler handler) {
        if (!this.addedAndDetachedFile.exists()) {
            return;
        }
        FileReader fileReader = null;
        try {
            try {
                String line;
                fileReader = new FileReader(this.addedAndDetachedFile);
                BufferedReader lineReader = new BufferedReader(fileReader);
                while ((line = lineReader.readLine()) != null) {
                    String[] tokens = line.split("\t");
                    CDOID id = CDOIDUtil.read((String)tokens[0]);
                    int detachedVersion = Integer.parseInt(tokens[1]);
                    handler.handleAddedAndDetachedHandler(id, detachedVersion);
                }
            }
            catch (IOException ex) {
                throw new IllegalStateException("Could not read from " + this.addedAndDetachedFile, ex);
            }
        }
        catch (Throwable throwable) {
            IOUtil.close(fileReader);
            throw throwable;
        }
        IOUtil.close((Closeable)fileReader);
    }

    protected CDOID getCDOID(String filename) {
        return CDOIDUtil.read((String)filename);
    }

    protected String getKey(CDOID id) {
        StringBuilder builder = new StringBuilder();
        CDOIDUtil.write((StringBuilder)builder, (CDOID)id);
        return builder.toString();
    }

    protected File getFile(CDOID id) {
        String key = this.getKey(id);
        return new File(this.folder, key);
    }

    private void createFolder() {
        IOUtil.mkdirs((File)this.folder);
        this.checkExists(this.folder, true);
    }

    private void checkExists(File file, boolean exists) {
        if (exists) {
            if (!file.exists()) {
                throw new IllegalStateException("File does not exist: " + file);
            }
        } else if (file.exists()) {
            throw new IllegalStateException("File does still exist: " + file);
        }
    }

    private void writeRevision(InternalCDORevision revision, File file) {
        FileOutputStream fos = null;
        try {
            try {
                fos = new FileOutputStream(file);
                ExtendedDataOutputStream edos = new ExtendedDataOutputStream((OutputStream)fos);
                CDODataOutput out = this.createCDODataOutput(edos);
                out.writeCDORevision((CDORevision)revision, -1);
                edos.flush();
            }
            catch (IOException ex) {
                throw new IllegalStateException("Could not write to " + file, ex);
            }
        }
        catch (Throwable throwable) {
            IOUtil.close(fos);
            throw throwable;
        }
        IOUtil.close((Closeable)fos);
    }

    private InternalCDORevision readRevision(File file) {
        InternalCDORevision internalCDORevision;
        if (!file.exists() || file.length() == 0L) {
            return null;
        }
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            ExtendedDataInputStream edis = new ExtendedDataInputStream((InputStream)fis);
            CDODataInput in = this.createCDODataInput(edis);
            internalCDORevision = (InternalCDORevision)in.readCDORevision();
        }
        catch (IOException ex) {
            try {
                throw new IllegalStateException("Could not read from " + file, ex);
            }
            catch (Throwable throwable) {
                IOUtil.close(fis);
                throw throwable;
            }
        }
        IOUtil.close((Closeable)fis);
        return internalCDORevision;
    }

    private Set<CDOID> doGetIDs(File folder) {
        File[] files;
        HashSet<CDOID> ids = new HashSet<CDOID>();
        if (folder.isDirectory() && (files = folder.listFiles()) != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (!ObjectUtil.equals((Object)file, (Object)this.addedAndDetachedFile)) {
                    CDOID id = this.getCDOID(file.getName());
                    ids.add(id);
                }
                ++n2;
            }
        }
        return ids;
    }

    public static interface AddedAndDetachedHandler {
        public void handleAddedAndDetachedHandler(CDOID var1, int var2);
    }

    public static final class Factory
    extends org.eclipse.net4j.util.factory.Factory {
        public static final String TYPE = "folder";

        public Factory() {
            super("org.eclipse.emf.cdo.workspace.bases", TYPE);
        }

        public Factory(String productGroup, String type) {
            super(productGroup, type);
        }

        public CDOWorkspaceBase create(String description) throws ProductCreationException {
            return CDOWorkspaceUtil.createFolderWorkspaceBase(new File(description));
        }
    }
}

