/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.lm.impl;

import java.util.Collection;
import org.eclipse.emf.cdo.common.branch.CDOBranchPointRef;
import org.eclipse.emf.cdo.common.branch.CDOBranchRef;
import org.eclipse.emf.cdo.etypes.EtypesFactory;
import org.eclipse.emf.cdo.etypes.EtypesPackage;
import org.eclipse.emf.cdo.lm.BasePoint;
import org.eclipse.emf.cdo.lm.Change;
import org.eclipse.emf.cdo.lm.Delivery;
import org.eclipse.emf.cdo.lm.Drop;
import org.eclipse.emf.cdo.lm.FixedBaseline;
import org.eclipse.emf.cdo.lm.Impact;
import org.eclipse.emf.cdo.lm.LMPackage;
import org.eclipse.emf.cdo.lm.Stream;
import org.eclipse.emf.cdo.lm.impl.FloatingBaselineImpl;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.InternalEList;

public class ChangeImpl
extends FloatingBaselineImpl
implements Change {
    protected static final String LABEL_EDEFAULT = null;
    protected static final Impact IMPACT_EDEFAULT = Impact.MICRO;
    protected static final CDOBranchRef BRANCH_EDEFAULT = (CDOBranchRef)EtypesFactory.eINSTANCE.createFromString(EtypesPackage.eINSTANCE.getBranchRef(), "");

    protected ChangeImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return LMPackage.Literals.CHANGE;
    }

    @Override
    public FixedBaseline getBase() {
        return (FixedBaseline)this.eDynamicGet(4, (EStructuralFeature)LMPackage.Literals.CHANGE__BASE, true, true);
    }

    public FixedBaseline basicGetBase() {
        return (FixedBaseline)this.eDynamicGet(4, (EStructuralFeature)LMPackage.Literals.CHANGE__BASE, false, true);
    }

    @Override
    public void setBase(FixedBaseline newBase) {
        this.eDynamicSet(4, (EStructuralFeature)LMPackage.Literals.CHANGE__BASE, newBase);
    }

    @Override
    public String getLabel() {
        return (String)this.eDynamicGet(5, (EStructuralFeature)LMPackage.Literals.CHANGE__LABEL, true, true);
    }

    @Override
    public void setLabel(String newLabel) {
        this.eDynamicSet(5, (EStructuralFeature)LMPackage.Literals.CHANGE__LABEL, newLabel);
    }

    @Override
    public Impact getImpact() {
        return (Impact)((Object)this.eDynamicGet(6, (EStructuralFeature)LMPackage.Literals.CHANGE__IMPACT, true, true));
    }

    @Override
    public void setImpact(Impact newImpact) {
        this.eDynamicSet(6, (EStructuralFeature)LMPackage.Literals.CHANGE__IMPACT, (Object)newImpact);
    }

    @Override
    public CDOBranchRef getBranch() {
        return (CDOBranchRef)this.eDynamicGet(7, (EStructuralFeature)LMPackage.Literals.CHANGE__BRANCH, true, true);
    }

    @Override
    public void setBranch(CDOBranchRef newBranch) {
        this.eDynamicSet(7, (EStructuralFeature)LMPackage.Literals.CHANGE__BRANCH, newBranch);
    }

    @Override
    public EList<Delivery> getDeliveries() {
        return (EList)this.eDynamicGet(8, (EStructuralFeature)LMPackage.Literals.CHANGE__DELIVERIES, true, true);
    }

    @Override
    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 8: {
                return ((InternalEList)this.getDeliveries()).basicAdd((Object)otherEnd, msgs);
            }
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    @Override
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 8: {
                return ((InternalEList)this.getDeliveries()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 4: {
                if (resolve) {
                    return this.getBase();
                }
                return this.basicGetBase();
            }
            case 5: {
                return this.getLabel();
            }
            case 6: {
                return this.getImpact();
            }
            case 7: {
                return this.getBranch();
            }
            case 8: {
                return this.getDeliveries();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 4: {
                this.setBase((FixedBaseline)newValue);
                return;
            }
            case 5: {
                this.setLabel((String)newValue);
                return;
            }
            case 6: {
                this.setImpact((Impact)((Object)newValue));
                return;
            }
            case 7: {
                this.setBranch((CDOBranchRef)newValue);
                return;
            }
            case 8: {
                this.getDeliveries().clear();
                this.getDeliveries().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 4: {
                this.setBase(null);
                return;
            }
            case 5: {
                this.setLabel(LABEL_EDEFAULT);
                return;
            }
            case 6: {
                this.setImpact(IMPACT_EDEFAULT);
                return;
            }
            case 7: {
                this.setBranch(BRANCH_EDEFAULT);
                return;
            }
            case 8: {
                this.getDeliveries().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 4: {
                return this.basicGetBase() != null;
            }
            case 5: {
                return LABEL_EDEFAULT == null ? this.getLabel() != null : !LABEL_EDEFAULT.equals(this.getLabel());
            }
            case 6: {
                return this.getImpact() != IMPACT_EDEFAULT;
            }
            case 7: {
                return BRANCH_EDEFAULT == null ? this.getBranch() != null : !BRANCH_EDEFAULT.equals((Object)this.getBranch());
            }
            case 8: {
                return !this.getDeliveries().isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public String getName() {
        return this.getLabel();
    }

    @Override
    public long getBaseTimeStamp() {
        FixedBaseline base = this.getBase();
        if (base == null) {
            return 0L;
        }
        CDOBranchPointRef branchPoint = base.getBranchPoint();
        if (branchPoint == null) {
            return 0L;
        }
        return branchPoint.getTimeStamp();
    }

    @Override
    public EList<Stream> getDeliveryStreams() {
        BasicEList result = new BasicEList();
        for (Delivery delivery : this.getDeliveries()) {
            result.add((Object)delivery.getStream());
        }
        return result;
    }

    @Override
    public Delivery getDelivery(Stream stream) {
        for (Delivery delivery : this.getDeliveries()) {
            Stream deliveryStream = delivery.getStream();
            if (deliveryStream != stream) continue;
            return delivery;
        }
        return null;
    }

    @Override
    public BasePoint getDeliveryPoint(Stream stream) {
        long baseReleaseTime = Long.MAX_VALUE;
        while (true) {
            Delivery delivery;
            if ((delivery = this.getDelivery(stream)) != null) {
                long deliveryTime = delivery.getBaseTimeStamp();
                if (deliveryTime > baseReleaseTime) {
                    return null;
                }
                return new BasePoint(stream, deliveryTime);
            }
            Drop baseRelease = stream.getBase();
            if (baseRelease == null) {
                return null;
            }
            stream = baseRelease.getStream();
            baseReleaseTime = baseRelease.getBaseTimeStamp();
        }
    }

    @Override
    public EList<Stream> getDeliveryCandidateStreams() {
        BasicEList result = new BasicEList();
        for (Stream stream : this.getModule().getStreams()) {
            if (this.getDelivery(stream) != null) continue;
            result.add((Object)stream);
        }
        return result;
    }

    @Override
    public boolean isDeliverable() {
        EList<Stream> candidates = this.getDeliveryCandidateStreams();
        return !candidates.isEmpty();
    }
}

