/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.derby.iapi.jdbc.BrokeredCallableStatement;
import org.apache.derby.iapi.jdbc.BrokeredConnection;
import org.apache.derby.iapi.jdbc.BrokeredPreparedStatement;
import org.apache.derby.iapi.jdbc.BrokeredStatement;
import org.apache.derby.iapi.jdbc.BrokeredStatementControl;
import org.apache.derby.impl.jdbc.EmbedConnection;
import org.apache.derby.impl.jdbc.EmbedPreparedStatement;
import org.apache.derby.impl.jdbc.EmbedResultSet;
import org.apache.derby.impl.jdbc.EmbedStatement;
import org.apache.derby.impl.jdbc.EmbedXAConnection;

final class XAStatementControl
implements BrokeredStatementControl {
    private final EmbedXAConnection xaConnection;
    private final BrokeredConnection applicationConnection;
    BrokeredStatement applicationStatement;
    private EmbedConnection realConnection;
    private Statement realStatement;
    private PreparedStatement realPreparedStatement;
    private CallableStatement realCallableStatement;

    private XAStatementControl(EmbedXAConnection xaConnection) {
        this.xaConnection = xaConnection;
        this.realConnection = xaConnection.realConnection;
        this.applicationConnection = xaConnection.currentConnectionHandle;
    }

    XAStatementControl(EmbedXAConnection xaConnection, Statement realStatement) throws SQLException {
        this(xaConnection);
        this.realStatement = realStatement;
        this.applicationStatement = this.applicationConnection.newBrokeredStatement(this);
        ((EmbedStatement)realStatement).setApplicationStatement(this.applicationStatement);
    }

    XAStatementControl(EmbedXAConnection xaConnection, PreparedStatement realPreparedStatement, String sql, Object generatedKeys) throws SQLException {
        this(xaConnection);
        this.realPreparedStatement = realPreparedStatement;
        this.applicationStatement = this.applicationConnection.newBrokeredStatement(this, sql, generatedKeys);
        ((EmbedStatement)((Object)realPreparedStatement)).setApplicationStatement(this.applicationStatement);
    }

    XAStatementControl(EmbedXAConnection xaConnection, CallableStatement realCallableStatement, String sql) throws SQLException {
        this(xaConnection);
        this.realCallableStatement = realCallableStatement;
        this.applicationStatement = this.applicationConnection.newBrokeredStatement(this, sql);
        ((EmbedStatement)((Object)realCallableStatement)).setApplicationStatement(this.applicationStatement);
    }

    @Override
    public void closeRealStatement() throws SQLException {
        this.realStatement.close();
    }

    @Override
    public void closeRealCallableStatement() throws SQLException {
        this.realCallableStatement.close();
    }

    @Override
    public void closeRealPreparedStatement() throws SQLException {
        this.realPreparedStatement.close();
    }

    @Override
    public Statement getRealStatement() throws SQLException {
        if (this.applicationConnection == this.xaConnection.currentConnectionHandle) {
            if (this.realConnection == this.xaConnection.realConnection) {
                return this.realStatement;
            }
            if (this.xaConnection.realConnection == null) {
                this.xaConnection.getRealConnection();
            }
            Statement newStatement = this.applicationStatement.createDuplicateStatement(this.xaConnection.realConnection, this.realStatement);
            ((EmbedStatement)this.realStatement).transferBatch((EmbedStatement)newStatement);
            try {
                this.realStatement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.realStatement = newStatement;
            this.realConnection = this.xaConnection.realConnection;
            ((EmbedStatement)this.realStatement).setApplicationStatement(this.applicationStatement);
        }
        return this.realStatement;
    }

    @Override
    public PreparedStatement getRealPreparedStatement() throws SQLException {
        if (this.applicationConnection == this.xaConnection.currentConnectionHandle) {
            if (this.realConnection == this.xaConnection.realConnection) {
                return this.realPreparedStatement;
            }
            if (this.xaConnection.realConnection == null) {
                this.xaConnection.getRealConnection();
            }
            PreparedStatement newPreparedStatement = ((BrokeredPreparedStatement)this.applicationStatement).createDuplicateStatement((Connection)this.xaConnection.realConnection, this.realPreparedStatement);
            ((EmbedPreparedStatement)this.realPreparedStatement).transferParameters((EmbedPreparedStatement)newPreparedStatement);
            try {
                this.realPreparedStatement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.realPreparedStatement = newPreparedStatement;
            this.realConnection = this.xaConnection.realConnection;
            ((EmbedStatement)((Object)this.realPreparedStatement)).setApplicationStatement(this.applicationStatement);
        }
        return this.realPreparedStatement;
    }

    @Override
    public CallableStatement getRealCallableStatement() throws SQLException {
        if (this.applicationConnection == this.xaConnection.currentConnectionHandle) {
            if (this.realConnection == this.xaConnection.realConnection) {
                return this.realCallableStatement;
            }
            if (this.xaConnection.realConnection == null) {
                this.xaConnection.getRealConnection();
            }
            CallableStatement newCallableStatement = ((BrokeredCallableStatement)this.applicationStatement).createDuplicateStatement((Connection)this.xaConnection.realConnection, this.realCallableStatement);
            ((EmbedStatement)((Object)this.realCallableStatement)).transferBatch((EmbedStatement)((Object)newCallableStatement));
            try {
                this.realCallableStatement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.realCallableStatement = newCallableStatement;
            this.realConnection = this.xaConnection.realConnection;
            ((EmbedStatement)((Object)this.realCallableStatement)).setApplicationStatement(this.applicationStatement);
        }
        return this.realCallableStatement;
    }

    @Override
    public ResultSet wrapResultSet(Statement s, ResultSet rs) {
        if (rs != null) {
            ((EmbedResultSet)rs).setApplicationStatement(s);
        }
        return rs;
    }

    @Override
    public int checkHoldCursors(int holdability) throws SQLException {
        return this.xaConnection.checkHoldCursors(holdability, true);
    }
}

