/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.ocl;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.commit.CDOChangeKind;
import org.eclipse.emf.cdo.common.commit.CDOChangeSetData;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.model.CDOPackageRegistry;
import org.eclipse.emf.cdo.common.revision.CDOIDAndVersion;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionCacheAdder;
import org.eclipse.emf.cdo.common.revision.CDORevisionHandler;
import org.eclipse.emf.cdo.common.revision.CDORevisionInterner;
import org.eclipse.emf.cdo.server.CDOServerUtil;
import org.eclipse.emf.cdo.server.ISession;
import org.eclipse.emf.cdo.server.IStoreAccessor;
import org.eclipse.emf.cdo.server.StoreThreadLocal;
import org.eclipse.emf.cdo.server.ocl.OCLExtentCreator;
import org.eclipse.emf.cdo.spi.server.InternalRepository;
import org.eclipse.emf.cdo.util.ObjectNotFoundException;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.spi.cdo.InternalCDOObject;
import org.eclipse.net4j.util.concurrent.ConcurrencyUtil;

public class CDOExtentCreator
implements OCLExtentCreator {
    private CDOView view;
    private CDOChangeSetData changeSetData;
    private CDORevisionInterner revisionInterner;

    public CDOExtentCreator(CDOView view) {
        this.view = view;
    }

    public CDOView getView() {
        return this.view;
    }

    public CDOChangeSetData getChangeSetData() {
        return this.changeSetData;
    }

    public void setChangeSetData(CDOChangeSetData changeSetData) {
        this.changeSetData = changeSetData;
    }

    public CDORevisionInterner getRevisionInterner() {
        return this.revisionInterner;
    }

    public void setRevisionInterner(CDORevisionInterner revisionInterner) {
        this.revisionInterner = revisionInterner;
    }

    @Deprecated
    public CDORevisionCacheAdder getRevisionCacheAdder() {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public void setRevisionCacheAdder(CDORevisionCacheAdder revisionCacheAdder) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<EObject> createExtent(EClass eClass, AtomicBoolean canceled) {
        IStoreAccessor accessor = StoreThreadLocal.getAccessor();
        CDOBranch branch = this.view.getBranch();
        long timeStamp = this.view.getTimeStamp();
        return this.createExtent(eClass, accessor, branch, timeStamp, canceled);
    }

    protected Set<EObject> createExtent(EClass eClass, IStoreAccessor accessor, CDOBranch branch, long timeStamp, final AtomicBoolean canceled) {
        List newObjects;
        final HashSet<EObject> extent = new HashSet<EObject>();
        if (this.changeSetData != null && (newObjects = this.changeSetData.getNewObjects()) != null) {
            for (CDOIDAndVersion key : newObjects) {
                EObject object = this.getEObject(key.getID());
                if (object == null) continue;
                extent.add(object);
            }
        }
        CDORevisionHandler.Filtered.Undetached revisionHandler = new CDORevisionHandler.Filtered.Undetached(new CDORevisionHandler(){

            public boolean handleRevision(CDORevision revision) {
                EObject object;
                CDOID id;
                if (CDOExtentCreator.this.revisionInterner != null) {
                    revision = CDOExtentCreator.this.revisionInterner.internRevision(revision);
                }
                if (!CDOExtentCreator.this.isDetached(id = revision.getID()) && (object = CDOExtentCreator.this.getEObject(id)) != null) {
                    extent.add(object);
                }
                return !canceled.get();
            }
        });
        this.createExtent(eClass, accessor, branch, timeStamp, canceled, (CDORevisionHandler)revisionHandler);
        return extent;
    }

    protected void createExtent(EClass eClass, IStoreAccessor accessor, CDOBranch branch, long timeStamp, AtomicBoolean canceled, CDORevisionHandler revisionHandler) {
        this.handleRevisions(eClass, accessor, branch, timeStamp, revisionHandler);
        CDOPackageRegistry packageRegistry = accessor.getStore().getRepository().getPackageRegistry();
        List subTypes = (List)packageRegistry.getSubTypes().get(eClass);
        if (subTypes != null) {
            for (EClass subType : subTypes) {
                if (canceled.get()) break;
                this.handleRevisions(subType, accessor, branch, timeStamp, revisionHandler);
            }
        }
    }

    protected void handleRevisions(EClass eClass, IStoreAccessor accessor, CDOBranch branch, long timeStamp, CDORevisionHandler revisionHandler) {
        if (!eClass.isAbstract() && !eClass.isInterface()) {
            InternalRepository repository = (InternalRepository)accessor.getStore().getRepository();
            repository.handleRevisions(eClass, branch, false, timeStamp, false, revisionHandler);
        }
    }

    protected boolean isDetached(CDOID id) {
        if (this.changeSetData == null) {
            return false;
        }
        CDOChangeKind changeKind = this.changeSetData.getChangeKind(id);
        return changeKind == CDOChangeKind.DETACHED;
    }

    protected EObject getEObject(CDOID id) throws ObjectNotFoundException {
        InternalCDOObject object = (InternalCDOObject)this.view.getObject(id);
        if (object == null) {
            throw new ObjectNotFoundException(id);
        }
        return object.cdoInternalInstance();
    }

    public static class Lazy
    extends CDOExtentCreator {
        public Lazy(CDOView view) {
            super(view);
        }

        @Override
        protected Set<EObject> createExtent(final EClass eClass, final IStoreAccessor accessor, final CDOBranch branch, final long timeStamp, final AtomicBoolean canceled) {
            return new Set<EObject>(){
                private final CountDownLatch emptyKnown = new CountDownLatch(1);
                private Iterator<EObject> emptyIterator;
                private Boolean empty;

                @Override
                public synchronized boolean isEmpty() {
                    if (this.empty != null) {
                        return this.empty;
                    }
                    this.emptyIterator = this.iterator();
                    try {
                        this.emptyKnown.await();
                        return this.empty;
                    }
                    catch (InterruptedException ex) {
                        throw new Error("Interrupted");
                    }
                }

                @Override
                public synchronized Iterator<EObject> iterator() {
                    if (this.emptyIterator != null) {
                        Iterator<EObject> it = this.emptyIterator;
                        this.emptyIterator = null;
                        return it;
                    }
                    final Object mutex = new Object();
                    final LinkedList ids = new LinkedList();
                    final boolean[] done = new boolean[1];
                    ISession serverSession = CDOServerUtil.getServerSession((CDOView)this.getView());
                    ExecutorService threadPool = ConcurrencyUtil.getExecutorService((Object)this.getView());
                    class OCLExtentIterator
                    implements Runnable {
                        private final /* synthetic */ Object val$mutex;
                        private final /* synthetic */ boolean[] val$done;
                        private final /* synthetic */ EClass val$eClass;
                        private final /* synthetic */ IStoreAccessor val$accessor;
                        private final /* synthetic */ CDOBranch val$branch;
                        private final /* synthetic */ long val$timeStamp;
                        private final /* synthetic */ AtomicBoolean val$canceled;
                        private final /* synthetic */ LinkedList val$ids;

                        OCLExtentIterator(Object object, boolean[] blArray, EClass eClass, IStoreAccessor iStoreAccessor, CDOBranch cDOBranch, long l, AtomicBoolean atomicBoolean, LinkedList linkedList) {
                            this.val$mutex = object;
                            this.val$done = blArray;
                            this.val$eClass = eClass;
                            this.val$accessor = iStoreAccessor;
                            this.val$branch = cDOBranch;
                            this.val$timeStamp = l;
                            this.val$canceled = atomicBoolean;
                            this.val$ids = linkedList;
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            this.handleDirtyState();
                            this.handlePersistentState();
                            Object object = this.val$mutex;
                            synchronized (object) {
                                this.val$done[0] = true;
                                this.val$mutex.notify();
                            }
                            if (empty == null) {
                                empty = true;
                                emptyKnown.countDown();
                            }
                        }

                        private void handleDirtyState() {
                            List newObjects;
                            CDOChangeSetData changeSetData = this.getChangeSetData();
                            if (changeSetData != null && (newObjects = changeSetData.getNewObjects()) != null) {
                                for (CDOIDAndVersion key : newObjects) {
                                    this.enqueue(key.getID());
                                }
                            }
                        }

                        private void handlePersistentState() {
                            CDORevisionHandler.Filtered.Undetached revisionHandler = new CDORevisionHandler.Filtered.Undetached(new CDORevisionHandler(){

                                public boolean handleRevision(CDORevision revision) {
                                    empty = false;
                                    emptyKnown.countDown();
                                    CDORevisionInterner revisionInterner = this.getRevisionInterner();
                                    if (revisionInterner != null) {
                                        revision = revisionInterner.internRevision(revision);
                                    }
                                    CDOID id = revision.getID();
                                    if (!this.isDetached(id)) {
                                        this.enqueue(id);
                                    }
                                    return !val$canceled.get();
                                }
                            });
                            this.createExtent(this.val$eClass, this.val$accessor, this.val$branch, this.val$timeStamp, this.val$canceled, (CDORevisionHandler)revisionHandler);
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        private void enqueue(CDOID id) {
                            Object object = this.val$mutex;
                            synchronized (object) {
                                this.val$ids.addLast(id);
                                this.val$mutex.notify();
                            }
                        }
                    }
                    threadPool.submit(StoreThreadLocal.wrap((ISession)serverSession, (Runnable)new OCLExtentIterator(mutex, done, eClass, accessor, branch, timeStamp, canceled, ids)));
                    return new Iterator<EObject>(){
                        private CDOID next;

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         * Enabled aggressive block sorting
                         * Enabled unnecessary exception pruning
                         * Enabled aggressive exception aggregation
                         */
                        @Override
                        public boolean hasNext() {
                            while (this.next == null) {
                                if (canceled.get()) {
                                    return false;
                                }
                                Object object = mutex;
                                synchronized (object) {
                                    if (ids.isEmpty()) {
                                        if (done[0]) {
                                            return false;
                                        }
                                        try {
                                            mutex.wait(500L);
                                        }
                                        catch (InterruptedException ex) {
                                            throw new Error(ex);
                                        }
                                    } else {
                                        this.next = (CDOID)ids.removeFirst();
                                    }
                                }
                            }
                            return true;
                        }

                        @Override
                        public EObject next() {
                            if (!this.hasNext()) {
                                throw new NoSuchElementException();
                            }
                            try {
                                EObject eObject = this.getEObject(this.next);
                                return eObject;
                            }
                            finally {
                                this.next = null;
                            }
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException();
                        }
                    };
                }

                @Override
                public int size() {
                    throw new Error("Not supported");
                }

                @Override
                public boolean contains(Object o) {
                    throw new Error("Not supported");
                }

                @Override
                public Object[] toArray() {
                    throw new Error("Not supported");
                }

                @Override
                public <T> T[] toArray(T[] a) {
                    throw new Error("Not supported");
                }

                @Override
                public boolean add(EObject o) {
                    throw new Error("Not supported");
                }

                @Override
                public boolean remove(Object o) {
                    throw new Error("Not supported");
                }

                @Override
                public boolean containsAll(Collection<?> c) {
                    throw new Error("Not supported");
                }

                @Override
                public boolean addAll(Collection<? extends EObject> c) {
                    throw new Error("Not supported");
                }

                @Override
                public boolean retainAll(Collection<?> c) {
                    throw new Error("Not supported");
                }

                @Override
                public boolean removeAll(Collection<?> c) {
                    throw new Error("Not supported");
                }

                @Override
                public void clear() {
                    throw new Error("Not supported");
                }
            };
        }
    }
}

