/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.tests;

import java.util.Arrays;
import org.eclipse.net4j.signal.wrapping.XORStreamWrapperInjector;
import org.eclipse.net4j.tests.config.AbstractConfigTest;
import org.eclipse.net4j.tests.data.HugeData;
import org.eclipse.net4j.tests.data.TinyData;
import org.eclipse.net4j.tests.signal.ArrayRequest;
import org.eclipse.net4j.tests.signal.TestSignalProtocol;
import org.eclipse.net4j.util.container.IElementProcessor;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.io.IStreamWrapper;
import org.eclipse.net4j.util.io.XORStreamWrapper;

public class SignalStreamWrappingTest
extends AbstractConfigTest {
    private static final int[] KEY = new int[]{1, 2, 3, 4, 5};

    @Override
    protected IManagedContainer createContainer() {
        IManagedContainer container = super.createContainer();
        container.addPostProcessor((IElementProcessor)new XORStreamWrapperInjector("signal.protocol", KEY));
        return container;
    }

    public void testXORStreamWrapping() throws Exception {
        try (TestSignalProtocol protocol = null;){
            this.startTransport();
            protocol = new TestSignalProtocol(this.getConnector());
            protocol.setStreamWrapper((IStreamWrapper)new XORStreamWrapper(KEY));
            protocol.setTimeout(1000000L);
            byte[] data = HugeData.getBytes();
            byte[] result = (byte[])new ArrayRequest(protocol, data).send();
            SignalStreamWrappingTest.assertEquals((boolean)true, (boolean)Arrays.equals(data, result));
        }
    }

    public void testXORStreamWrappingWithMultipleSignals() throws Exception {
        try (TestSignalProtocol protocol = null;){
            this.startTransport();
            protocol = new TestSignalProtocol(this.getConnector());
            protocol.setStreamWrapper((IStreamWrapper)new XORStreamWrapper(KEY));
            protocol.setTimeout(1000000L);
            int i = 0;
            while (i < 20) {
                byte[] data = TinyData.getBytes();
                byte[] result = (byte[])new ArrayRequest(protocol, data).send();
                SignalStreamWrappingTest.assertEquals((boolean)true, (boolean)Arrays.equals(data, result));
                ++i;
            }
        }
    }
}

