/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.tools.dblook;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.SQLException;
import org.apache.derby.tools.dblook;

public class Logs {
    private static PrintWriter logFile = null;
    private static PrintWriter ddlFile = null;
    private static String stmtEnd;
    private static boolean verbose;
    private static boolean atLeastOneDebug;

    public static boolean initLogs(String logFileName, String ddlFileName, boolean appendLogs, boolean doVerbose, String endOfStmt) {
        try {
            logFile = new PrintWriter(new FileOutputStream(logFileName, appendLogs));
            ddlFile = ddlFileName == null ? null : new PrintWriter(new FileOutputStream(ddlFileName, appendLogs));
            verbose = doVerbose;
            stmtEnd = endOfStmt;
            atLeastOneDebug = false;
        }
        catch (IOException ioe) {
            System.out.println("Error initializing log file(s): " + ioe);
            return false;
        }
        return true;
    }

    public static void report(String msg) {
        if (ddlFile == null) {
            System.out.println("-- " + msg);
        } else {
            ddlFile.println("-- " + msg);
        }
    }

    public static void reportString(String str) {
        Logs.report(str);
    }

    public static void reportMessage(String key) {
        Logs.reportMessage(key, (String[])null);
    }

    public static void reportMessage(String key, String value) {
        Logs.reportMessage(key, new String[]{value});
    }

    public static void reportMessage(String key, String[] values) {
        String msg = dblook.lookupMessage(key, values);
        Logs.report(msg);
    }

    public static void debug(Exception e) {
        e.printStackTrace(logFile);
        if (verbose) {
            e.printStackTrace(System.err);
        }
        atLeastOneDebug = true;
    }

    public static void debug(String key, String value) {
        String msg = key;
        if (value != null) {
            msg = dblook.lookupMessage(key, new String[]{value});
        }
        logFile.println("-- **--> DEBUG: " + msg);
        if (verbose) {
            System.err.println("-- **--> DEBUG: " + msg);
        }
        atLeastOneDebug = true;
    }

    public static void debug(String key, String[] values) {
        String msg = key;
        if (values != null) {
            msg = dblook.lookupMessage(key, values);
        }
        logFile.println("-- **--> DEBUG: " + msg);
        if (verbose) {
            System.err.println("-- **--> DEBUG: " + msg);
        }
        atLeastOneDebug = true;
    }

    public static String unRollExceptions(SQLException sqlE) {
        String rv = sqlE.getMessage() + "\n";
        if (sqlE.getNextException() != null) {
            return rv + Logs.unRollExceptions(sqlE.getNextException());
        }
        return rv;
    }

    public static void writeToNewDDL(String sql) {
        if (ddlFile == null) {
            System.out.print(sql);
        } else {
            ddlFile.print(sql);
        }
    }

    public static void writeStmtEndToNewDDL() {
        if (ddlFile == null) {
            System.out.println(stmtEnd);
        } else {
            ddlFile.println(stmtEnd);
        }
    }

    public static void writeNewlineToNewDDL() {
        if (ddlFile == null) {
            System.out.println();
        } else {
            ddlFile.println();
        }
    }

    public static boolean cleanup() {
        try {
            if (atLeastOneDebug) {
                dblook.writeVerboseOutput("DBLOOK_AtLeastOneDebug", null);
            }
            logFile.close();
            if (ddlFile != null) {
                ddlFile.close();
            }
        }
        catch (Exception e) {
            System.out.println("Error releasing resources: " + e);
            return false;
        }
        return true;
    }
}

