/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.explorer.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.cdo.explorer.CDOExplorerUtil;
import org.eclipse.emf.cdo.explorer.checkouts.CDOCheckout;
import org.eclipse.emf.cdo.explorer.ui.BaseLabelDecorator;
import org.eclipse.emf.cdo.explorer.ui.bundle.OM;
import org.eclipse.emf.cdo.explorer.ui.checkouts.CDOCheckoutContentProvider;
import org.eclipse.emf.cdo.explorer.ui.checkouts.CDOCheckoutLabelProvider;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.DecoratingStyledCellLabelProvider;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.net4j.util.ui.views.ItemProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;

public class ObjectListController {
    private final CDOCheckoutContentProvider contentProvider = new CDOCheckoutContentProvider();
    private final LabelProvider labelProvider = new LabelProvider(this.contentProvider);
    private final AtomicBoolean refreshing = new AtomicBoolean();
    private final Set<EObject> objects = new HashSet<EObject>();
    private final List<Wrapper> wrappers = new ArrayList<Wrapper>();
    private final CDOCheckout checkout;

    public ObjectListController(CDOCheckout checkout) {
        this.checkout = checkout;
    }

    public final CDOCheckout getCheckout() {
        return this.checkout;
    }

    public final EObject getObject(Object wrapper) {
        if (wrapper instanceof Wrapper) {
            return ((Wrapper)wrapper).getObject();
        }
        return null;
    }

    public final void addObject(EObject object, boolean delete) {
        if (this.objects.add(object)) {
            String name = this.labelProvider.getSuperText(object);
            this.wrappers.add(new Wrapper(object, delete, name));
        }
    }

    public void configure(final TreeViewer treeViewer) {
        Control control = treeViewer.getControl();
        this.contentProvider.disposeWith(control);
        treeViewer.setContentProvider((IContentProvider)new ContentProvider());
        treeViewer.setLabelProvider((IBaseLabelProvider)new DecoratingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)this.labelProvider, (ILabelDecorator)new LabelDecorator(), null));
        treeViewer.setInput(this.wrappers);
        control.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                ObjectListController.this.configureAsync(treeViewer, ObjectListController.this.labelProvider);
            }
        });
    }

    protected void configureAsync(final TreeViewer treeViewer, final LabelProvider labelProvider) {
        if (treeViewer instanceof CheckboxTreeViewer) {
            CheckboxTreeViewer checkboxTreeViewer = (CheckboxTreeViewer)treeViewer;
            checkboxTreeViewer.setAllChecked(true);
        }
        new Job("Compute paths"){

            protected IStatus run(IProgressMonitor monitor) {
                ObjectListController.this.updateWrappers(treeViewer, labelProvider);
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateWrappers(TreeViewer treeViewer, LabelProvider labelProvider) {
        for (Wrapper wrapper : this.wrappers) {
            try {
                boolean hasPath;
                List<Wrapper> list = this.wrappers;
                synchronized (list) {
                    hasPath = wrapper.computePath(this.checkout, labelProvider);
                }
                if (!hasPath) continue;
                this.refresh(treeViewer);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void refresh(final TreeViewer treeViewer) {
        Control control;
        if (!this.refreshing.getAndSet(true) && !(control = treeViewer.getControl()).isDisposed()) {
            control.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ObjectListController.this.refreshing.set(false);
                    treeViewer.refresh(ObjectListController.this.wrappers);
                }
            });
        }
    }

    private final class ContentProvider
    implements ITreeContentProvider {
        private ContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object[] getElements(Object element) {
            if (element == ObjectListController.this.wrappers) {
                Object[] result = ObjectListController.this.wrappers.toArray();
                List<Wrapper> list = ObjectListController.this.wrappers;
                synchronized (list) {
                    Arrays.sort(result);
                }
                return result;
            }
            return ItemProvider.NO_ELEMENTS;
        }

        public Object getParent(Object element) {
            return null;
        }

        public Object[] getChildren(Object element) {
            return this.getElements(element);
        }

        public boolean hasChildren(Object element) {
            return element == ObjectListController.this.wrappers && !ObjectListController.this.wrappers.isEmpty();
        }
    }

    private static final class LabelDecorator
    extends BaseLabelDecorator {
        private static final Image DELETE_OVERLAY_IMAGE = OM.getImage("icons/delete_ovr.gif");

        private LabelDecorator() {
        }

        @Override
        public Image decorateImage(Image image, Object element) {
            Wrapper wrapper;
            if (element instanceof Wrapper && (wrapper = (Wrapper)element).isDelete()) {
                return OM.getOverlayImage(image, DELETE_OVERLAY_IMAGE, 9, 0);
            }
            return super.decorateImage(image, element);
        }

        @Override
        public String decorateText(String text, Object element) {
            if (element instanceof Wrapper && !text.equals("/")) {
                Wrapper wrapper = (Wrapper)element;
                String path = wrapper.getPath();
                if (path != null) {
                    text = String.valueOf(path) + "/" + text;
                }
                return text;
            }
            return super.decorateText(text, element);
        }
    }

    private static final class LabelProvider
    extends CDOCheckoutLabelProvider {
        public LabelProvider(CDOCheckoutContentProvider contentProvider) {
            super(contentProvider);
        }

        @Override
        public Image getImage(Object element) {
            if (element instanceof Wrapper) {
                Wrapper wrapper = (Wrapper)element;
                return super.getImage(wrapper.getObject());
            }
            return super.getImage(element);
        }

        @Override
        public String getText(Object element) {
            if (element instanceof Wrapper) {
                Wrapper wrapper = (Wrapper)element;
                String name = wrapper.getName();
                if (name.length() == 0) {
                    return "/";
                }
                return name;
            }
            return this.getSuperText(element);
        }

        public String getSuperText(Object element) {
            return super.getText(element);
        }
    }

    private static final class Wrapper
    implements Comparable<Wrapper> {
        private final EObject object;
        private final boolean delete;
        private final String name;
        private String path;

        public Wrapper(EObject object, boolean delete, String name) {
            this.object = object;
            this.delete = delete;
            this.name = name;
        }

        public final EObject getObject() {
            return this.object;
        }

        public final boolean isDelete() {
            return this.delete;
        }

        public final String getPath() {
            return this.path;
        }

        public final String getName() {
            return this.name;
        }

        public boolean computePath(CDOCheckout checkout, LabelProvider labelProvider) {
            LinkedList nodes = CDOExplorerUtil.getPath((Object)this.object);
            if (nodes != null) {
                nodes.removeLast();
                StringBuilder builder = new StringBuilder();
                boolean first = true;
                for (Object node : nodes) {
                    builder.append('/');
                    if (first) {
                        builder.append(checkout.getLabel());
                        first = false;
                        continue;
                    }
                    builder.append(labelProvider.getText(node));
                }
                this.path = builder.toString();
                return true;
            }
            return false;
        }

        @Override
        public int compareTo(Wrapper o) {
            return this.toString().compareTo(o.toString());
        }

        public String toString() {
            if (this.path != null) {
                return String.valueOf(this.path) + this.name;
            }
            return this.name;
        }
    }
}

