/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.commons.runtime;

import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.lsp4mp.commons.runtime.DiagnosticsCollector;
import org.eclipse.lsp4mp.commons.runtime.EnumConstantsProvider;
import org.eclipse.lsp4mp.commons.runtime.ExecutionMode;
import org.eclipse.lsp4mp.commons.runtime.MicroProfileRuntimeSupport;
import org.eclipse.lsp4mp.commons.runtime.ProjectClassLoader;
import org.eclipse.lsp4mp.commons.runtime.TypeProvider;
import org.eclipse.lsp4mp.commons.runtime.TypeSignatureParser;
import org.eclipse.lsp4mp.commons.runtime.converter.ConverterRuntimeSupportApi;
import org.eclipse.lsp4mp.commons.runtime.converter.full.FullConverterRuntimeSupport;
import org.eclipse.lsp4mp.commons.runtime.converter.safe.SafeConverterRuntimeSupport;

public class MicroProfileProjectRuntime
implements TypeProvider {
    private static final Logger LOGGER = Logger.getLogger(MicroProfileProjectRuntime.class.getName());
    private final Map<Class<? extends MicroProfileRuntimeSupport>, MicroProfileRuntimeSupport> safeRuntimesSupport = new HashMap<Class<? extends MicroProfileRuntimeSupport>, MicroProfileRuntimeSupport>();
    private final Map<Class<? extends MicroProfileRuntimeSupport>, MicroProfileRuntimeSupport> fullRuntimesSupport = new HashMap<Class<? extends MicroProfileRuntimeSupport>, MicroProfileRuntimeSupport>();
    private final ClassLoader parentClassLoader = Thread.currentThread().getContextClassLoader();
    private ProjectClassLoader runtimeClassLoader;
    private Set<String> classpath;

    public MicroProfileProjectRuntime(Set<String> classpath) {
        this.updateClassPath(classpath);
        this.loadRuntimeSupports();
        this.registerRuntimeSupport(new SafeConverterRuntimeSupport(this));
        this.registerRuntimeSupport(new FullConverterRuntimeSupport(this));
    }

    public void validateValue(String value, String type, EnumConstantsProvider enumConstNamesProvider, ExecutionMode preferredMode, DiagnosticsCollector collector) {
        ConverterRuntimeSupportApi converterRuntimeSupport = this.getRuntimeSupport(ConverterRuntimeSupportApi.class, preferredMode);
        if (!converterRuntimeSupport.hasConfigProviderResolver()) {
            converterRuntimeSupport = this.getRuntimeSupport(ConverterRuntimeSupportApi.class, ExecutionMode.SAFE);
        }
        converterRuntimeSupport.validate(value, type, enumConstNamesProvider, collector);
    }

    private void loadRuntimeSupports() {
        try {
            ServiceLoader<MicroProfileRuntimeSupport> loader = ServiceLoader.load(MicroProfileRuntimeSupport.class, this.getRuntimeClassLoader());
            for (MicroProfileRuntimeSupport runtimeSupport : loader) {
                this.registerRuntimeSupport(runtimeSupport);
            }
        }
        catch (Throwable t) {
            LOGGER.log(Level.WARNING, "Failed to load runtime supports via ServiceLoader", t);
        }
    }

    public <T extends MicroProfileRuntimeSupport> T getRuntimeSupport(Class<T> type, ExecutionMode executionMode) {
        if (executionMode == ExecutionMode.FULL) {
            return (T)((MicroProfileRuntimeSupport)type.cast(this.fullRuntimesSupport.get(type)));
        }
        return (T)((MicroProfileRuntimeSupport)type.cast(this.safeRuntimesSupport.get(type)));
    }

    public <T extends MicroProfileRuntimeSupport> void registerRuntimeSupport(T runtimeSupport) {
        if (runtimeSupport.getExecutionMode() == ExecutionMode.FULL) {
            this.fullRuntimesSupport.put(runtimeSupport.getClassApi(), runtimeSupport);
        } else {
            this.safeRuntimesSupport.put(runtimeSupport.getClassApi(), runtimeSupport);
        }
    }

    public ClassLoader getRuntimeClassLoader() {
        return this.runtimeClassLoader;
    }

    public void updateClassPath(Set<String> classpath) {
        this.classpath = classpath;
        this.runtimeClassLoader = new ProjectClassLoader(classpath, this.parentClassLoader);
        this.fullRuntimesSupport.values().forEach(MicroProfileRuntimeSupport::reset);
        this.safeRuntimesSupport.values().forEach(MicroProfileRuntimeSupport::reset);
    }

    @Override
    public Type findType(String type, EnumConstantsProvider enumConstNamesProvider, ExecutionMode executionMode) {
        ClassLoader classLoader = executionMode == ExecutionMode.FULL ? this.getRuntimeClassLoader() : this.parentClassLoader;
        return MicroProfileProjectRuntime.findType(type, enumConstNamesProvider, classLoader);
    }

    public static Type findType(String type, EnumConstantsProvider enumConstNamesProvider, ClassLoader classLoader) {
        try {
            return MicroProfileProjectRuntime.forNameSmart(type, enumConstNamesProvider, classLoader);
        }
        catch (Exception exception) {
            List<String> enumConstNames;
            if ("jakarta.inject.Provider".equals(type)) {
                return new TypeSignatureParser.EmulateType(type);
            }
            if (enumConstNamesProvider != null && (enumConstNames = enumConstNamesProvider.getConstants(type)) != null) {
                return new TypeSignatureParser.EnumType(type, enumConstNames);
            }
            return null;
        }
    }

    private static Type forNameSmart(String typeName, EnumConstantsProvider enumConstNamesProvider, ClassLoader classLoader) throws ClassNotFoundException {
        switch (typeName) {
            case "int": {
                return Integer.TYPE;
            }
            case "boolean": {
                return Boolean.TYPE;
            }
            case "byte": {
                return Byte.TYPE;
            }
            case "char": {
                return Character.TYPE;
            }
            case "short": {
                return Short.TYPE;
            }
            case "long": {
                return Long.TYPE;
            }
            case "float": {
                return Float.TYPE;
            }
            case "double": {
                return Double.TYPE;
            }
            case "void": {
                return Void.TYPE;
            }
        }
        if (typeName.endsWith("[]")) {
            String element = typeName.substring(0, typeName.length() - 2);
            Class elementClass = (Class)MicroProfileProjectRuntime.forNameSmart(element, enumConstNamesProvider, classLoader);
            return Array.newInstance(elementClass, 0).getClass();
        }
        if (typeName.indexOf(60) == -1) {
            return Class.forName(typeName, false, classLoader);
        }
        return TypeSignatureParser.parse(typeName, enumConstNamesProvider, classLoader);
    }

    public void clearProjectClassCache() {
        this.classpath.clear();
        this.runtimeClassLoader.clearProjectClassCache();
    }

    public Set<String> getClasspath() {
        return this.classpath;
    }
}

