/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.rename;

import java.net.URI;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.internal.NullSafetyHelper;
import org.eclipse.lsp4e.operations.rename.LSPFileOperationParticipantSupport;
import org.eclipse.lsp4j.FileOperationsServerCapabilities;
import org.eclipse.lsp4j.FileRename;
import org.eclipse.lsp4j.RenameFilesParams;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.MoveParticipant;

public class LSPMoveParticipant
extends MoveParticipant {
    private URI oldURI = (URI)NullSafetyHelper.lateNonNull();
    private URI newURI = (URI)NullSafetyHelper.lateNonNull();
    private IResource resource = (IResource)NullSafetyHelper.lateNonNull();

    public String getName() {
        return "LSP4E Move";
    }

    protected boolean initialize(Object element) {
        IResource res;
        if (element instanceof IResource && ((res = (IResource)element) instanceof IFile || res instanceof IFolder)) {
            this.resource = res;
            URI uri = LSPEclipseUtils.toUri(res);
            if (uri == null) {
                return false;
            }
            this.oldURI = uri;
            Object dest = this.getArguments().getDestination();
            IPath destLoc = null;
            if (dest instanceof IResource) {
                IResource destRes = (IResource)dest;
                destLoc = destRes.getRawLocation();
            } else if (dest instanceof IPath) {
                IPath destPath;
                destLoc = destPath = (IPath)dest;
            }
            if (destLoc == null) {
                return false;
            }
            String targetName = res.getName();
            this.newURI = LSPEclipseUtils.toUri(destLoc.append(targetName));
            return LSPFileOperationParticipantSupport.createFileOperationExecutor(res, FileOperationsServerCapabilities::getWillRename).anyMatching();
        }
        return false;
    }

    public RefactoringStatus checkConditions(IProgressMonitor monitor, CheckConditionsContext context) throws OperationCanceledException {
        return new RefactoringStatus();
    }

    public @Nullable Change createChange(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        return null;
    }

    public @Nullable Change createPreChange(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        RenameFilesParams params = new RenameFilesParams();
        params.getFiles().add(new FileRename(this.oldURI.toString(), this.newURI.toString()));
        return LSPFileOperationParticipantSupport.computePreChange(this.getName(), params, this.resource, FileOperationsServerCapabilities::getWillRename, (ws, p) -> ws.willRenameFiles(p));
    }
}

