/**
 */
package distributions.impl;

import distributions.*;

import distributions.math.ModeDistribution;
import org.apache.commons.math3.random.RandomGenerator;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;

import org.eclipse.emf.ecore.impl.EFactoryImpl;

import org.eclipse.emf.ecore.plugin.EcorePlugin;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Factory</b>.
 * <!-- end-user-doc -->
 * @generated
 */
public class DistributionsFactoryImpl extends EFactoryImpl implements DistributionsFactory
{
    /**
     * Creates the default factory implementation.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public static DistributionsFactory init()
    {
        try
        {
            DistributionsFactory theDistributionsFactory = (DistributionsFactory)EPackage.Registry.INSTANCE.getEFactory(DistributionsPackage.eNS_URI);
            if (theDistributionsFactory != null)
            {
                return theDistributionsFactory;
            }
        }
        catch (Exception exception)
        {
            EcorePlugin.INSTANCE.log(exception);
        }
        return new DistributionsFactoryImpl();
    }

    /**
     * Creates an instance of the factory.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public DistributionsFactoryImpl()
    {
        super();
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public EObject create(EClass eClass)
    {
        switch (eClass.getClassifierID())
        {
            case DistributionsPackage.TRIANGULAR_DISTRIBUTION: return createTriangularDistribution();
            case DistributionsPackage.PERT_DISTRIBUTION: return createPertDistribution();
            case DistributionsPackage.NORMAL_DISTRIBUTION: return createNormalDistribution();
            case DistributionsPackage.ENUMERATED_DISTRIBUTION: return createEnumeratedDistribution();
            case DistributionsPackage.GAMMA_DISTRIBUTION: return createGammaDistribution();
            case DistributionsPackage.POISSON_DISTRIBUTION: return createPoissonDistribution();
            case DistributionsPackage.LOG_NORMAL_DISTRIBUTION: return createLogNormalDistribution();
            default:
                throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
        }
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Object createFromString(EDataType eDataType, String initialValue)
    {
        switch (eDataType.getClassifierID())
        {
            case DistributionsPackage.CALCULATION_MODE:
                return createCalculationModeFromString(eDataType, initialValue);
            case DistributionsPackage.RANDOM_GENERATOR:
                return createRandomGeneratorFromString(eDataType, initialValue);
            case DistributionsPackage.MODE_DISTRIBUTION:
                return createModeDistributionFromString(eDataType, initialValue);
            default:
                throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
        }
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public String convertToString(EDataType eDataType, Object instanceValue)
    {
        switch (eDataType.getClassifierID())
        {
            case DistributionsPackage.CALCULATION_MODE:
                return convertCalculationModeToString(eDataType, instanceValue);
            case DistributionsPackage.RANDOM_GENERATOR:
                return convertRandomGeneratorToString(eDataType, instanceValue);
            case DistributionsPackage.MODE_DISTRIBUTION:
                return convertModeDistributionToString(eDataType, instanceValue);
            default:
                throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
        }
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public TriangularDistribution createTriangularDistribution()
    {
        TriangularDistributionImpl triangularDistribution = new TriangularDistributionImpl();
        return triangularDistribution;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public PertDistribution createPertDistribution()
    {
        PertDistributionImpl pertDistribution = new PertDistributionImpl();
        return pertDistribution;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public NormalDistribution createNormalDistribution()
    {
        NormalDistributionImpl normalDistribution = new NormalDistributionImpl();
        return normalDistribution;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public EnumeratedDistribution createEnumeratedDistribution()
    {
        EnumeratedDistributionImpl enumeratedDistribution = new EnumeratedDistributionImpl();
        return enumeratedDistribution;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public GammaDistribution createGammaDistribution()
    {
        GammaDistributionImpl gammaDistribution = new GammaDistributionImpl();
        return gammaDistribution;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public PoissonDistribution createPoissonDistribution()
    {
        PoissonDistributionImpl poissonDistribution = new PoissonDistributionImpl();
        return poissonDistribution;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public LogNormalDistribution createLogNormalDistribution()
    {
        LogNormalDistributionImpl logNormalDistribution = new LogNormalDistributionImpl();
        return logNormalDistribution;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public CalculationMode createCalculationModeFromString(EDataType eDataType, String initialValue)
    {
        CalculationMode result = CalculationMode.get(initialValue);
        if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        return result;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public String convertCalculationModeToString(EDataType eDataType, Object instanceValue)
    {
        return instanceValue == null ? null : instanceValue.toString();
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public RandomGenerator createRandomGeneratorFromString(EDataType eDataType, String initialValue)
    {
        return (RandomGenerator)super.createFromString(eDataType, initialValue);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public String convertRandomGeneratorToString(EDataType eDataType, Object instanceValue)
    {
        return super.convertToString(eDataType, instanceValue);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public ModeDistribution createModeDistributionFromString(EDataType eDataType, String initialValue)
    {
        return (ModeDistribution)super.createFromString(eDataType, initialValue);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public String convertModeDistributionToString(EDataType eDataType, Object instanceValue)
    {
        return super.convertToString(eDataType, instanceValue);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public DistributionsPackage getDistributionsPackage()
    {
        return (DistributionsPackage)getEPackage();
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @deprecated
     * @generated
     */
    @Deprecated
    public static DistributionsPackage getPackage()
    {
        return DistributionsPackage.eINSTANCE;
    }

} //DistributionsFactoryImpl
